/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.text;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import java.text.BreakIterator;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextMeasurer;
import org.afree.graphics.PaintType;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.TextAnchor;

public abstract class TextUtilities {
    private static boolean useFontMetricsGetStringBounds = false;

    public static TextBlock createTextBlock(String text, Font font, PaintType paintType, float maxWidth, TextMeasurer measurer) {
        return TextUtilities.createTextBlock(text, font, paintType, maxWidth, Integer.MAX_VALUE, measurer);
    }

    public static TextBlock createTextBlock(String text, Font font, PaintType paintType) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        TextBlock result = new TextBlock();
        String input = text;
        boolean moreInputToProcess = text.length() > 0;
        boolean start = false;
        while (moreInputToProcess) {
            int index = input.indexOf("\n");
            if (index > 0) {
                String line = input.substring(0, index);
                if (index < input.length() - 1) {
                    result.addLine(line, font, paintType);
                    input = input.substring(index + 1);
                    continue;
                }
                moreInputToProcess = false;
                continue;
            }
            if (index == 0) {
                if (index < input.length() - 1) {
                    input = input.substring(index + 1);
                    continue;
                }
                moreInputToProcess = false;
                continue;
            }
            result.addLine(input, font, paintType);
            moreInputToProcess = false;
        }
        return result;
    }

    public static TextBlock createTextBlock(String text, Font font, PaintType paintType, float maxWidth, int maxLines, TextMeasurer measurer) {
        TextBlock result = new TextBlock();
        BreakIterator iterator = BreakIterator.getLineInstance();
        iterator.setText(text);
        int current = 0;
        int lines = 0;
        int length = text.length();
        while (current < length && lines < maxLines) {
            int next = TextUtilities.nextLineBreak(text, current, maxWidth, iterator, measurer);
            if (next == -1) {
                result.addLine(text.substring(current), font, paintType);
                return result;
            }
            result.addLine(text.substring(current, next), font, paintType);
            ++lines;
            current = next;
        }
        return result;
    }

    private static int nextLineBreak(String text, int start, float width, BreakIterator iterator, TextMeasurer measurer) {
        int end;
        int current = start;
        float x = 0.0f;
        boolean firstWord = true;
        while ((end = iterator.next()) != -1) {
            if ((x += measurer.getStringWidth(text, current, end)) > width) {
                if (firstWord) {
                    while (measurer.getStringWidth(text, start, end) > width) {
                        --end;
                    }
                    return end;
                }
                end = iterator.previous();
                return end;
            }
            firstWord = false;
            current = end;
        }
        return -1;
    }

    public static RectShape getTextBounds(String text, Paint paint) {
        Rect bounds = new Rect();
        if (!text.equals("")) {
            paint.getTextBounds(text, 0, text.length(), bounds);
        }
        Paint.FontMetrics fontMetrix = paint.getFontMetrics();
        bounds.bottom = (int)fontMetrix.bottom;
        bounds.top = (int)fontMetrix.top;
        return new RectShape(bounds);
    }

    public static float getTextWidth(String text, Paint paint) {
        return paint.measureText(text);
    }

    public static float getTextHeight(Paint paint) {
        Paint.FontMetrics fontMetrix = paint.getFontMetrics();
        int bottom = (int)fontMetrix.bottom;
        int top = (int)fontMetrix.top;
        return bottom - top;
    }

    public static boolean getUseFontMetricsGetStringBounds() {
        return useFontMetricsGetStringBounds;
    }

    public static void setUseFontMetricsGetStringBounds(boolean use) {
        useFontMetricsGetStringBounds = use;
    }

    public static void drawRotatedString(String text, Canvas canvas, float x, float y, TextAnchor textAnchor, double angle, TextAnchor rotationAnchor, Paint paint) {
        if (text == null || text.equals("")) {
            return;
        }
        float[] textAdjust = TextUtilities.deriveTextBoundsAnchorOffsets(canvas, text, textAnchor, paint);
        float[] rotateAdjust = TextUtilities.deriveTextBoundsAnchorOffsets(canvas, text, rotationAnchor, paint);
        canvas.save();
        canvas.translate(x + textAdjust[0], y + textAdjust[1]);
        canvas.rotate((float)Math.toDegrees(angle), -rotateAdjust[0], -rotateAdjust[1]);
        canvas.drawText(text, 0.0f, 0.0f, paint);
        canvas.restore();
    }

    public static RectShape drawAlignedString(String text, Canvas canvas, float x, float y, TextAnchor anchor, Paint paint) {
        RectShape textBounds = new RectShape();
        float[] adjust = TextUtilities.deriveTextBoundsAnchorOffsets(canvas, text, anchor, paint);
        paint.setTextAlign(Paint.Align.LEFT);
        textBounds.setRect(x + adjust[0], y + adjust[1] + adjust[2], textBounds.getWidth(), textBounds.getHeight());
        canvas.drawText(text, x + adjust[0], y + adjust[1], paint);
        return textBounds;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Canvas canvas, String text, TextAnchor anchor, Paint paint) {
        float[] result = new float[3];
        Paint.FontMetrics fm = paint.getFontMetrics();
        float width = TextUtilities.getTextWidth(text, paint);
        float height = TextUtilities.getTextHeight(paint);
        float ascent = fm.ascent;
        result[2] = -ascent;
        float halfAscent = ascent / 2.0f;
        float descent = fm.descent;
        float leading = fm.leading;
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = -width * 0.5f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = -width;
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = -descent - leading + height;
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = halfAscent;
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = -descent - leading + height * 0.5f;
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = -fm.descent - fm.leading;
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static RectShape calculateRotatedStringBounds(String text, Paint paint, float anchorX, float anchorY, TextAnchor textAnchor, double rotationAngle, TextAnchor rotationAnchor) {
        if (text == null || text.equals("")) {
            return null;
        }
        float[] textAdj = TextUtilities.deriveTextBoundsAnchorOffsets(paint, text, textAnchor);
        float[] rotateAdj = TextUtilities.deriveRotationAnchorOffsets(paint, text, rotationAnchor);
        RectShape result = TextUtilities.calculateRotatedStringBounds(text, paint, anchorX + textAdj[0], anchorY + textAdj[1], rotationAngle, anchorX + textAdj[0] + rotateAdj[0], anchorY + textAdj[1] + rotateAdj[1]);
        return result;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Paint paint, String text, TextAnchor anchor) {
        float[] result = new float[2];
        Paint.FontMetrics fm = paint.getFontMetrics();
        RectShape bounds = TextUtilities.getTextBounds(text, paint);
        float ascent = Math.abs(fm.ascent);
        float halfAscent = ascent / 2.0f;
        float descent = Math.abs(fm.descent);
        float leading = Math.abs(fm.leading);
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = -bounds.getWidth() / 2.0f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = -bounds.getWidth();
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = -descent - leading + bounds.getHeight();
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = halfAscent;
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = -descent - leading + (float)((double)bounds.getHeight() / 2.0);
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = -Math.abs(fm.descent) - Math.abs(fm.leading);
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    private static float[] deriveRotationAnchorOffsets(Paint paint, String text, TextAnchor anchor) {
        float[] result = new float[2];
        Paint.FontMetrics fm = paint.getFontMetrics();
        RectShape bounds = TextUtilities.getTextBounds(text, paint);
        float ascent = fm.ascent;
        float halfAscent = ascent / 2.0f;
        float descent = fm.descent;
        float leading = fm.leading;
        float xAdj = 0.0f;
        float yAdj = 0.0f;
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.HALF_ASCENT_LEFT) {
            xAdj = 0.0f;
        } else if (anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.CENTER || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.HALF_ASCENT_CENTER) {
            xAdj = bounds.getWidth() / 2.0f;
        } else if (anchor == TextAnchor.TOP_RIGHT || anchor == TextAnchor.CENTER_RIGHT || anchor == TextAnchor.BOTTOM_RIGHT || anchor == TextAnchor.BASELINE_RIGHT || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            xAdj = bounds.getWidth();
        }
        if (anchor == TextAnchor.TOP_LEFT || anchor == TextAnchor.TOP_CENTER || anchor == TextAnchor.TOP_RIGHT) {
            yAdj = descent + leading - bounds.getHeight();
        } else if (anchor == TextAnchor.CENTER_LEFT || anchor == TextAnchor.CENTER || anchor == TextAnchor.CENTER_RIGHT) {
            yAdj = descent + leading - (float)((double)bounds.getHeight() / 2.0);
        } else if (anchor == TextAnchor.HALF_ASCENT_LEFT || anchor == TextAnchor.HALF_ASCENT_CENTER || anchor == TextAnchor.HALF_ASCENT_RIGHT) {
            yAdj = -halfAscent;
        } else if (anchor == TextAnchor.BASELINE_LEFT || anchor == TextAnchor.BASELINE_CENTER || anchor == TextAnchor.BASELINE_RIGHT) {
            yAdj = 0.0f;
        } else if (anchor == TextAnchor.BOTTOM_LEFT || anchor == TextAnchor.BOTTOM_CENTER || anchor == TextAnchor.BOTTOM_RIGHT) {
            yAdj = fm.descent + fm.leading;
        }
        result[0] = xAdj;
        result[1] = yAdj;
        return result;
    }

    public static RectShape calculateRotatedStringBounds(String text, Paint paint, float textX, float textY, double angle, float rotateX, float rotateY) {
        if (text == null || text.equals("")) {
            return null;
        }
        RectShape bounds = TextUtilities.getTextBounds(text, paint);
        bounds.translate(textX, textY);
        Matrix rotate = new Matrix();
        rotate.postRotate((float)angle, rotateX, rotateY);
        Path path = new Path(bounds.getPath());
        path.transform(rotate);
        RectF rect = new RectF();
        path.computeBounds(rect, false);
        PathShape pathShape = new PathShape(path);
        RectShape rectShape = new RectShape();
        pathShape.getBounds(rectShape);
        return rectShape;
    }
}

