/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.renderer.xy;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.HashUtilities;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.labels.XYToolTipGenerator;
import org.afree.chart.plot.CrosshairState;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.renderer.xy.XYItemRendererState;
import org.afree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.afree.chart.urls.XYURLGenerator;
import org.afree.data.xy.XYDataset;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;
import org.afree.util.PublicCloneable;

public class XYStepRenderer
extends XYLineAndShapeRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8918141928884796108L;
    private double stepPoint = 1.0;

    public XYStepRenderer() {
        this(null, null);
    }

    public XYStepRenderer(XYToolTipGenerator toolTipGenerator, XYURLGenerator urlGenerator) {
        this.setBaseShapesVisible(false);
    }

    public double getStepPoint() {
        return this.stepPoint;
    }

    public void setStepPoint(double stepPoint) {
        if (stepPoint < 0.0 || stepPoint > 1.0) {
            throw new IllegalArgumentException("Requires stepPoint in [0.0;1.0]");
        }
        this.stepPoint = stepPoint;
    }

    public void drawItem(Canvas canvas, XYItemRendererState state, RectShape dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        double transY1;
        if (!this.getItemVisible(series, item)) {
            return;
        }
        PlotOrientation orientation = plot.getOrientation();
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
        RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
        double transX1 = domainAxis.valueToJava2D(x1, dataArea, xAxisLocation);
        double d = transY1 = Double.isNaN(y1) ? Double.NaN : rangeAxis.valueToJava2D(y1, dataArea, yAxisLocation);
        if (pass == 0 && item > 0) {
            double transXs;
            double x0 = dataset.getXValue(series, item - 1);
            double y0 = dataset.getYValue(series, item - 1);
            double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
            double transY0 = Double.isNaN(y0) ? Double.NaN : rangeAxis.valueToJava2D(y0, dataArea, yAxisLocation);
            Paint paint = PaintUtility.createPaint(1, this.getItemPaintType(series, item), this.getItemStroke(series, item).floatValue(), this.getItemEffect(series, item));
            if (orientation == PlotOrientation.HORIZONTAL) {
                if (transY0 == transY1) {
                    this.drawLine(canvas, state.workingLine, transY0, transX0, transY1, transX1, paint);
                } else {
                    transXs = transX0 + this.getStepPoint() * (transX1 - transX0);
                    this.drawLine(canvas, state.workingLine, transY0, transX0, transY0, transXs, paint);
                    this.drawLine(canvas, state.workingLine, transY0, transXs, transY1, transXs, paint);
                    this.drawLine(canvas, state.workingLine, transY1, transXs, transY1, transX1, paint);
                }
            } else if (orientation == PlotOrientation.VERTICAL) {
                if (transY0 == transY1) {
                    this.drawLine(canvas, state.workingLine, transX0, transY0, transX1, transY1, paint);
                } else {
                    transXs = transX0 + this.getStepPoint() * (transX1 - transX0);
                    this.drawLine(canvas, state.workingLine, transX0, transY0, transXs, transY0, paint);
                    this.drawLine(canvas, state.workingLine, transXs, transY0, transXs, transY1, paint);
                    this.drawLine(canvas, state.workingLine, transXs, transY1, transX1, transY1, paint);
                }
            }
            int domainAxisIndex = plot.getDomainAxisIndex(domainAxis);
            int rangeAxisIndex = plot.getRangeAxisIndex(rangeAxis);
            this.updateCrosshairValues(crosshairState, x1, y1, domainAxisIndex, rangeAxisIndex, transX1, transY1, orientation);
            EntityCollection entities = state.getEntityCollection();
            if (entities != null) {
                this.addEntity(entities, null, dataset, series, item, transX1, transY1);
            }
        }
        if (pass == 1 && this.isItemLabelVisible(series, item)) {
            double xx = transX1;
            double yy = transY1;
            if (orientation == PlotOrientation.HORIZONTAL) {
                xx = transY1;
                yy = transX1;
            }
            this.drawItemLabel(canvas, orientation, dataset, series, item, xx, yy, y1 < 0.0);
        }
    }

    private void drawLine(Canvas canvas, LineShape line, double x0, double y0, double x1, double y1, Paint paint) {
        if (Double.isNaN(x0) || Double.isNaN(x1) || Double.isNaN(y0) || Double.isNaN(y1)) {
            return;
        }
        line.setLine(x0, y0, x1, y1);
        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYLineAndShapeRenderer)) {
            return false;
        }
        XYStepRenderer that = (XYStepRenderer)obj;
        if (this.stepPoint != that.stepPoint) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return HashUtilities.hashCode(super.hashCode(), this.stepPoint);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

