/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot.dial;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.plot.dial.AbstractDialLayer;
import org.afree.chart.plot.dial.DialLayer;
import org.afree.chart.plot.dial.DialLayerChangeEvent;
import org.afree.chart.plot.dial.DialPlot;
import org.afree.chart.plot.dial.DialScale;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.ArcShape;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.io.SerialUtilities;

public abstract class DialPointer
extends AbstractDialLayer
implements DialLayer,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2483972458546357143L;
    double radius = 0.9;
    int datasetIndex;

    protected DialPointer() {
        this(0);
    }

    protected DialPointer(int datasetIndex) {
        this.datasetIndex = datasetIndex;
    }

    public int getDatasetIndex() {
        return this.datasetIndex;
    }

    public void setDatasetIndex(int index) {
        this.datasetIndex = index;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public boolean isClippedToWindow() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DialPointer)) {
            return false;
        }
        DialPointer that = (DialPointer)obj;
        if (this.datasetIndex != that.datasetIndex) {
            return false;
        }
        if (this.radius != that.radius) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public static class Pin
    extends DialPointer {
        static final long serialVersionUID = -8445860485367689750L;
        private transient Paint paint = new Paint();
        private transient Float stroke;

        public Pin() {
            this(0);
        }

        public Pin(int datasetIndex) {
            super(datasetIndex);
            this.paint.setColor(-65536);
            this.stroke = Float.valueOf(3.0f);
        }

        public Paint getPaint() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            if (paint == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.paint = paint;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public Float getStroke() {
            return this.stroke;
        }

        public void setStroke(Float stroke) {
            if (stroke == null) {
                throw new IllegalArgumentException("Null 'stroke' argument.");
            }
            this.stroke = stroke;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public void draw(Canvas canvas, DialPlot plot, RectShape frame, Shape view) {
            this.paint.setStrokeWidth(this.stroke.floatValue());
            RectShape arcRect = DialPlot.RectShapeByRadius(frame, this.radius, this.radius);
            double value = plot.getValue(this.datasetIndex);
            DialScale scale = plot.getScaleForDataset(this.datasetIndex);
            double angle = scale.valueToAngle(value);
            ArcShape arc = new ArcShape(arcRect, angle, 0.0, true);
            PointF pt = arc.getEndPoint();
            LineShape line = new LineShape(frame.getCenterX(), frame.getCenterY(), pt.x, pt.y);
            line.draw(canvas, this.paint);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Pin)) {
                return false;
            }
            Pin that = (Pin)obj;
            if (!this.stroke.equals(that.stroke)) {
                return false;
            }
            return super.equals(obj);
        }
    }

    public static class Pointer
    extends DialPointer {
        static final long serialVersionUID = -4180500011963176960L;
        private double widthRadius = 0.05;
        private transient PaintType fillPaintType = new SolidColor(-7829368);
        private transient PaintType outlinePaintType = new SolidColor(-16777216);

        public Pointer() {
            this(0);
        }

        public Pointer(int datasetIndex) {
            super(datasetIndex);
        }

        public double getWidthRadius() {
            return this.widthRadius;
        }

        public void setWidthRadius(double radius) {
            this.widthRadius = radius;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public PaintType getFillPaintType() {
            return this.fillPaintType;
        }

        public void setFillPaintType(PaintType paintType) {
            if (paintType == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.fillPaintType = paintType;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public PaintType getOutlinePaintType() {
            return this.outlinePaintType;
        }

        public void setOutlinePaintType(PaintType paintType) {
            if (paintType == null) {
                throw new IllegalArgumentException("Null 'paint' argument.");
            }
            this.outlinePaintType = paintType;
            this.notifyListeners(new DialLayerChangeEvent(this));
        }

        public void draw(Canvas canvas, DialPlot plot, RectShape frame, Shape view) {
            Paint paint = new Paint();
            paint.setColor(-16776961);
            paint.setStrokeWidth(1.0f);
            RectShape lengthRect = DialPlot.RectShapeByRadius(frame, this.radius, this.radius);
            RectShape widthRect = DialPlot.RectShapeByRadius(frame, this.widthRadius, this.widthRadius);
            double value = plot.getValue(this.datasetIndex);
            DialScale scale = plot.getScaleForDataset(this.datasetIndex);
            double angle = scale.valueToAngle(value);
            ArcShape arc1 = new ArcShape(lengthRect, angle, 0.0, true);
            PointF pt1 = arc1.getEndPoint();
            ArcShape arc2 = new ArcShape(widthRect, angle - 90.0, 180.0, true);
            PointF pt2 = arc2.getStartPoint();
            PointF pt3 = arc2.getEndPoint();
            ArcShape arc3 = new ArcShape(widthRect, angle - 180.0, 0.0, true);
            PointF pt4 = arc3.getStartPoint();
            PathShape gp = new PathShape();
            gp.moveTo(pt1.x, pt1.y);
            gp.lineTo(pt2.x, pt2.y);
            gp.lineTo(pt4.x, pt4.y);
            gp.lineTo(pt3.x, pt3.y);
            gp.closePath();
            Paint fillPaint = PaintUtility.createPaint(1, this.fillPaintType);
            gp.draw(canvas, fillPaint);
            LineShape line = new LineShape(frame.getCenterX(), frame.getCenterY(), pt1.x, pt1.y);
            Paint outlinePaint = PaintUtility.createPaint(this.outlinePaintType);
            line.draw(canvas, outlinePaint);
            line.setLine(pt2, pt3);
            line.draw(canvas, outlinePaint);
            line.setLine(pt3, pt1);
            line.draw(canvas, outlinePaint);
            line.setLine(pt2, pt1);
            line.draw(canvas, outlinePaint);
            line.setLine(pt2, pt4);
            line.draw(canvas, outlinePaint);
            line.setLine(pt3, pt4);
            line.draw(canvas, outlinePaint);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Pointer)) {
                return false;
            }
            Pointer that = (Pointer)obj;
            if (this.widthRadius != that.widthRadius) {
                return false;
            }
            return super.equals(obj);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            SerialUtilities.writePaintType(this.fillPaintType, stream);
            SerialUtilities.writePaintType(this.outlinePaintType, stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.fillPaintType = SerialUtilities.readPaintType(stream);
            this.outlinePaintType = SerialUtilities.readPaintType(stream);
        }
    }
}

