/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.block;

import android.graphics.Canvas;
import android.graphics.PointF;
import org.afree.chart.block.AbstractBlock;
import org.afree.chart.block.Block;
import org.afree.chart.block.BlockResult;
import org.afree.chart.block.EntityBlockParams;
import org.afree.chart.block.RectangleConstraint;
import org.afree.chart.entity.ChartEntity;
import org.afree.chart.entity.StandardEntityCollection;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextBlockAnchor;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleAnchor;
import org.afree.ui.Size2D;

public class LabelBlock
extends AbstractBlock
implements Block {
    static final long serialVersionUID = 249626098864178017L;
    private String text;
    private TextBlock label;
    private Font font;
    private String toolTipText;
    private String urlText;
    public static final PaintType DEFAULT_PAINT_TYPE = new SolidColor(-16777216);
    private transient PaintType paintType;
    private TextBlockAnchor contentAlignmentPoint;
    private RectangleAnchor textAnchor;

    public LabelBlock(String label) {
        this(label, new Font("SansSerif", 0, 10), DEFAULT_PAINT_TYPE);
    }

    public LabelBlock(String text, Font font) {
        this(text, font, DEFAULT_PAINT_TYPE);
    }

    public LabelBlock(String text, Font font, PaintType paintType) {
        this.text = text;
        this.paintType = paintType;
        this.label = TextUtilities.createTextBlock(text, font, this.paintType);
        this.font = font;
        this.toolTipText = null;
        this.urlText = null;
        this.contentAlignmentPoint = TextBlockAnchor.CENTER;
        this.textAnchor = RectangleAnchor.CENTER;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.font = font;
        this.label = TextUtilities.createTextBlock(this.text, font, this.paintType);
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public void setPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paintType = paintType;
        this.label = TextUtilities.createTextBlock(this.text, this.font, this.paintType);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public TextBlockAnchor getContentAlignmentPoint() {
        return this.contentAlignmentPoint;
    }

    public void setContentAlignmentPoint(TextBlockAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.contentAlignmentPoint = anchor;
    }

    public RectangleAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(RectangleAnchor anchor) {
        this.textAnchor = anchor;
    }

    public Size2D arrange(Canvas canvas, RectangleConstraint constraint) {
        Size2D s = this.label.calculateDimensions(canvas);
        return new Size2D(this.calculateTotalWidth(s.getWidth()), this.calculateTotalHeight(s.getHeight()));
    }

    public void draw(Canvas canvas, RectShape area) {
        this.draw(canvas, area, null);
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        area = this.trimMargin(area);
        this.drawBorder(canvas, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        EntityBlockParams ebp = null;
        StandardEntityCollection sec = null;
        RectShape entityArea = null;
        if (params instanceof EntityBlockParams && (ebp = (EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
            entityArea = area.clone();
        }
        PointF pt = RectangleAnchor.coordinates(area, this.textAnchor);
        this.label.draw(canvas, pt.x, pt.y, this.contentAlignmentPoint);
        BlockResult result = null;
        if (ebp != null && sec != null && (this.toolTipText != null || this.urlText != null)) {
            ChartEntity entity = new ChartEntity(entityArea, this.toolTipText, this.urlText);
            sec.add(entity);
            result = new BlockResult();
            result.setEntityCollection(sec);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

