/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.axis;

import android.graphics.Canvas;
import java.io.Serializable;
import java.util.List;
import org.afree.chart.Effect3D;
import org.afree.chart.axis.AxisState;
import org.afree.chart.axis.NumberAxis;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.renderer.category.CategoryItemRenderer;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleEdge;

public class NumberAxis3D
extends NumberAxis
implements Serializable {
    private static final long serialVersionUID = -1790205852569123512L;

    public NumberAxis3D() {
        this(null);
    }

    public NumberAxis3D(String label) {
        super(label);
    }

    public AxisState draw(Canvas canvas, double cursor, RectShape plotArea, RectShape dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        CategoryPlot cp;
        CategoryItemRenderer r;
        if (!this.isVisible()) {
            AxisState state = new AxisState(cursor);
            List ticks = this.refreshTicks(canvas, state, dataArea, edge);
            state.setTicks(ticks);
            return state;
        }
        double xOffset = 0.0;
        double yOffset = 0.0;
        Plot plot = this.getPlot();
        if (plot instanceof CategoryPlot && (r = (cp = (CategoryPlot)plot).getRenderer()) instanceof Effect3D) {
            Effect3D e3D = (Effect3D)((Object)r);
            xOffset = e3D.getXOffset();
            yOffset = e3D.getYOffset();
        }
        double adjustedX = dataArea.getMinX();
        double adjustedY = dataArea.getMinY();
        double adjustedW = (double)dataArea.getWidth() - xOffset;
        double adjustedH = (double)dataArea.getHeight() - yOffset;
        if (edge == RectangleEdge.LEFT || edge == RectangleEdge.BOTTOM) {
            adjustedY += yOffset;
        } else if (edge == RectangleEdge.RIGHT || edge == RectangleEdge.TOP) {
            adjustedX += xOffset;
        }
        RectShape adjustedDataArea = new RectShape(adjustedX, adjustedY, adjustedW, adjustedH);
        AxisState info = this.drawTickMarksAndLabels(canvas, cursor, plotArea, adjustedDataArea, edge);
        info = this.drawLabel(this.getLabel(), canvas, plotArea, dataArea, edge, info);
        return info;
    }
}

