/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.annotations;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PathEffect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.annotations.XYTextAnnotation;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.text.TextUtilities;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.LineShape;
import org.afree.graphics.geom.PathShape;
import org.afree.graphics.geom.RectShape;
import org.afree.io.SerialUtilities;
import org.afree.ui.RectangleEdge;
import org.afree.util.ObjectUtilities;
import org.afree.util.PublicCloneable;

public class XYPointerAnnotation
extends XYTextAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4031161445009858551L;
    public static final double DEFAULT_TIP_RADIUS = 10.0;
    public static final double DEFAULT_BASE_RADIUS = 30.0;
    public static final double DEFAULT_LABEL_OFFSET = 3.0;
    public static final double DEFAULT_ARROW_LENGTH = 5.0;
    public static final double DEFAULT_ARROW_WIDTH = 3.0;
    private double angle;
    private double tipRadius;
    private double baseRadius;
    private double arrowLength;
    private double arrowWidth;
    private transient float arrowStroke;
    private transient PathEffect arrowEffect;
    private transient PaintType arrowPaintType;
    private double labelOffset;

    public XYPointerAnnotation(String label, double x, double y, double angle) {
        super(label, x, y);
        this.angle = angle;
        this.tipRadius = 10.0;
        this.baseRadius = 30.0;
        this.arrowLength = 5.0;
        this.arrowWidth = 3.0;
        this.labelOffset = 3.0;
        this.arrowStroke = 1.0f;
        this.arrowEffect = null;
        SolidColor black = new SolidColor(-16777216);
        this.arrowPaintType = black;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getTipRadius() {
        return this.tipRadius;
    }

    public void setTipRadius(double radius) {
        this.tipRadius = radius;
    }

    public double getBaseRadius() {
        return this.baseRadius;
    }

    public void setBaseRadius(double radius) {
        this.baseRadius = radius;
    }

    public double getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(double offset) {
        this.labelOffset = offset;
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double length) {
        this.arrowLength = length;
    }

    public double getArrowWidth() {
        return this.arrowWidth;
    }

    public void setArrowWidth(double width) {
        this.arrowWidth = width;
    }

    public float getArrowStroke() {
        return this.arrowStroke;
    }

    public void setArrowStroke(float stroke) {
        if (stroke == 0.0f) {
            throw new IllegalArgumentException("Null 'stroke' not permitted.");
        }
        this.arrowStroke = stroke;
    }

    public PaintType getArrowPaintType() {
        return this.arrowPaintType;
    }

    public void setArrowPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.arrowPaintType = paintType;
    }

    public PathEffect getArrowPaintEffect() {
        return this.arrowEffect;
    }

    public void setArrowPaintEffect(PathEffect pathEffect) {
        if (pathEffect == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.arrowEffect = pathEffect;
    }

    public void draw(Canvas canvas, XYPlot plot, RectShape dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        double j2DX = domainAxis.valueToJava2D(this.getX(), dataArea, domainEdge);
        double j2DY = rangeAxis.valueToJava2D(this.getY(), dataArea, rangeEdge);
        if (orientation == PlotOrientation.HORIZONTAL) {
            double temp = j2DX;
            j2DX = j2DY;
            j2DY = temp;
        }
        double startX = j2DX + Math.cos(this.angle) * this.baseRadius;
        double startY = j2DY + Math.sin(this.angle) * this.baseRadius;
        double endX = j2DX + Math.cos(this.angle) * this.tipRadius;
        double endY = j2DY + Math.sin(this.angle) * this.tipRadius;
        double arrowBaseX = endX + Math.cos(this.angle) * this.arrowLength;
        double arrowBaseY = endY + Math.sin(this.angle) * this.arrowLength;
        double arrowLeftX = arrowBaseX + Math.cos(this.angle + 1.5707963267948966) * this.arrowWidth;
        double arrowLeftY = arrowBaseY + Math.sin(this.angle + 1.5707963267948966) * this.arrowWidth;
        double arrowRightX = arrowBaseX - Math.cos(this.angle + 1.5707963267948966) * this.arrowWidth;
        double arrowRightY = arrowBaseY - Math.sin(this.angle + 1.5707963267948966) * this.arrowWidth;
        PathShape arrow = new PathShape();
        arrow.moveTo((float)endX, (float)endY);
        arrow.lineTo((float)arrowLeftX, (float)arrowLeftY);
        arrow.lineTo((float)arrowRightX, (float)arrowRightY);
        arrow.closePath();
        Paint paint = PaintUtility.createPaint(1, this.arrowPaintType, this.arrowStroke, this.arrowEffect);
        LineShape line = new LineShape(startX, startY, endX, endY);
        canvas.drawLine(line.getX1(), line.getY1(), line.getX2(), line.getY2(), paint);
        canvas.drawPath(arrow.getPath(), paint);
        double labelX = j2DX + Math.cos(this.angle) * (this.baseRadius + this.labelOffset);
        double labelY = j2DY + Math.sin(this.angle) * (this.baseRadius + this.labelOffset);
        if (this.getBackgroundPaintType() != null) {
            PaintUtility.updatePaint(paint, this.getBackgroundPaintType());
            canvas.drawPaint(paint);
        }
        PaintUtility.updatePaint(paint, this.getPaintType());
        TextUtilities.drawRotatedString(this.getText(), canvas, (float)labelX, (float)labelY, this.getTextAnchor(), this.getRotationAngle(), this.getRotationAnchor(), paint);
        if (this.isOutlineVisible()) {
            PaintUtility.updatePaint(paint, this.getOutlinePaintType());
            paint.setStrokeWidth(this.getOutlineStroke());
            canvas.drawLine((float)startX, (float)startY, (float)endX, (float)endY, paint);
        }
        String toolTip = this.getToolTipText();
        String url = this.getURL();
        RectShape hotspot = TextUtilities.getTextBounds(this.getText(), paint);
        if (toolTip != null || url != null) {
            this.addEntity(info, hotspot, rendererIndex, toolTip, url);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYPointerAnnotation)) {
            return false;
        }
        XYPointerAnnotation that = (XYPointerAnnotation)obj;
        if (this.angle != that.angle) {
            return false;
        }
        if (this.tipRadius != that.tipRadius) {
            return false;
        }
        if (this.baseRadius != that.baseRadius) {
            return false;
        }
        if (this.arrowLength != that.arrowLength) {
            return false;
        }
        if (this.arrowWidth != that.arrowWidth) {
            return false;
        }
        if (!this.arrowPaintType.equals(that.arrowPaintType)) {
            return false;
        }
        if (!ObjectUtilities.equal(Float.valueOf(this.arrowStroke), Float.valueOf(that.arrowStroke))) {
            return false;
        }
        if (this.labelOffset != that.labelOffset) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.angle);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.tipRadius);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.baseRadius);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.arrowLength);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.arrowWidth);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.labelOffset);
        result = 37 * result + (int)(temp ^ temp >>> 32);
        return super.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.arrowPaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.arrowPaintType = SerialUtilities.readPaintType(stream);
    }
}

