/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.annotations;

import android.graphics.Canvas;
import java.io.Serializable;
import org.afree.chart.annotations.AbstractXYAnnotation;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.XYPlot;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.Drawable;
import org.afree.ui.RectangleEdge;
import org.afree.util.ObjectUtilities;
import org.afree.util.PublicCloneable;

public class XYDrawableAnnotation
extends AbstractXYAnnotation
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -6540812859722691020L;
    private double drawScaleFactor;
    private double x;
    private double y;
    private double displayWidth;
    private double displayHeight;
    private Drawable drawable;

    public XYDrawableAnnotation(double x, double y, double width, double height, Drawable drawable) {
        this(x, y, width, height, 1.0, drawable);
    }

    public XYDrawableAnnotation(double x, double y, double displayWidth, double displayHeight, double drawScaleFactor, Drawable drawable) {
        if (drawable == null) {
            throw new IllegalArgumentException("Null 'drawable' argument.");
        }
        this.x = x;
        this.y = y;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.drawScaleFactor = drawScaleFactor;
        this.drawable = drawable;
    }

    public void draw(Canvas canvas, XYPlot plot, RectShape dataArea, ValueAxis domainAxis, ValueAxis rangeAxis, int rendererIndex, PlotRenderingInfo info) {
        PlotOrientation orientation = plot.getOrientation();
        RectangleEdge domainEdge = Plot.resolveDomainAxisLocation(plot.getDomainAxisLocation(), orientation);
        RectangleEdge rangeEdge = Plot.resolveRangeAxisLocation(plot.getRangeAxisLocation(), orientation);
        float j2DX = (float)domainAxis.valueToJava2D(this.x, dataArea, domainEdge);
        float j2DY = (float)rangeAxis.valueToJava2D(this.y, dataArea, rangeEdge);
        RectShape displayArea = new RectShape((double)j2DX - this.displayWidth / 2.0, (double)j2DY - this.displayHeight / 2.0, this.displayWidth, this.displayHeight);
        canvas.save();
        RectShape drawArea = new RectShape(0.0, 0.0, this.displayWidth * this.drawScaleFactor, this.displayHeight * this.drawScaleFactor);
        canvas.scale((float)(1.0 / this.drawScaleFactor), (float)(1.0 / this.drawScaleFactor));
        canvas.translate((float)(((double)j2DX - this.displayWidth / 2.0) * this.drawScaleFactor), (float)(((double)j2DY - this.displayHeight / 2.0) * this.drawScaleFactor));
        this.drawable.draw(canvas, drawArea);
        canvas.restore();
        String toolTip = this.getToolTipText();
        String url = this.getURL();
        if (toolTip != null || url != null) {
            this.addEntity(info, displayArea, rendererIndex, toolTip, url);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof XYDrawableAnnotation)) {
            return false;
        }
        XYDrawableAnnotation that = (XYDrawableAnnotation)obj;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        if (this.displayWidth != that.displayWidth) {
            return false;
        }
        if (this.displayHeight != that.displayHeight) {
            return false;
        }
        if (this.drawScaleFactor != that.drawScaleFactor) {
            return false;
        }
        return ObjectUtilities.equal(this.drawable, that.drawable);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.x);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.displayWidth);
        result = 29 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.displayHeight);
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

