/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart;

import android.graphics.Color;
import android.graphics.PathEffect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.afree.chart.AFreeChart;
import org.afree.chart.ChartTheme;
import org.afree.chart.annotations.XYAnnotation;
import org.afree.chart.axis.CategoryAxis;
import org.afree.chart.axis.SymbolAxis;
import org.afree.chart.axis.ValueAxis;
import org.afree.chart.block.Block;
import org.afree.chart.block.BlockContainer;
import org.afree.chart.block.LabelBlock;
import org.afree.chart.plot.CategoryPlot;
import org.afree.chart.plot.CombinedDomainCategoryPlot;
import org.afree.chart.plot.CombinedDomainXYPlot;
import org.afree.chart.plot.CombinedRangeCategoryPlot;
import org.afree.chart.plot.CombinedRangeXYPlot;
import org.afree.chart.plot.DefaultDrawingSupplier;
import org.afree.chart.plot.DrawingSupplier;
import org.afree.chart.plot.PieLabelLinkStyle;
import org.afree.chart.plot.PiePlot;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.XYPlot;
import org.afree.chart.renderer.AbstractRenderer;
import org.afree.chart.renderer.category.BarPainter;
import org.afree.chart.renderer.category.BarRenderer;
import org.afree.chart.renderer.category.BarRenderer3D;
import org.afree.chart.renderer.category.CategoryItemRenderer;
import org.afree.chart.renderer.category.GradientBarPainter;
import org.afree.chart.renderer.xy.GradientXYBarPainter;
import org.afree.chart.renderer.xy.XYBarPainter;
import org.afree.chart.renderer.xy.XYBarRenderer;
import org.afree.chart.renderer.xy.XYItemRenderer;
import org.afree.chart.title.LegendTitle;
import org.afree.chart.title.TextTitle;
import org.afree.chart.title.Title;
import org.afree.graphics.PaintType;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.io.SerialUtilities;
import org.afree.ui.RectangleInsets;
import org.afree.util.PaintTypeUtilities;
import org.afree.util.PublicCloneable;

public class StandardChartTheme
implements ChartTheme,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5657231725996574858L;
    private String name;
    private Font extraLargeFont;
    private Font largeFont;
    private Font regularFont;
    private Font smallFont;
    private transient PaintType titlePaintType;
    private transient PaintType subtitlePaintType;
    private transient PaintType chartBackgroundPaintType;
    private transient PaintType legendBackgroundPaintType;
    private transient PaintType legendItemPaintType;
    private DrawingSupplier drawingSupplierType;
    private transient PaintType plotBackgroundPaintType;
    private transient PaintType plotOutlinePaintType;
    private PieLabelLinkStyle labelLinkStyle;
    private transient PaintType labelLinkPaintType;
    private transient PaintType domainGridlinePaintType;
    private transient PaintType rangeGridlinePaintType;
    private transient PaintType baselinePaintType;
    private transient PaintType crosshairPaintType;
    private RectangleInsets axisOffset;
    private transient PaintType axisLabelPaintType;
    private transient PaintType tickLabelPaintType;
    private transient PaintType itemLabelPaintType;
    private boolean shadowVisible;
    private transient PaintType shadowPaintType;
    private BarPainter barPainter;
    private XYBarPainter xyBarPainter;
    private transient PaintType thermometerPaint;
    private transient PaintType wallPaintType;
    private transient PaintType errorIndicatorPaintType;
    private transient PaintType gridBandPaintType = SymbolAxis.DEFAULT_GRID_BAND_PAINT_TYPE;
    private transient PaintType gridBandAlternatePaintType = SymbolAxis.DEFAULT_GRID_BAND_ALTERNATE_PAINT_TYPE;

    public static ChartTheme createJFreeTheme() {
        return new StandardChartTheme("JFree");
    }

    public static ChartTheme createDarknessTheme() {
        StandardChartTheme theme = new StandardChartTheme("Darkness");
        theme.titlePaintType = StandardChartTheme.createPaintType(-1);
        theme.subtitlePaintType = StandardChartTheme.createPaintType(-1);
        theme.legendBackgroundPaintType = StandardChartTheme.createPaintType(-16777216);
        theme.legendItemPaintType = StandardChartTheme.createPaintType(-1);
        theme.chartBackgroundPaintType = StandardChartTheme.createPaintType(-16777216);
        theme.plotBackgroundPaintType = StandardChartTheme.createPaintType(-16777216);
        theme.plotOutlinePaintType = StandardChartTheme.createPaintType(-256);
        theme.baselinePaintType = StandardChartTheme.createPaintType(-1);
        theme.crosshairPaintType = StandardChartTheme.createPaintType(-65536);
        theme.labelLinkPaintType = StandardChartTheme.createPaintType(-3355444);
        theme.tickLabelPaintType = StandardChartTheme.createPaintType(-1);
        theme.axisLabelPaintType = StandardChartTheme.createPaintType(-1);
        theme.shadowPaintType = StandardChartTheme.createPaintType(-12303292);
        theme.itemLabelPaintType = StandardChartTheme.createPaintType(-1);
        theme.drawingSupplierType = new DefaultDrawingSupplier(new PaintType[]{StandardChartTheme.createPaintType(Integer.decode("0xFFFF00")), StandardChartTheme.createPaintType(Integer.decode("0x0036CC")), StandardChartTheme.createPaintType(Integer.decode("0xFF0000")), StandardChartTheme.createPaintType(Integer.decode("0xFFFF7F")), StandardChartTheme.createPaintType(Integer.decode("0x6681CC")), StandardChartTheme.createPaintType(Integer.decode("0xFF7F7F")), StandardChartTheme.createPaintType(Integer.decode("0xFFFFBF")), StandardChartTheme.createPaintType(Integer.decode("0x99A6CC")), StandardChartTheme.createPaintType(Integer.decode("0xFFBFBF")), StandardChartTheme.createPaintType(Integer.decode("0xA9A938")), StandardChartTheme.createPaintType(Integer.decode("0x2D4587"))}, new PaintType[]{StandardChartTheme.createPaintType(Integer.decode("0xFFFF00")), StandardChartTheme.createPaintType(Integer.decode("0x0036CC"))}, new float[]{2.0f}, new PathEffect[1], new float[]{0.5f}, new PathEffect[1], DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        theme.wallPaintType = StandardChartTheme.createPaintType(-12303292);
        theme.errorIndicatorPaintType = StandardChartTheme.createPaintType(-3355444);
        theme.gridBandPaintType = StandardChartTheme.createPaintType(Color.argb((int)20, (int)255, (int)255, (int)255));
        theme.gridBandAlternatePaintType = StandardChartTheme.createPaintType(Color.argb((int)40, (int)255, (int)255, (int)255));
        return theme;
    }

    public static ChartTheme createLegacyTheme() {
        StandardChartTheme theme = new StandardChartTheme("Legacy"){
            private static final long serialVersionUID = -741206071198207569L;

            public void apply(AFreeChart chart) {
            }
        };
        return theme;
    }

    public StandardChartTheme(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null 'name' argument.");
        }
        this.name = name;
        this.extraLargeFont = new Font("Tahoma", 1, 20);
        this.largeFont = new Font("Tahoma", 1, 14);
        this.regularFont = new Font("Tahoma", 0, 12);
        this.smallFont = new Font("Tahoma", 0, 10);
        this.titlePaintType = StandardChartTheme.createPaintType(-16777216);
        this.subtitlePaintType = StandardChartTheme.createPaintType(-16777216);
        this.legendBackgroundPaintType = StandardChartTheme.createPaintType(-1);
        this.legendItemPaintType = StandardChartTheme.createPaintType(-12303292);
        this.chartBackgroundPaintType = StandardChartTheme.createPaintType(-1);
        this.drawingSupplierType = new DefaultDrawingSupplier();
        this.plotBackgroundPaintType = StandardChartTheme.createPaintType(-3355444);
        this.plotOutlinePaintType = StandardChartTheme.createPaintType(-16777216);
        this.labelLinkPaintType = StandardChartTheme.createPaintType(-16777216);
        this.labelLinkStyle = PieLabelLinkStyle.CUBIC_CURVE;
        this.axisOffset = new RectangleInsets(4.0, 4.0, 4.0, 4.0);
        this.domainGridlinePaintType = StandardChartTheme.createPaintType(-1);
        this.rangeGridlinePaintType = StandardChartTheme.createPaintType(-1);
        this.baselinePaintType = StandardChartTheme.createPaintType(-16777216);
        this.crosshairPaintType = StandardChartTheme.createPaintType(-16776961);
        this.axisLabelPaintType = StandardChartTheme.createPaintType(-12303292);
        this.tickLabelPaintType = StandardChartTheme.createPaintType(-12303292);
        this.barPainter = new GradientBarPainter();
        this.xyBarPainter = new GradientXYBarPainter();
        this.shadowVisible = true;
        this.shadowPaintType = StandardChartTheme.createPaintType(-7829368);
        this.itemLabelPaintType = StandardChartTheme.createPaintType(-16777216);
        this.thermometerPaint = StandardChartTheme.createPaintType(-1);
        this.wallPaintType = BarRenderer3D.DEFAULT_WALL_PAINT;
        this.errorIndicatorPaintType = StandardChartTheme.createPaintType(-16777216);
    }

    public Font getExtraLargeFont() {
        return this.extraLargeFont;
    }

    public void setExtraLargeFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.extraLargeFont = font;
    }

    public Font getLargeFont() {
        return this.largeFont;
    }

    public void setLargeFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.largeFont = font;
    }

    public Font getRegularFont() {
        return this.regularFont;
    }

    public void setRegularFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.regularFont = font;
    }

    public Font getSmallFont() {
        return this.smallFont;
    }

    public void setSmallFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.smallFont = font;
    }

    public PaintType getTitlePaintType() {
        return this.titlePaintType;
    }

    public void setTitlePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.titlePaintType = paintType;
    }

    public PaintType getSubtitlePaintType() {
        return this.subtitlePaintType;
    }

    public void setSubtitlePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.subtitlePaintType = paintType;
    }

    public PaintType getChartBackgroundPaintType() {
        return this.chartBackgroundPaintType;
    }

    public void setChartBackgroundPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.chartBackgroundPaintType = paintType;
    }

    public PaintType getLegendBackgroundPaintType() {
        return this.legendBackgroundPaintType;
    }

    public void setLegendBackgroundPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.legendBackgroundPaintType = paintType;
    }

    public PaintType getLegendItemPaintType() {
        return this.legendItemPaintType;
    }

    public void setLegendItemPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.legendItemPaintType = paintType;
    }

    public PaintType getPlotBackgroundPaintType() {
        return this.plotBackgroundPaintType;
    }

    public void setPlotBackgroundPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.plotBackgroundPaintType = paintType;
    }

    public PaintType getPlotOutlinePaintType() {
        return this.plotOutlinePaintType;
    }

    public void setPlotOutlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.plotOutlinePaintType = paintType;
    }

    public PieLabelLinkStyle getLabelLinkStyle() {
        return this.labelLinkStyle;
    }

    public void setLabelLinkStyle(PieLabelLinkStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("Null 'style' argument.");
        }
        this.labelLinkStyle = style;
    }

    public PaintType getLabelLinkPaintType() {
        return this.labelLinkPaintType;
    }

    public void setLabelLinkPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelLinkPaintType = paintType;
    }

    public PaintType getDomainGridlinePaintType() {
        return this.domainGridlinePaintType;
    }

    public void setDomainGridlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaintType = paintType;
    }

    public PaintType getRangeGridlinePaintType() {
        return this.rangeGridlinePaintType;
    }

    public void setRangeGridlinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaintType = paintType;
    }

    public PaintType getBaselinePaintType() {
        return this.baselinePaintType;
    }

    public void setBaselinePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baselinePaintType = paintType;
    }

    public PaintType getCrosshairPaintType() {
        return this.crosshairPaintType;
    }

    public void setCrosshairPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.crosshairPaintType = paintType;
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets offset) {
        if (offset == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = offset;
    }

    public PaintType getAxisLabelPaintType() {
        return this.axisLabelPaintType;
    }

    public void setAxisLabelPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLabelPaintType = paintType;
    }

    public PaintType getTickLabelPaintType() {
        return this.tickLabelPaintType;
    }

    public void setTickLabelPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.tickLabelPaintType = paintType;
    }

    public PaintType getItemLabelPaintType() {
        return this.itemLabelPaintType;
    }

    public void setItemLabelPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemLabelPaintType = paintType;
    }

    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    public void setShadowVisible(boolean visible) {
        this.shadowVisible = visible;
    }

    public PaintType getShadowPaintType() {
        return this.shadowPaintType;
    }

    public void setShadowPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.shadowPaintType = paintType;
    }

    public BarPainter getBarPainter() {
        return this.barPainter;
    }

    public void setBarPainter(BarPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.barPainter = painter;
    }

    public XYBarPainter getXYBarPainter() {
        return this.xyBarPainter;
    }

    public void setXYBarPainter(XYBarPainter painter) {
        if (painter == null) {
            throw new IllegalArgumentException("Null 'painter' argument.");
        }
        this.xyBarPainter = painter;
    }

    public PaintType getThermometerPaintType() {
        return this.thermometerPaint;
    }

    public void setThermometerPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.thermometerPaint = paintType;
    }

    public PaintType getWallPaintType() {
        return this.wallPaintType;
    }

    public void setWallPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.wallPaintType = paintType;
    }

    public PaintType getErrorIndicatorPaintType() {
        return this.errorIndicatorPaintType;
    }

    public void setErrorIndicatorPaintType(PaintType paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.errorIndicatorPaintType = paint;
    }

    public PaintType getGridBandPaintType() {
        return this.gridBandPaintType;
    }

    public void setGridBandPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandPaintType = paintType;
    }

    public PaintType getGridBandAlternatePaintType() {
        return this.gridBandAlternatePaintType;
    }

    public void setGridBandAlternatePaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.gridBandAlternatePaintType = paintType;
    }

    public String getName() {
        return this.name;
    }

    public DrawingSupplier getDrawingSupplier() {
        DrawingSupplier result = null;
        if (this.drawingSupplierType instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)((Object)this.drawingSupplierType);
            try {
                result = (DrawingSupplier)pc.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setDrawingSupplier(DrawingSupplier supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("Null 'supplier' argument.");
        }
        this.drawingSupplierType = supplier;
    }

    public void apply(AFreeChart chart) {
        if (chart == null) {
            throw new IllegalArgumentException("Null 'chart' argument.");
        }
        TextTitle title = chart.getTitle();
        if (title != null) {
            title.setFont(this.extraLargeFont);
            title.setPaintType(this.titlePaintType);
        }
        int subtitleCount = chart.getSubtitleCount();
        int i = 0;
        while (i < subtitleCount) {
            this.applyToTitle(chart.getSubtitle(i));
            ++i;
        }
        chart.setBackgroundPaintType(this.chartBackgroundPaintType);
        Plot plot = chart.getPlot();
        if (plot != null) {
            this.applyToPlot(plot);
        }
    }

    protected void applyToTitle(Title title) {
        if (title instanceof TextTitle) {
            TextTitle tt = (TextTitle)title;
            tt.setFont(this.largeFont);
            tt.setPaintType(this.subtitlePaintType);
        } else if (title instanceof LegendTitle) {
            LegendTitle lt = (LegendTitle)title;
            if (lt.getBackgroundPaintType() != null) {
                lt.setBackgroundPaintType(this.legendBackgroundPaintType);
            }
            lt.setItemFont(this.regularFont);
            lt.setItemPaintType(this.legendItemPaintType);
            if (lt.getWrapper() != null) {
                this.applyToBlockContainer(lt.getWrapper());
            }
        }
    }

    protected void applyToBlockContainer(BlockContainer bc) {
        for (Block b : bc.getBlocks()) {
            this.applyToBlock(b);
        }
    }

    protected void applyToBlock(Block b) {
        if (b instanceof Title) {
            this.applyToTitle((Title)b);
        } else if (b instanceof LabelBlock) {
            LabelBlock lb = (LabelBlock)b;
            lb.setFont(this.regularFont);
            lb.setPaintType(this.legendItemPaintType);
        }
    }

    protected void applyToPlot(Plot plot) {
        if (plot == null) {
            throw new IllegalArgumentException("Null 'plot' argument.");
        }
        if (plot.getDrawingSupplier() != null) {
            plot.setDrawingSupplier(this.getDrawingSupplier());
        }
        if (plot.getBackgroundPaintType() != null) {
            plot.setBackgroundPaintType(this.plotBackgroundPaintType);
        }
        plot.setOutlinePaintType(this.plotOutlinePaintType);
        if (plot instanceof PiePlot) {
            this.applyToPiePlot((PiePlot)plot);
        } else if (plot instanceof CategoryPlot) {
            this.applyToCategoryPlot((CategoryPlot)plot);
        } else if (plot instanceof XYPlot) {
            this.applyToXYPlot((XYPlot)plot);
        }
    }

    protected void applyToPiePlot(PiePlot plot) {
        plot.setLabelLinkPaintType(this.labelLinkPaintType);
        plot.setLabelLinkStyle(this.labelLinkStyle);
        plot.setLabelFont(this.regularFont);
        if (plot.getAutoPopulateSectionPaint()) {
            plot.clearSectionPaints(false);
        }
        if (plot.getAutoPopulateSectionOutlinePaint()) {
            plot.clearSectionOutlinePaints(false);
        }
        if (plot.getAutoPopulateSectionOutlineStroke()) {
            plot.clearSectionOutlineStrokes(false);
        }
    }

    protected void applyToCategoryPlot(CategoryPlot plot) {
        plot.setAxisOffset(this.axisOffset);
        plot.setDomainGridlinePaintType(this.domainGridlinePaintType);
        plot.setRangeGridlinePaintType(this.rangeGridlinePaintType);
        plot.setRangeZeroBaselinePaintType(this.baselinePaintType);
        int domainAxisCount = plot.getDomainAxisCount();
        int i = 0;
        while (i < domainAxisCount) {
            CategoryAxis axis = plot.getDomainAxis(i);
            if (axis != null) {
                this.applyToCategoryAxis(axis);
            }
            ++i;
        }
        int rangeAxisCount = plot.getRangeAxisCount();
        int i2 = 0;
        while (i2 < rangeAxisCount) {
            ValueAxis axis = plot.getRangeAxis(i2);
            if (axis != null) {
                this.applyToValueAxis(axis);
            }
            ++i2;
        }
        int rendererCount = plot.getRendererCount();
        int i3 = 0;
        while (i3 < rendererCount) {
            CategoryItemRenderer r = plot.getRenderer(i3);
            if (r != null) {
                this.applyToCategoryItemRenderer(r);
            }
            ++i3;
        }
        if (plot instanceof CombinedDomainCategoryPlot) {
            CombinedDomainCategoryPlot cp = (CombinedDomainCategoryPlot)plot;
            for (CategoryPlot subplot : cp.getSubplots()) {
                if (subplot == null) continue;
                this.applyToPlot(subplot);
            }
        }
        if (plot instanceof CombinedRangeCategoryPlot) {
            CombinedRangeCategoryPlot cp = (CombinedRangeCategoryPlot)plot;
            for (CategoryPlot subplot : cp.getSubplots()) {
                if (subplot == null) continue;
                this.applyToPlot(subplot);
            }
        }
    }

    protected void applyToXYPlot(XYPlot plot) {
        XYPlot cp;
        plot.setAxisOffset(this.axisOffset);
        plot.setDomainZeroBaselinePaintType(this.baselinePaintType);
        plot.setRangeZeroBaselinePaintType(this.baselinePaintType);
        plot.setDomainGridlinePaintType(this.domainGridlinePaintType);
        plot.setRangeGridlinePaintType(this.rangeGridlinePaintType);
        plot.setDomainCrosshairPaintType(this.crosshairPaintType);
        plot.setRangeCrosshairPaintType(this.crosshairPaintType);
        int domainAxisCount = plot.getDomainAxisCount();
        int i = 0;
        while (i < domainAxisCount) {
            ValueAxis axis = plot.getDomainAxis(i);
            if (axis != null) {
                this.applyToValueAxis(axis);
            }
            ++i;
        }
        int rangeAxisCount = plot.getRangeAxisCount();
        int i2 = 0;
        while (i2 < rangeAxisCount) {
            ValueAxis axis = plot.getRangeAxis(i2);
            if (axis != null) {
                this.applyToValueAxis(axis);
            }
            ++i2;
        }
        int rendererCount = plot.getRendererCount();
        int i3 = 0;
        while (i3 < rendererCount) {
            XYItemRenderer r = plot.getRenderer(i3);
            if (r != null) {
                this.applyToXYItemRenderer(r);
            }
            ++i3;
        }
        for (XYAnnotation a : plot.getAnnotations()) {
            this.applyToXYAnnotation(a);
        }
        if (plot instanceof CombinedDomainXYPlot) {
            cp = (CombinedDomainXYPlot)plot;
            for (XYPlot subplot : ((CombinedDomainXYPlot)cp).getSubplots()) {
                if (subplot == null) continue;
                this.applyToPlot(subplot);
            }
        }
        if (plot instanceof CombinedRangeXYPlot) {
            cp = (CombinedRangeXYPlot)plot;
            for (XYPlot subplot : ((CombinedRangeXYPlot)cp).getSubplots()) {
                if (subplot == null) continue;
                this.applyToPlot(subplot);
            }
        }
    }

    protected void applyToCategoryAxis(CategoryAxis axis) {
        axis.setLabelFont(this.largeFont);
        axis.setLabelPaintType(this.axisLabelPaintType);
        axis.setTickLabelFont(this.regularFont);
        axis.setTickLabelPaintType(this.tickLabelPaintType);
    }

    protected void applyToValueAxis(ValueAxis axis) {
        axis.setLabelFont(this.largeFont);
        axis.setLabelPaintType(this.axisLabelPaintType);
        axis.setTickLabelFont(this.regularFont);
        axis.setTickLabelPaintType(this.tickLabelPaintType);
        if (axis instanceof SymbolAxis) {
            this.applyToSymbolAxis((SymbolAxis)axis);
        }
    }

    protected void applyToSymbolAxis(SymbolAxis axis) {
        axis.setGridBandPaintType(this.gridBandPaintType);
        axis.setGridBandAlternatePaintType(this.gridBandAlternatePaintType);
    }

    protected void applyToAbstractRenderer(AbstractRenderer renderer) {
        if (renderer.getAutoPopulateSeriesPaint()) {
            renderer.clearSeriesPaints(false);
        }
        if (renderer.getAutoPopulateSeriesStroke()) {
            renderer.clearSeriesStrokes(false);
        }
    }

    protected void applyToCategoryItemRenderer(CategoryItemRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Null 'renderer' argument.");
        }
        if (renderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)((Object)renderer));
        }
        renderer.setBaseItemLabelFont(this.regularFont);
        renderer.setBaseItemLabelPaintType(this.itemLabelPaintType);
        if (renderer instanceof BarRenderer) {
            BarRenderer br = (BarRenderer)renderer;
            br.setBarPainter(this.barPainter);
            br.setShadowVisible(this.shadowVisible);
            br.setShadowPaintType(this.shadowPaintType);
        }
        if (renderer instanceof BarRenderer3D) {
            BarRenderer3D br3d = (BarRenderer3D)renderer;
            br3d.setWallPaintType(this.wallPaintType);
        }
    }

    protected void applyToXYItemRenderer(XYItemRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Null 'renderer' argument.");
        }
        if (renderer instanceof AbstractRenderer) {
            this.applyToAbstractRenderer((AbstractRenderer)((Object)renderer));
        }
        renderer.setBaseItemLabelFont(this.regularFont);
        renderer.setBaseItemLabelPaintType(this.itemLabelPaintType);
        if (renderer instanceof XYBarRenderer) {
            XYBarRenderer br = (XYBarRenderer)renderer;
            br.setBarPainter(this.xyBarPainter);
            br.setShadowVisible(this.shadowVisible);
        }
    }

    protected void applyToXYAnnotation(XYAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardChartTheme)) {
            return false;
        }
        StandardChartTheme that = (StandardChartTheme)obj;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.extraLargeFont.equals(that.extraLargeFont)) {
            return false;
        }
        if (!this.largeFont.equals(that.largeFont)) {
            return false;
        }
        if (!this.regularFont.equals(that.regularFont)) {
            return false;
        }
        if (!this.smallFont.equals(that.smallFont)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.titlePaintType, that.titlePaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.subtitlePaintType, that.subtitlePaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.chartBackgroundPaintType, that.chartBackgroundPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.legendBackgroundPaintType, that.legendBackgroundPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.legendItemPaintType, that.legendItemPaintType)) {
            return false;
        }
        if (!this.drawingSupplierType.equals(that.drawingSupplierType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.plotBackgroundPaintType, that.plotBackgroundPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.plotOutlinePaintType, that.plotOutlinePaintType)) {
            return false;
        }
        if (!this.labelLinkStyle.equals(that.labelLinkStyle)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.labelLinkPaintType, that.labelLinkPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.domainGridlinePaintType, that.domainGridlinePaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.rangeGridlinePaintType, that.rangeGridlinePaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.crosshairPaintType, that.crosshairPaintType)) {
            return false;
        }
        if (!this.axisOffset.equals(that.axisOffset)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.axisLabelPaintType, that.axisLabelPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.tickLabelPaintType, that.tickLabelPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.itemLabelPaintType, that.itemLabelPaintType)) {
            return false;
        }
        if (this.shadowVisible != that.shadowVisible) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.shadowPaintType, that.shadowPaintType)) {
            return false;
        }
        if (!this.barPainter.equals(that.barPainter)) {
            return false;
        }
        if (!this.xyBarPainter.equals(that.xyBarPainter)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.thermometerPaint, that.thermometerPaint)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.wallPaintType, that.wallPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.errorIndicatorPaintType, that.errorIndicatorPaintType)) {
            return false;
        }
        if (!PaintTypeUtilities.equal(this.gridBandPaintType, that.gridBandPaintType)) {
            return false;
        }
        return PaintTypeUtilities.equal(this.gridBandAlternatePaintType, that.gridBandAlternatePaintType);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaintType(this.titlePaintType, stream);
        SerialUtilities.writePaintType(this.subtitlePaintType, stream);
        SerialUtilities.writePaintType(this.chartBackgroundPaintType, stream);
        SerialUtilities.writePaintType(this.legendBackgroundPaintType, stream);
        SerialUtilities.writePaintType(this.legendItemPaintType, stream);
        SerialUtilities.writePaintType(this.plotBackgroundPaintType, stream);
        SerialUtilities.writePaintType(this.plotOutlinePaintType, stream);
        SerialUtilities.writePaintType(this.labelLinkPaintType, stream);
        SerialUtilities.writePaintType(this.baselinePaintType, stream);
        SerialUtilities.writePaintType(this.domainGridlinePaintType, stream);
        SerialUtilities.writePaintType(this.rangeGridlinePaintType, stream);
        SerialUtilities.writePaintType(this.crosshairPaintType, stream);
        SerialUtilities.writePaintType(this.axisLabelPaintType, stream);
        SerialUtilities.writePaintType(this.tickLabelPaintType, stream);
        SerialUtilities.writePaintType(this.itemLabelPaintType, stream);
        SerialUtilities.writePaintType(this.shadowPaintType, stream);
        SerialUtilities.writePaintType(this.thermometerPaint, stream);
        SerialUtilities.writePaintType(this.wallPaintType, stream);
        SerialUtilities.writePaintType(this.errorIndicatorPaintType, stream);
        SerialUtilities.writePaintType(this.gridBandPaintType, stream);
        SerialUtilities.writePaintType(this.gridBandAlternatePaintType, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.titlePaintType = SerialUtilities.readPaintType(stream);
        this.subtitlePaintType = SerialUtilities.readPaintType(stream);
        this.chartBackgroundPaintType = SerialUtilities.readPaintType(stream);
        this.legendBackgroundPaintType = SerialUtilities.readPaintType(stream);
        this.legendItemPaintType = SerialUtilities.readPaintType(stream);
        this.plotBackgroundPaintType = SerialUtilities.readPaintType(stream);
        this.plotOutlinePaintType = SerialUtilities.readPaintType(stream);
        this.labelLinkPaintType = SerialUtilities.readPaintType(stream);
        this.baselinePaintType = SerialUtilities.readPaintType(stream);
        this.domainGridlinePaintType = SerialUtilities.readPaintType(stream);
        this.rangeGridlinePaintType = SerialUtilities.readPaintType(stream);
        this.crosshairPaintType = SerialUtilities.readPaintType(stream);
        this.axisLabelPaintType = SerialUtilities.readPaintType(stream);
        this.tickLabelPaintType = SerialUtilities.readPaintType(stream);
        this.itemLabelPaintType = SerialUtilities.readPaintType(stream);
        this.shadowPaintType = SerialUtilities.readPaintType(stream);
        this.thermometerPaint = SerialUtilities.readPaintType(stream);
        this.wallPaintType = SerialUtilities.readPaintType(stream);
        this.errorIndicatorPaintType = SerialUtilities.readPaintType(stream);
        this.gridBandPaintType = SerialUtilities.readPaintType(stream);
        this.gridBandAlternatePaintType = SerialUtilities.readPaintType(stream);
    }

    private static PaintType createPaintType(int color) {
        return new SolidColor(color);
    }
}

