/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.async;

import java.util.LinkedList;
import java.util.List;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.async.ExecuteThread;

final class DispatcherImpl
implements Dispatcher {
    private ExecuteThread[] threads;
    private final List<Runnable> q = new LinkedList<Runnable>();
    final Object ticket = new Object();
    private boolean active = true;

    public DispatcherImpl(Configuration conf) {
        this.threads = new ExecuteThread[conf.getAsyncNumThreads()];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new ExecuteThread("Twitter4J Async Dispatcher", this, i);
            this.threads[i].setDaemon(true);
            this.threads[i].start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                if (DispatcherImpl.this.active) {
                    DispatcherImpl.this.shutdown();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void invokeLater(Runnable task) {
        Object object = this.q;
        synchronized (object) {
            this.q.add(task);
        }
        object = this.ticket;
        synchronized (object) {
            this.ticket.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable poll() {
        while (this.active) {
            Object object = this.q;
            synchronized (object) {
                Runnable task;
                if (this.q.size() > 0 && null != (task = this.q.remove(0))) {
                    return task;
                }
            }
            object = this.ticket;
            synchronized (object) {
                try {
                    this.ticket.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.active) {
            this.active = false;
            ExecuteThread[] arr$ = this.threads;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ExecuteThread thread = arr$[i$];
                thread.shutdown();
            }
            Object object = this.ticket;
            synchronized (object) {
                this.ticket.notify();
            }
        }
    }
}

