/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.StaticContentHandler;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.htmlrunner.HTMLResultsListener;
import org.openqa.selenium.server.htmlrunner.HTMLTestResults;

public class HTMLLauncher
implements HTMLResultsListener {
    static Log log = LogFactory.getLog(HTMLLauncher.class);
    private SeleniumServer remoteControl;
    private HTMLTestResults results;

    public HTMLLauncher(SeleniumServer remoteControl) {
        this.remoteControl = remoteControl;
    }

    public String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, int timeoutInSeconds, boolean multiWindow) throws IOException {
        return this.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeoutInSeconds, multiWindow, "info");
    }

    private String runHTMLSuite(String browser, String browserURL, String suiteURL, File outputFile, int timeoutInSeconds, boolean multiWindow, String defaultLogLevel) throws IOException {
        outputFile.createNewFile();
        if (!outputFile.canWrite()) {
            throw new IOException("Can't write to outputFile: " + outputFile.getAbsolutePath());
        }
        long timeoutInMs = 1000L * (long)timeoutInSeconds;
        if (timeoutInMs < 0L) {
            log.warn((Object)"Looks like the timeout overflowed, so resetting it to the maximum.");
            timeoutInMs = Long.MAX_VALUE;
        }
        this.remoteControl.handleHTMLRunnerResults(this);
        BrowserLauncherFactory blf = new BrowserLauncherFactory();
        String sessionId = Long.toString(System.currentTimeMillis() % 1000000L);
        BrowserLauncher launcher = blf.getBrowserLauncher(browser, sessionId, this.remoteControl.getConfiguration());
        BrowserSessionFactory.BrowserSessionInfo sessionInfo = new BrowserSessionFactory.BrowserSessionInfo(sessionId, browser, browserURL, launcher, null);
        this.remoteControl.registerBrowserSession(sessionInfo);
        launcher.launchHTMLSuite(suiteURL, browserURL, multiWindow, defaultLogLevel);
        long now = System.currentTimeMillis();
        long end = now + timeoutInMs;
        while (this.results == null && System.currentTimeMillis() < end) {
            AsyncExecute.sleepTight(500L);
        }
        launcher.close();
        this.remoteControl.deregisterBrowserSession(sessionInfo);
        if (this.results == null) {
            throw new SeleniumCommandTimedOutException();
        }
        if (outputFile != null) {
            FileWriter fw = new FileWriter(outputFile);
            this.results.write(fw);
            fw.close();
        }
        return this.results.getResult().toUpperCase();
    }

    public String runHTMLSuite(String browser, String browserURL, File suiteFile, File outputFile, int timeoutInSeconds, boolean multiWindow) throws IOException {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        if (!suiteFile.exists()) {
            throw new IOException("Can't find HTML Suite file:" + suiteFile.getAbsolutePath());
        }
        if (!suiteFile.canRead()) {
            throw new IOException("Can't read HTML Suite file: " + suiteFile.getAbsolutePath());
        }
        this.remoteControl.addNewStaticContent(suiteFile.getParentFile());
        String suiteURL = browser.startsWith("*chrome") || browser.startsWith("*iehta") ? "http://localhost:" + this.remoteControl.getConfiguration().getPortDriversShouldContact() + "/selenium-server/tests/" + suiteFile.getName() : LauncherUtils.stripStartURL(browserURL) + "/selenium-server/tests/" + suiteFile.getName();
        return this.runHTMLSuite(browser, browserURL, suiteURL, outputFile, timeoutInSeconds, multiWindow, "info");
    }

    public void processResults(HTMLTestResults resultsParm) {
        this.results = resultsParm;
    }

    public boolean runSelfTests(File dir) throws IOException {
        boolean result;
        String[] browsers = WindowsUtils.thisIsWindows() ? new String[]{"firefox", "iexplore", "opera", "chrome"} : (Os.isFamily((String)"mac") ? new String[]{"firefox", "safari", "chrome"} : new String[]{"firefox", "opera", "konqueror", "chrome"});
        boolean allPassed = true;
        for (String browser : browsers) {
            result = this.runSelfTest(dir, browser, true, false);
            if (result) continue;
            allPassed = false;
        }
        for (String browser : browsers) {
            result = this.runSelfTest(dir, browser, false, false);
            if (result) continue;
            allPassed = false;
        }
        for (String browser : browsers) {
            result = this.runSelfTest(dir, browser, true, true);
            if (result) continue;
            allPassed = false;
        }
        if (allPassed) {
            log.info((Object)"ALL TESTS PASSED");
        } else {
            log.error((Object)("TESTS FAILED, see " + dir.getAbsolutePath()));
        }
        this.bzipTestResults(dir);
        return allPassed;
    }

    private void bzipTestResults(File dir) {
        File destFile = new File(dir, "results.tar.bz2");
        Tar bzipTask = new Tar();
        Tar.TarCompressionMethod bzip2 = new Tar.TarCompressionMethod();
        bzip2.setValue("bzip2");
        bzipTask.setCompression(bzip2);
        bzipTask.setProject(new Project());
        bzipTask.setDestFile(destFile);
        Tar.TarFileSet fs = bzipTask.createTarFileSet();
        fs.setDir(dir);
        fs.setIncludes("*.html");
        bzipTask.execute();
        log.info((Object)("bzipped test results: " + destFile.getAbsolutePath()));
    }

    private boolean runSelfTest(File dir, String browser, boolean multiWindow, boolean slowResources) throws IOException {
        String options = (multiWindow ? "multiWindow-" : "") + (slowResources ? "slowResources-" : "");
        String name = "results-" + browser + '-' + options + "TestSuite.html";
        File resultsFile = new File(dir, name);
        String baseUrl = "http://localhost:" + this.remoteControl.getPort();
        String suiteUrl = baseUrl + "/selenium-server/tests/TestSuite.html";
        StaticContentHandler.setSlowResources(slowResources);
        String result = null;
        int timeoutInSeconds = this.remoteControl.getConfiguration().getTimeoutInSeconds();
        try {
            result = this.runHTMLSuite("*" + browser, baseUrl, suiteUrl, resultsFile, timeoutInSeconds, multiWindow, "info");
            if ("PASSED".equals(result)) {
                log.info((Object)(result + ' ' + resultsFile.getAbsolutePath()));
            } else {
                log.error((Object)(result + ' ' + resultsFile.getAbsolutePath()));
            }
        }
        catch (SeleniumCommandTimedOutException e) {
            result = "FAIL (timed out)";
            log.error((Object)(result + ' ' + resultsFile.getAbsolutePath()));
            FileWriter fw = new FileWriter(resultsFile);
            fw.write("<html><head><title>Error</title></head><body>Error: timed out after " + timeoutInSeconds + " seconds</body></html>");
            fw.close();
        }
        catch (Exception e) {
            result = "ERROR";
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            log.error((Object)(result + ' ' + resultsFile.getAbsolutePath()), (Throwable)e);
            FileWriter fw = new FileWriter(resultsFile);
            fw.write("<html><head><title>Error</title></head><body><pre>" + HTMLTestResults.quoteCharacters(sw.toString()) + "</pre></body></html>");
            fw.close();
        }
        this.results = null;
        return "PASSED".equals(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int mainInt(String ... args) throws Exception {
        if (args.length == 0) {
            throw new IllegalArgumentException("Please pass a directory argument on the command line");
        }
        File dir = new File(args[0]);
        dir.mkdirs();
        SeleniumServer server = new SeleniumServer();
        boolean result = false;
        try {
            server.start();
            result = new HTMLLauncher(server).runSelfTests(dir);
        }
        finally {
            server.stop();
        }
        return result ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        System.exit(HTMLLauncher.mainInt(args));
    }
}

