/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers.locators;

import org.openqa.selenium.server.browserlaunchers.WindowsUtils;
import org.openqa.selenium.server.browserlaunchers.locators.SingleBrowserLocator;

public class SafariLocator
extends SingleBrowserLocator {
    private static final String[] USUAL_UNIX_LAUNCHER_LOCATIONS = new String[]{"/Applications/Safari.app/Contents/MacOS"};
    private static final String[] USUAL_WINDOWS_LAUNCHER_LOCATIONS = new String[]{WindowsUtils.getProgramFilesPath() + "\\Safari"};

    protected String browserName() {
        return "Safari";
    }

    protected String seleniumBrowserName() {
        return "safari";
    }

    protected String[] standardlauncherFilenames() {
        if (WindowsUtils.thisIsWindows()) {
            return new String[]{"Safari.exe"};
        }
        return new String[]{"Safari"};
    }

    protected String browserPathOverridePropertyName() {
        return "SafariDefaultPath";
    }

    protected String[] usualLauncherLocations() {
        return WindowsUtils.thisIsWindows() ? USUAL_WINDOWS_LAUNCHER_LOCATIONS : USUAL_UNIX_LAUNCHER_LOCATIONS;
    }
}

