/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import junit.framework.TestCase;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncherFactory;

public class BrowserLauncherFactoryUnitTest
extends TestCase {
    public void testAllSupportedBrowsersDefineAppropriateConstructor() {
        for (String browser : BrowserLauncherFactory.getSupportedLaunchers().keySet()) {
            try {
                new BrowserLauncherFactory().getBrowserLauncher("*" + browser, "a-session-id", new RemoteControlConfiguration());
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof NoSuchMethodException) {
                    BrowserLauncherFactoryUnitTest.fail((String)(browser + " browser does not define appropriate constructor: " + e.getMessage()));
                }
                if (-1 != e.getMessage().indexOf("could not be found in the path") || -1 != e.getMessage().indexOf("SystemRoot apparently not set") || -1 != e.getMessage().indexOf("File was a script file, not a real executable")) {
                    System.out.println("Ignoring problem with getting launcher for '" + browser + "', as browser might not be installed on this machine");
                    continue;
                }
                throw e;
            }
        }
    }

    public void testBrowserStartCommandThrowsExceptionIfNotMatched() {
        BrowserLauncherFactory blf = new BrowserLauncherFactory();
        try {
            blf.getBrowserStartCommand("iexplore", "*foobar");
            BrowserLauncherFactoryUnitTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBrowserStartCommandMatchesWithNoLaunchCommand() {
        BrowserLauncherFactory blf = new BrowserLauncherFactory();
        try {
            String startCommand = blf.getBrowserStartCommand("iexplore", "*iexplore");
            BrowserLauncherFactoryUnitTest.assertNull((Object)startCommand);
        }
        catch (IllegalArgumentException iae) {
            BrowserLauncherFactoryUnitTest.fail();
        }
    }

    public void testBrowserStartCommandMatchesWithLaunchCommand() {
        BrowserLauncherFactory blf = new BrowserLauncherFactory();
        try {
            String expectedCommand = "foo";
            String startCommand = blf.getBrowserStartCommand("iexplore", "*iexplore " + expectedCommand);
            BrowserLauncherFactoryUnitTest.assertEquals((String)expectedCommand, (String)startCommand);
        }
        catch (IllegalArgumentException iae) {
            BrowserLauncherFactoryUnitTest.fail();
        }
    }
}

