[Setup]
AppName=Trac Lightning
AppVerName=Trac Lightning 4.0.0dev
OutputDir=.
DefaultDirName=C:\TracLight
UninstallDisplayIcon={app}\trac.ico
DefaultGroupName=Trac
AlwaysRestart=true
ChangesEnvironment=yes
LanguageDetectionMethod=locale
SolidCompression=yes
; set your %NUMBER_OF_PROCESSORS%
LZMANumBlockThreads=2

[Languages]
Name: "ja"; MessagesFile: "compiler:Languages\Japanese.isl"

[Messages]
CompactInstallation=x[XCXg[(Trac+SVN)
FullInstallation=JavaAWCCXg[(Trac+SVN+Maven+Jenkins)

[Dirs]
Name: {app}\bin
Name: {app}\python
Name: {app}\install
Name: {app}\projects
Name: {app}\jenkins; Components: Jenkins
Name: {app}\python\share\trac\conf
Name: {app}\install\repository\LibraryProject\branches
Name: {app}\install\repository\LibraryProject\tags
Name: {app}\install\repository\WebProject\branches
Name: {app}\install\repository\WebProject\tags
Name: {app}\CollabNetSVN

[Files]
Source: install\trac.htdigest; DestDir: {app}\install\
Source: install\svnauthz; DestDir: {app}\install\
Source: install\trac.ini.default; DestDir: {app}\install\
Source: install\trac.ini.agile; DestDir: {app}\install\
Source: install\authzpolicy.conf.default; DestDir: {app}\install\
Source: install\replace.py; DestDir: {app}\install\
Source: install\replace-projecthome.py; DestDir: {app}\install\
Source: install\modpath.exe; DestDir: {app}\install\
Source: install\post-install.bat; DestDir: {app}\install\
Source: install\post-install-service.bat; DestDir: {app}\install\
Source: install\install-service.bat; DestDir: {app}\install\
Source: install\uninstall-service.bat; DestDir: {app}\install\
Source: install\sed.exe; DestDir: {app}\install\
Source: install\setup-httpdconf.bat; DestDir: {app}\install\
Source: install\sitecustomize.py; DestDir: {app}\install
Source: install\msvcr71.dll; DestDir: {sys}; Flags: uninsneveruninstall onlyifdoesntexist
Source: python\msvcr90.dll; DestDir: {sys}; Flags: uninsneveruninstall onlyifdoesntexist
Source: install\textreplace.py; DestDir: {app}\install\
Source: install\trac-extract-static-resources.py; DestDir: {app}\install\
Source: install\replace\*; DestDir: {app}\install\replace; Flags: recursesubdirs sortfilesbyextension; Excludes: \httpd-ssl.conf,\jenkins.bat.in,\jenkins.xml.in,\mod_wsgi.so
Source: install\avatars\*; DestDir: {app}\install\avatars; Flags: recursesubdirs sortfilesbyextension
Source: install\trac-template\*; DestDir: {app}\install\trac-template; Flags: recursesubdirs sortfilesbyextension
Source: install\repository\*; DestDir: {app}\install\repository; Flags: recursesubdirs sortfilesbyextension
Source: etc\*; DestDir: {app}\etc; Flags: recursesubdirs sortfilesbyextension
Source: bin\*; DestDir: {app}\bin; Flags: recursesubdirs sortfilesbyextension
Source: CollabNetSVN\*; DestDir: {app}\CollabNetSVN; Flags: recursesubdirs sortfilesbyextension; Excludes: \httpd\conf\httpd.conf,\httpd\htdocs\index.html
Source: CollabNetSVN\libsvn_*.dll; DestDir: {app}\CollabNetSVN\httpd\modules
Source: Graphviz\*; DestDir: {app}\Graphviz; Flags: recursesubdirs sortfilesbyextension
Source: python\*; DestDir: {app}\python; Flags: recursesubdirs sortfilesbyextension; Excludes: *.pyc,*.pyo
Source: python-lib\svn\*; DestDir: {app}\python\Lib\site-packages; Flags: recursesubdirs sortfilesbyextension; Excludes: *.pyc,*.pyo
Source: CollabNetSVN\ssleay32.dll; DestDir: {app}\python\Lib\site-packages\libsvn
Source: CollabNetSVN\libeay32.dll; DestDir: {app}\python\Lib\site-packages\libsvn
Source: install\replace\mod_wsgi.so; DestDir: {app}\python
Source: tmp\dist\Lib\site-packages\*; DestDir: {app}\python\Lib\site-packages; Flags: recursesubdirs sortfilesbyextension; Excludes: *.pyc,*.pyo
Source: tmp\dist\Scripts\*; DestDir: {app}\python\Scripts; Flags: recursesubdirs sortfilesbyextension
Source: backup.bat; DestDir: {app}\
Source: python-lib\trac\trac\htdocs\trac.ico; DestDir: {app}\
Source: install\www\*; DestDir: {app}\CollabNetSVN\httpd\htdocs; Flags: recursesubdirs sortfilesbyextension
Source: install\replace\httpd-ssl.conf; DestDir: {app}\CollabNetSVN\httpd\conf\
Source: maven\*; DestDir: {app}\maven; Components: Maven; Flags: recursesubdirs sortfilesbyextension
Source: jenkins\*; DestDir: {app}\jenkins\; Components: Jenkins; Flags: recursesubdirs sortfilesbyextension uninsremovereadonly overwritereadonly
Source: install\replace\jenkins.bat.in; DestDir: {app}\install\replace\; Components: Jenkins
Source: install\replace\jenkins.xml.in; DestDir: {app}\install\replace\; Components: Jenkins
Source: install\hudson\.hudson\*; DestDir: {app}\install\hudson\.hudson; Components: Jenkins; Flags: recursesubdirs sortfilesbyextension

[Registry]
Root: HKLM; Subkey: SYSTEM\CurrentControlSet\Control\Session Manager\Environment; ValueType: string; ValueName: APR_ICONV_PATH; ValueData: {app}\CollabNetSVN\httpd\bin\iconv; Tasks: ; Flags: uninsdeletevalue
Root: HKLM; Subkey: SYSTEM\CurrentControlSet\Control\Session Manager\Environment; ValueType: string; ValueName: TRACPATH; ValueData: "{app}\python;{app}\python\Scripts;{app}\CollabNetSVN;{app}\CollabNetSVN\httpd\bin;{app}\Graphviz\bin;{app}\maven\bin;{app}\bin"; Tasks: ; Flags: uninsdeletevalue
Root: HKLM; Subkey: SYSTEM\CurrentControlSet\Control\Session Manager\Environment; ValueType: string; ValueName: OPENSSL_CONF; ValueData: {app}\CollabNetSVN\httpd\conf\openssl.cnf; Tasks: ; Flags: uninsdeletevalue
Root: HKLM; Subkey: SYSTEM\CurrentControlSet\Control\Session Manager\Environment; ValueType: string; ValueName: MAVEN_HOME; ValueData: {app}\maven; Tasks: ; Flags: uninsdeletevalue

[Run]
Filename: {app}\install\modpath.exe; Parameters: "/add ""%TRACPATH%"""; WorkingDir: {app}; Flags: runhidden
Filename: {app}\install\post-install.bat; Parameters: """{app}"""; WorkingDir: {app}
Filename: {sys}\netsh.exe; Parameters: "firewall add allowedprogram ""{app}\CollabNetSVN\httpd\bin\httpd.exe"" TracLightning/Apache ENABLE"; Flags: runhidden
Filename: {app}\install\setup-httpdconf.bat; Parameters: """{app}"""; WorkingDir: {app}; Tasks: " Override_Apache_Config"; Components: 
Filename: {app}\install\post-install-service.bat; WorkingDir: {app}; Tasks: InstallWindowsServiceTask

[Icons]
Name: {group}\Jenkins̋N; Filename: {app}\jenkins\jenkins.bat; WorkingDir: {app}\jenkins; Components: Jenkins; IconFilename: {app}\projects\hudson\.hudson\war\favicon.ico; IconIndex: 0
Name: {group}\T[rX̃CXg[; Filename: {app}\install\install-service.bat; WorkingDir: {app}; IconFilename: {app}\CollabNetSVN\httpd\bin\httpd.exe; IconIndex: 0
Name: {group}\T[rX̃ACXg[; Filename: {app}\install\uninstall-service.bat; WorkingDir: {app}; IconFilename: {app}\CollabNetSVN\httpd\bin\httpd.exe; IconIndex: 0
Name: {group}\R}hvvg; Filename: cmd; Parameters: "/e:on /k ""{app}\bin\setenv.bat"""; WorkingDir: {app}\bin; IconFilename: {app}\trac.ico; Tasks: ; IconIndex: 0
Name: {group}\SQLitef[^x[XuEU; Filename: {app}\bin\SQLite Database Browser.exe; WorkingDir: {app}\projects\trac; IconFilename: {app}\bin\SQLite Database Browser.exe; IconIndex: 0; Tasks: 
Name: {group}\R}hvvgs; Filename: {app}\start.bat; WorkingDir: {app}; IconFilename: {app}\CollabNetSVN\httpd\bin\httpd.exe; IconIndex: 0; Tasks: ; Parameters: -e DEBUG
Name: {group}\obNAbv; Filename: {app}\backup.bat; WorkingDir: {app}; IconFilename: {app}\trac.ico; IconIndex: 0

[UninstallDelete]
Name: {app}\python\Lib; Type: filesandordirs
Name: {app}\python\contrib; Type: filesandordirs
Name: {app}\python\Scripts; Type: filesandordirs
Name: {app}\bin; Type: filesandordirs
Name: {app}\install; Type: filesandordirs
Name: {app}\start.bat; Type: files
Name: {app}\continuum; Type: filesandordirs
Name: {app}\.egg-cache; Type: filesandordirs
Name: {app}\CollabNetSVN\httpd\logs; Type: filesandordirs
Name: {app}\CollabNetSVN\httpd\cgi-bin\trac.wsgi; Type: filesandordirs
Name: {app}\CollabNetSVN\httpd\htdocs\trac_common; Type: filesandordirs
Name: {app}\CollabNetSVN\httpd\htdocs\trac; Type: filesandordirs
Name: {app}\CollabNetSVN\httpd\modules; Type: filesandordirs
Name: {app}\jenkins\jenkins.bat; Type: files
Name: {app}\jenkins\jenkins.xml; Type: files
Name: {app}\jenkins\jenkins.war.*; Type: files
Name: {app}\jenkins\jenkins.*.log; Type: files
Name: {app}\projects\hudson\.hudson\jenkins.*.log; Type: files
Name: {app}\projects\hudson\.hudson\war; Type: filesandordirs
Name: {app}\projects\hudson\.hudson\plugins; Type: filesandordirs

[UninstallRun]
Filename: {app}\CollabNetSVN\httpd\bin\httpd.exe; Parameters: -n TracLightning -k stop; WorkingDir: {app}\CollabNetSVN\httpd\bin; Flags: runhidden
Filename: {app}\CollabNetSVN\httpd\bin\httpd.exe; Parameters: -n TracLightning -k uninstall; WorkingDir: {app}\CollabNetSVN\httpd\bin; Flags: runhidden
Filename: {app}\jenkins\jenkins.exe; Parameters: stop; WorkingDir: {app}\jenkins; Flags: runhidden
Filename: {app}\jenkins\jenkins.exe; Parameters: uninstall; WorkingDir: {app}\jenkins; Flags: runhidden
Filename: {sys}\netsh.exe; Parameters: "firewall delete allowedprogram ""{app}\CollabNetSVN\httpd\bin\httpd.exe"""; Flags: runhidden
Filename: {app}\install\modpath.exe; Parameters: "/del ""%TRACPATH%"""; Flags: runhidden

[Tasks]
Name: Override_Apache_Config; Description: Apache̐ݒ㏑(CXg[ɂ͕K`FbNĉBo[WAbvۂɂ͕Kvɉă`FbNOA蓮httpd.confĂ); Components: 
Name: InstallWindowsServiceTask; Description: uT[rX̃CXg[vs; Flags: unchecked

[Components]
Name: Maven; Description: Maven 3.x; Types: full
Name: Jenkins; Description: Jenkins CI Tool; Types: full; Flags: dontinheritcheck

[InstallDelete]
Name: {group}\Hudson̋N.lnk; Type: files
