# -*- coding: utf-8 -*-
# NewWikiPageButton plugin

from pkg_resources import resource_filename

from trac.core import Component, implements
from trac.web.api import IRequestFilter
from trac.web.chrome import ITemplateProvider, add_script


class NewWikiPageButtonPlugin(Component):

    implements(ITemplateProvider, IRequestFilter)

    # ITemplateProvider methods

    def get_templates_dirs(self):
        return ()

    def get_htdocs_dirs(self):
        yield 'newwikipagebutton', resource_filename(__name__, 'htdocs')

    # IRequestFilter methods

    def pre_process_request(self, req, handler):
        return handler

    def post_process_request(self, req, template, data, content_type):
        if template == 'wiki_view.html' and 'WIKI_CREATE' in req.perm('wiki'):
            add_script(req, 'newwikipagebutton/newwikipagebutton.js')
        return template, data, content_type
