//mailarchive.js

if (ajaxmail_base_url == undefined) {
  var ajaxmail_base_url = '../';
}

jQuery(function(){
  initMailTicketReport();
});

function initMailTicketReport() {
  //mailarchive report
  $(".mailarchivereport .expander").click(function(){
    target = $(this).parent().parent();
    if (target.hasClass("expanded")) {
      target.removeClass('expanded').addClass('collapsed');
      target.next(".mail_data").hide();
      
    } else if (target.hasClass("collapsed")) {
      target.removeClass('collapsed').addClass('expanded');
      mail_data = target.next('.mail_data').show();
      holder = mail_data.children('td').children('.mailticketreportplaceholder');

      if (holder.children().length == 0) {
        showRelatedMailThread(holder);
      }
      return false;
    }
  });
}

function initMailThread(thread_id) {
  //show mail
  id = "#" + thread_id;
  $(id + " .mail_subject").click(function(){
    holder = $(this).parent().children(".mailplaceholder");
    if (holder.children().length == 0) {
      showMail(holder);
    } else {
      holder.toggle();
    }
    return false;
  });

  //reply edit mail
  $(id + " .reply_mail").click(function(arg){
    holder = $(this).parent().children(".mailreplyplaceholder");
    if (holder.children().length == 0) {
      showMailEditor(holder);
    } else {
      holder.toggle();
    }
    return false;
  });
}

function showMail(holder) {
  holderParent = holder.parent();
  mailId = holderParent.children(".mail_id").text();
  
  jQuery.ajax({
    type: "GET",
    url: ajaxmail_base_url + "ajaxmailarchive/" + mailId,
    dataType: "html",
    success: function (data) {
      holder.append(data);
    },
    beforeSend: function() {
      holderParent.children(".mail_loading").show();
    },
    complete: function() {
      holderParent.children(".mail_loading").hide();
    }
  });
}

function showRelatedMailThread(holder) {
  holderParent = holder.parent();
  mailId = holderParent.children(".mail_id").text();
  
  jQuery.ajax({
    type: "GET",
    url: ajaxmail_base_url + "ajaxmailthread/" + mailId,
    dataType: "html",
    success: function (data) {
      holder.append(data);
    },
    beforeSend: function() {
      holderParent.children(".mail_loading").show();
    },
    complete: function() {
      holderParent.children(".mail_loading").hide();
    }
  });
}


function showMailEditor(holder) {
  holderParent = holder.parent();
  mailId = holderParent.children(".mail_id").text();

  jQuery.ajax({
    type: "GET",
    url: ajaxmail_base_url + "ajaxmaileditor/" + mailId,
    dataType: "html",
    success: function (data) {
      holder.append(data).fadeIn(200);
    },
    beforeSend: function() {
      holderParent.children(".mail_loading").show();
    },
    complete: function() {
      holderParent.children(".mail_loading").hide();
    }
  });
}

function insertReplyTemplate(target, template, commentTarget, comment) {
  //insert template
  if (template != '') {
    textArea = jQuery(target);
    text = textArea.val();
    text = template + '\n' + text;
    textArea.val(text);
  }
  
  //insert comment
  if (comment != '') {
    textField = jQuery(commentTarget);
    textField.val(comment);
  }
}