#!/usr/bin/env python
# -*- coding: utf-8 -*-

from setuptools import setup

setup(
    name = 'LightningTheme',
    version = '1.0.1',
    packages = ['lightningtheme'],
    package_data = {
        'lightningtheme': [
            'htdocs/*.css', 'htdocs/*.png', 'htdocs/img/*.jpg',
            'htdocs/img/*.png', 'templates/*/*.html',
        ],
    },

    author = 'Takashi Okamoto',
    author_email = 'okamototk@nospam.sf.jp',
    description = 'A theme for TracLightning.',
    license = 'BSD',
    keywords = 'trac plugin theme',
    url = 'http://sourceforge.jp/projects/shibuya-trac/wiki/FrontPage',
    classifiers = [
        'Framework :: Trac',
    ],

    install_requires = ['Trac', 'TracThemeEngine>=2.0'],

    entry_points = {
        'trac.plugins': [
            'lightningtheme.theme = lightningtheme.theme',
        ]
    },
)
