# -*- coding: utf-8 -*-

import os
from pkg_resources import parse_version, resource_filename

from trac import __version__
from themeengine.api import ThemeBase


class LightningTheme(ThemeBase):
    """A theme for TracLightning."""

    template = htdocs = css = screenshot = True

    def get_theme_info(self, name):
        info = super(LightningTheme, self).get_theme_info(name)
        template = resource_filename(__name__, 'templates')
        if parse_version(__version__) < parse_version('1.0'):
            version = '0.12'
        else:
            version = '1.0'
        info['template'] = os.path.join(template, version,
                                        name.lower() + '_theme.html')
        return info
