# -*- coding: utf-8 -*-

import re

from trac.config import BoolOption, FloatOption, ListOption
from trac.core import Component, implements
from trac.util.presentation import to_json
from trac.web.chrome import ITemplateProvider, add_script, add_script_data, \
                            add_stylesheet
from trac.web.main import IRequestHandler, IRequestFilter


class CompleteUserWeb(Component):

    implements(IRequestHandler, IRequestFilter, ITemplateProvider)

    single_fields = ListOption('complete-user', 'single_fields', 'owner,reporter',
        doc=u"""単一ユーザを補完するフィールド設定します。""")
    composite_fields = ListOption('complete-user', 'composite_fields', 'cc',
        doc=u"""複数ユーザを補完するフィールド設定します。""")
    name_check = BoolOption('complete-user', 'name_check', 'true',
        doc=u"""ユーザを検索する際にNameが設定されているユーザのみを検索するかどうかを設定します。""")
    popup_delay = FloatOption('complete-user', 'popup_delay', '1.5',
        doc=u"""補完ウィンドウのポップアップ表示までの遅延時間を設定します。

        単位は秒で小数点も利用することができます""")

    # IRequestFilter methods

    def pre_process_request(self, req, handler):
        return handler

    def post_process_request(self, req, template, data, content_type):
        if re.match(r'^/(ticket|newticket|admin|query)', req.path_info):
            add_stylesheet(req, 'completeuser/js/yui/autocomplete/assets/skins/sam/autocomplete.css')
            add_stylesheet(req, 'completeuser/css/trac-completeuser.css')
            add_script(req, 'completeuser/js/yui/utilities/utilities.js')
            add_script(req, 'completeuser/js/yui/autocomplete/autocomplete-min.js')
            add_script(req, 'completeuser/js/trac-completeuser.js')
            script_data = {'base_path': req.href(),
                           'single_fields': self.single_fields,
                           'composite_fields': self.composite_fields,
                           'popup_delay': self.popup_delay}
            add_script_data(req, {'completeuser': script_data})
        return template, data, content_type

    # IRequestHandler methods

    def match_request(self, req):
        return req.path_info in ('/login/completeuser', '/completeuser')

    def process_request(self, req):
        query = req.args.get('query')
        db = self.env.get_read_db()
        cursor = db.cursor()

        join = ("LEFT OUTER JOIN", "JOIN")[self.name_check]
        sql = ("SELECT s.sid, sa.value FROM session s " +
               "%s session_attribute sa ON s.sid=sa.sid AND sa.name='name' " +
               "WHERE s.authenticated=1") % join
        if query:
            like = db.like()
            sql += " AND (s.sid %s OR sa.value %s)" % (like, like)
            args = ['%' + db.like_escape(query) + '%'] * 2
        else:
            args = []

        cursor.execute(sql, args)
        userlist = [{'Id': sid, 'Name': value} for sid, value in cursor]
        response = to_json({'UserList': userlist})
        if isinstance(response, unicode):
            response = response.encode('utf-8')
        req.send(response, 'application/json')

    # ITemplateProvider methods

    def get_templates_dirs(self):
        return []

    def get_htdocs_dirs(self):
        from pkg_resources import resource_filename
        return [('completeuser', resource_filename(__name__, 'htdocs'))]
