# -*- coding: utf-8 -*-

import os
from shutil import rmtree

from trac.env import open_environment
from trac.core import ComponentMeta
from trac.web.chrome import ITemplateProvider
from trac.util import copytree, makedirs


def get_instances(env, interface):
    compmgr = env.compmgr
    extensions = ComponentMeta._registry.get(interface, ())
    instances = filter(None, [compmgr[cls] for cls in extensions])
    return [cls(env) for cls in extensions if not compmgr[cls]] + \
           instances


def main(envpath, root):
    env = open_environment(envpath)
    instances = get_instances(env, ITemplateProvider)
    if os.path.isdir(root):
        rmtree(root)
    makedirs(root, overwrite=True)
    for instance in instances:
        paths = list(instance.get_htdocs_dirs())
        if not paths:
            continue
        print 'Copying resources from %s' % instance.__class__
        for key, source in paths:
            if not source or not os.path.isabs(source):
                continue
            if key == 'site':
                continue
            source = os.path.normpath(source)
            print '  %s: %s' % (key, source)
            if os.path.exists(source):
                dest = os.path.join(root, key)
                copytree(source, dest, overwrite=True)


if __name__ == '__main__':
    import sys
    main(sys.argv[1], sys.argv[2])
