@echo off
setlocal

set DIR=%~dp0

pushd "%DIR%"
if exist build-env.cmd call build-env.cmd
if %PROCESSOR_ARCHITECTURE% == AMD64 if "%ISCC%" == "" set "ISCC=%ProgramFiles(x86)%\Inno Setup 5\iscc.exe"
if %PROCESSOR_ARCHITECTURE% == x86   if "%ISCC%" == "" set "ISCC=%ProgramFiles%\Inno Setup 5\iscc.exe"
if not exist "%ISCC%" (
    echo No Inno Setup Compiler...
    goto :end_of_script
)
if "%HG%" == "" set HG=hg

set OPT_CLEAN_BUILD=no
set OPT_WITHOUT_CHECK=no
for %%i in (%*) do (
    if "%%i" == "--cleanbuild" set OPT_CLEAN_BUILD=yes
    if "%%i" == "--clean-build" set OPT_CLEAN_BUILD=yes
    if "%%i" == "--without-check" set OPT_WITHOUT_CHECK=yes
)

for /f %%i in ('%HG% id -i') do SET AppRev=%%i
if "%OPT_CLEAN_BUILD%" == "yes" set AppRev=%AppRev:+=%

if "%OPT_CLEAN_BUILD%" == "yes" (
    if exist tmp (
        echo Removing temporary directory...
        rmdir/s/q tmp
    )
    mkdir tmp
    echo Copying clean source tree to build...
    "%HG%" archive tmp
    call tmp\build.cmd --without-check
    if exist "%DIR%tmp\TracLightning*.exe" copy/y "%DIR%tmp\TracLightning*.exe" "%DIR%" >nul
    goto :end_of_script
)

set GO_BUILD_STAGE=y
if not "%OPT_WITHOUT_CHECK%" == "yes" (
    echo Checking local modifications...
    "%HG%" status | findstr "^"
    if not errorlevel 1 set/p GO_BUILD_STAGE="Are you sure you want to build the TracLightning installer? [Y/n] "
)
if not "%GO_BUILD_STAGE%" == "y" goto :end_of_script


REM Comparing Version number in configuration files
echo Comparing version number in configuration files...
for /f %%i in ('install\sed.exe -n "s/^AppVerName.*\(.\..\..*$\)/\1/p" trac.iss') do SET AppVerName=%%i
for /f %%i in ('install\sed.exe -n "s/^footer.*\(.\..\..*$\)/\1/p" install\replace\trac.ini.in') do SET footer=%%i
if not "%AppVerName%"=="%footer%" (
    echo Unmuched version description. Plaese check trac.iss and install\replace\trac.ini.in.
    goto :end_of_script
)
set BUILDVER=-%AppVerName%
if "%AppVerName:~-3%" == "dev" set BUILDVER=-%AppVerName%-%AppRev%
echo Preparing for TracLightning%BUILDVER%.exe

set PYTHONHOME=%DIR%python
set PYTHON=%PYTHONHOME%\python.exe
set LOGDIR=%DIR%tmp\log
set DISTDIR=%DIR%tmp\dist
set DISTLIBDIR=%DISTDIR%\Lib\site-packages
set SETUPTOOLS_LIB=%DIR%python-lib\setuptools\setuptools-7.0-py2.6.egg
set PYTHON_EGG_CACHE=%DIR%tmp\egg-cache

if exist tmp (
    echo Removing temporary directory...
    rmdir/s/q tmp
)
mkdir tmp
mkdir tmp\log
mkdir tmp\dist
mkdir tmp\dist\egg
mkdir tmp\dist\Scripts
mkdir tmp\dist\Lib
mkdir tmp\dist\Lib\site-packages
mkdir tmp\egg-cache


REM Generate easy_install script
echo Preparing setuptools...
set PYTHONPATH=%DISTDIR%\Lib\site-packages;%SETUPTOOLS_LIB%
"%PYTHON%" -m easy_install -NZ --prefix="%DISTDIR%" "%SETUPTOOLS_LIB%" >tmp\log\setuptools.log
set PYTHONPATH=%DISTDIR%\Lib\site-packages

REM Build libraries (non egg files)
for %%i in (
    docutils configobj xlrd funcparserlib webcolors xlwt
) do (
    echo Building python-lib\%%i...
    pushd "python-lib\%%i"
    if exist build rmdir/s/q build
    if exist dist rmdir/s/q dist
    "%PYTHON%" setup.py install --prefix="%DISTDIR%" >>"%LOGDIR%\lib-%%i.log"
    popd
)

REM Build egg file and install to build other plugins
for %%i in (babel genshi trac) do (
    echo Building python-lib\%%i...
    pushd "python-lib\%%i"
    if exist build rmdir/s/q build
    if exist dist rmdir/s/q dist
    "%PYTHON%" setup.py egg_info -DR bdist_egg >>"%LOGDIR%\lib-%%i.log"
    for %%e in (dist\*.egg) do "%PYTHON%" -m easy_install -NZ --prefix="%DISTDIR%" %%e >>"%LOGDIR%\lib-%%i.log"
    popd
)

REM Copy egg files including binary files
for %%i in (python-lib\egg\*.egg) do (
    echo Extracting %%i...
    "%PYTHON%" -m easy_install -NZ --prefix="%DISTDIR%" %%i >>"%LOGDIR%\lib-%%~ni.log"
)

REM Build egg files
for %%i in (Pygments actdiag blockdiag nwdiag seqdiag) do (
    echo Building python-lib\%%i...
    pushd "python-lib\%%i"
    if exist build rmdir/s/q build
    if exist dist rmdir/s/q dist
    "%PYTHON%" setup.py bdist_egg >"%LOGDIR%\lib-%%i.log"
    for %%e in (dist\*.egg) do "%PYTHON%" -m easy_install -NZ --prefix="%DISTDIR%" %%e >>"%LOGDIR%\lib-%%i.log"
    popd
)
for /d %%i in ("plugins\svn\*") do (
    echo Building %%i...
    pushd "%%i"
    if exist build rmdir/s/q build
    if exist dist rmdir/s/q dist
    if %%~ni == tracsubticketsplugin "%PYTHON%" setup.py compile_catalog >>"%LOGDIR%\plugins-%%~ni.log"
    "%PYTHON%" setup.py egg_info -DR bdist_egg >>"%LOGDIR%\plugins-%%~ni.log"
    for %%e in (dist\*.egg) do "%PYTHON%" -m easy_install -NZ --prefix="%DISTDIR%" %%e >>"%LOGDIR%\plugins-%%~ni.log"
    popd
)

REM Modify shebang in Scripts/*.py
for %%i in (tmp\dist\Scripts\*.py) do (
    install\sed.exe -e "1 s/^#!.*$/#! python.exe/" %%i >%%i.new
    move/y %%i.new %%i >nul
)

echo Building TracLightning%BUILDVER%.exe...
"%ISCC%" /FTracLightning%BUILDVER% trac.iss >"%LOGDIR%\TracLightning%BUILDVER%-iscc.log"

:end_of_script
popd
endlocal
