<?xml version='1.0' encoding='ISO-8859-1' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1363767 -->
<!-- French translation by alain B, review by Vincent Deffontaines -->
<!-- Maintained by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="ip-based.xml.meta">
<parentdocument href="./">Serveurs virtuels</parentdocument>
   <title>Support Apache des serveurs virtuels par IP</title>

<seealso>
<a href="name-based.html">Support Apache des serveurs virtuels par nom</a>
</seealso>

<section id="explanation"><title>Qu'est-ce que l'hbergement virtuel
bas sur IP</title>
<p>L'hbergement virtuel bas sur IP est une mthode permettant
d'appliquer certaines directives en fonction de l'adresse IP et du port
sur lesquels la requte est reue. En gnral, il s'agit de servir
diffrents sites web sur des ports ou interfaces diffrents.</p>

<p>Dans de nombreux cas, l'<a href="name-based.html">hbergement virtuel
bas sur le nom</a> est plus adapt car il permet  plusieurs serveurs
virtuels de partager la mme adresse/port. Voir le document <a
href="name-based.html#namevip">Hbergement virtuel bas sur IP ou sur le
nom</a> pour prendre votre dcision.</p>
</section>



<section id="requirements"><title>Systme requis</title>

    <p>Comme l'indique le terme <cite>par IP</cite>, le serveur 
    <strong>doit disposer de couples adresses IP/port diffrents pour chaque 
    serveur virtuel par IP</strong>. La machine peut possder 
    plusieurs connexions physiques au rseau, ou utiliser des 
    interfaces virtuelles qui sont supportes par la plupart des 
    systmes d'exploitation modernes (Consultez la documentation des 
    systmes d'exploitation pour plus de dtails, notamment les "alias 
    IP" et la commande "ifconfig" pour les activer), et/ou utiliser
    plusieurs ports.</p>

    <p>Dans la terminologie du serveur HTTP Apache, l'utilisation de
    plusieurs ports TCP pour une seule adresse IP se nomme aussi
    hbergement virtuel bas sur IP.</p>

</section>

<section id="howto"><title>Comment configurer Apache</title>

    <p>Il y a deux manires de configurer Apache pour le support de 
    multiples serveurs virtuels. Il suffit soit de faire tourner un 
    processus rsident <program>httpd</program> pour chaque nom de 
    domaine, soit de faire tourner un unique processus rsident qui 
    gre tous les serveurs virtuels.</p>

    <p>Utilisez des processus rsidents multiples lorsque&nbsp;:</p>

    <ul>
      <li>il y a des problmes de rpartition de scurit, tels 
      qu'une entreprise1 ne souhaite que personne d'une entreprise2 
      ne puisse lire ses donnes except via le Web. Dans ce cas, 
      vous aurez besoin de deux processus rsidents, chacun fonctionnant 
      avec des paramtres <directive module="mpm_common">User</directive>, 
      <directive module="mpm_common">Group</directive>, 
      <directive module="mpm_common">Listen</directive>, et 
      <directive module="core">ServerRoot</directive> diffrents.</li>

      <li>vous disposez suffisamment de mmoire et de 
      <a href="../misc/descriptors.html">descripteurs de fichiers</a> 
      pour l'coute de chaque alias IP de la machine. Il est seulement 
      possible d'appliquer la directive 
      <directive module="mpm_common">Listen</directive>, soit sur toutes 
      les adresses avec le joker "*", soit uniquement sur des adresses 
      spcifiques. Donc, si vous avez besoin d'couter une adresse 
      en particulier, vous devrez le faire pour l'ensemble des 
      autres adresses (Bien qu'il soit plus simple de lancer un 
      processus <program>httpd</program> pour couter N-1 adresses, 
      et un autre pour l'adresse restante).</li>
    </ul>

    <p>Utilisez un unique processus rsident lorsque&nbsp;:</p>

    <ul>
      <li>le partage de la configuration httpd entre les serveurs 
      virtuels est acceptable.</li>

      <li>la machine assume dj une grande quantit de requtes, et 
      que l'ajout de processus rsidents supplmentaires en affecterait 
      les performances.</li>
    </ul>

</section>

<section id="multiple"><title>Configuration de processus multiples</title>

    <p>Crez une installation indpendante du programme 
    <program>httpd</program> pour chaque serveur virtuel. Pour 
    chacune d'elle, utilisez la directive 
    <directive module="mpm_common">Listen</directive> dans le fichier 
    de configuration pour dfinir l'adresse IP (ou serveur virtuel) 
    que le processus rsident doit grer. Par exemple&nbsp;:</p>

    <example>
    Listen 192.168.0.1:80
    </example>

    <p>Il est recommand d'utiliser une adresse IP plutt qu'un nom 
    de domaine (consultez <a href="../dns-caveats.html">Problmes DNS 
    avec Apache</a>).</p>

</section>

<section id="single"><title>Configuration d'un unique processus 
rsident pour des serveurs virtuels</title>

    <p>Dans ce cas, un unique processus httpd va grer les requtes 
    pour le serveur principal et tous les serveurs virtuels. Dans le 
    fichier de configuration, la directive 
    <directive module="core">VirtualHost</directive> va servir  
    dfinir les autres directives 
    <directive module="core">ServerAdmin</directive>, 
    <directive module="core">ServerName</directive>, 
    <directive module="core">DocumentRoot</directive>, 
    <directive module="core">ErrorLog</directive> et 
    <directive module="mod_log_config">TransferLog</directive> ou 
    <directive module="mod_log_config">CustomLog</directive> avec des 
    valeurs diffrentes pour chaque serveur virtuel. Par exemple&nbsp;:</p>

    <example>
    &lt;VirtualHost 192.168.0.1:80&gt;<br />
    ServerAdmin webmaster@smallco.example.com<br />
    DocumentRoot /groups/smallco/www<br />
    ServerName smallco.example.com<br />
    ErrorLog /groups/smallco/logs/error_log<br />
    TransferLog /groups/smallco/logs/access_log<br />
    &lt;/VirtualHost&gt;<br />
		<br />
    &lt;VirtualHost 192.168.0.2:80&gt;<br />
    ServerAdmin webmaster@baygroup.example.org<br />
    DocumentRoot /groups/baygroup/www<br />
    ServerName baygroup.example.com<br />
    ErrorLog /groups/baygroup/logs/error_log<br />
    TransferLog /groups/baygroup/logs/access_log<br />
    &lt;/VirtualHost&gt;
		</example>

    <p>Il est recommand d'utiliser une adresse IP plutt qu'un nom 
    de domaine dans la dfinition du  &lt;VirtualHost&gt; (consultez <a
    href="../dns-caveats.html">Problmes DNS avec Apache</a>).</p>

    <p>Les adresses IP et ports explicites l'emportent sur leurs
    quivalents avec caractres gnriques, et tout serveur virtuel qui
    correspond  la requte l'emporte sur la configuration du serveur de
    base.</p>

    <p>Presque <strong>toutes</strong> les directives de configuration 
    peuvent tre employes dans une directive VirtualHost,  l'exception 
    des directives qui contrlent la cration du processus et de 
    quelques autres. Pour connatre celles utilisables dans une 
    directive VirtualHost, vrifiez leur 
    <a href="../mod/directive-dict.html#Context">Contexte</a> en utilisant 
    l'<a href="../mod/directives.html">Index des directives</a>.</p>

<!-- 
    <p>Les directives <directive module="mpm_common">User</directive> et  
    <directive module="mpm_common">Group</directive> NE doivent PLUS tre 
    utilises  l'intrieur d'une directive VirtualHost lors d'une 
    <a href="../suexec.html">excution sous suEXEC</a>. Voir la directive 
    <a href="../mod/mod_suexec.html/#suexecusergroup">SuexecUserGroup</a> dfinie 
    en remplacement depuis la version 2.0.</p>
 -->
    <p><directive module="mod_suexec">SuexecUserGroup</directive> peut tre
    utilises  l'intrieur d'une directive VirtualHost si l'excution se fait
    sous suEXEC. (Voir <a href="../suexec.html">suEXEC</a>).</p>

    <p><em>SCURIT&nbsp;:</em> lorsque vous spcifiez o crire les 
    fichiers journaux, soyez attentif aux risques si quelqu'un d'autre 
    que celui qui a dmarr Apache dispose des droits d'criture 
    sur l'emplacement de ces fichiers. Consultez les 
    <a href="../misc/security_tips.html">Conseils sur la scurit</a> 
    pour plus de dtails.</p>

</section>
</manualpage>
