<?xml version='1.0' encoding='ISO-8859-1' ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1363767 -->
<!-- french translation by alain B, review by Vincent Deffontaines -->
<!-- reviewed by Lucien Gentis -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="index.xml.meta">
<parentdocument href="../"/>

   <title>Documentation sur les serveurs virtuels Apache</title>

<summary>

    <p>Le principe des <cite>Serveurs Virtuels</cite> consiste  
    faire fonctionner un ou plusieurs serveurs Web (comme 
    <code>company1.example.com</code> and <code>company2.example.com</code>) 
    sur une mme machine. Les serveurs virtuels peuvent tre soit 
    "<a href="ip-based.html">par-IP</a>" o une adresse IP est 
    attribue pour chaque serveur Web, soit "<a href="name-based.html"
    >par-nom</a>" o plusieurs noms de domaine se ctoient sur 
    des mmes adresses IP. L'utilisateur final ne peroit pas 
    qu'en fait il s'agit d'un mme serveur physique.</p>

    <p>Apache a t le prcurseur des serveurs proposant cette 
    mthode de serveurs virtuels bass sur les adresses IP. Ses 
    versions 1.1 et suivantes proposent les deux 
    mthodes de serveurs virtuels : par-IP et par-nom. Cette 
    deuxime mthode est parfois galement appele <em>host-based</em> 
    ou <em>serveur virtuel non-IP</em>.</p>

    <p>Vous trouverez ci-dessous une liste documentaire qui vous 
    expliquera en dtails le fonctionnement des serveurs virtuels 
    au sein du serveur HTTP Apache :</p>

</summary>

<seealso><module>mod_vhost_alias</module></seealso>
<seealso><a href="name-based.html">Serveurs virtuels par-nom</a></seealso>
<seealso><a href="ip-based.html">Serveurs virtuels par-IP</a></seealso>
<seealso><a href="examples.html">Exemples de serveurs virtuels</a></seealso>
<seealso><a href="fd-limits.html">Limites des descripteurs de fichiers</a></seealso>
<seealso><a href="mass.html">Hbergement virtuel en masse</a></seealso>
<seealso><a href="details.html">Dtails sur les critres de choix du serveur</a></seealso>

<section id="support"><title>Support des serveurs virtuels</title>

    <ul>
      <li><a href="name-based.html">Serveurs Virtuels par-Nom</a> 
      (Un ou plusieurs sites Web par adresse IP)</li>
      <li><a href="ip-based.html">Serveurs Virtuels par-IP</a> 
      (Une adresse IP pour chaque site Web)</li>
      <li><a href="examples.html">Exemples de configurations classiques 
      de Serveurs Virtuels </a></li>
      <li><a href="fd-limits.html">Limites des descripteurs de fichiers</a> 
      (ou, <em>trop de fichiers journaux</em>)</li>
      <li><a href="mass.html">Configuration dynamique en masse de 
      Serveurs Virtuels</a></li>
      <li><a href="details.html">Explication approfondie des critres 
      de slection d'un Serveur Virtuel</a></li>
    </ul>

</section>

<section id="directives"><title>Directives de configuration</title>

    <ul>
      <li><directive module="core">NameVirtualHost</directive></li>
      <li><directive type="section"
           module="core">VirtualHost</directive></li>
      <li><directive module="core">ServerName</directive></li>
      <li><directive module="core">ServerAlias</directive></li>
      <li><directive module="core">ServerPath</directive></li>
    </ul>

    <p>Pour vrifier et analyser la configuration de vos serveurs 
    virtuels, vous pouvez utiliser l'argument <code>-S</code> sur 
    la ligne de commande lanant le programme Apache comme ceci&nbsp;:</p>

    <example>
    /usr/local/apache2/bin/httpd -S
    </example>

    <p>Cette commande affichera dans le dtail comment Apache a 
    trait son fichier de configuration. Les erreurs de configuration 
    peuvent tre corriges par l'examen attentif des adresses IP et 
    des noms de serveurs. (Consultez la documentation du programme 
    <program>httpd</program> pour les autres arguments de la ligne de 
    commande)</p>

</section>
</manualpage>
