<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "./style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="./style/manual.fr.xsl"?>
<!-- English Revision: 421100 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="filter.xml.meta">

  <title>Filtres</title>

  <summary>
    <p>Ce document d&#233;crit l'utilisation des filtres avec Apache.</p>
  </summary>

  <section id="intro">
    <title>Le filtrage avec Apache 2</title>
    <related>
      <modulelist>
	<module>mod_filter</module>
        <module>mod_deflate</module>
        <module>mod_ext_filter</module>
        <module>mod_include</module>
	<module>mod_charset_lite</module>
      </modulelist>
      <directivelist>
        <directive module="mod_filter">FilterChain</directive>
        <directive module="mod_filter">FilterDeclare</directive>
        <directive module="mod_filter">FilterProtocol</directive>
        <directive module="mod_filter">FilterProvider</directive>
        <directive module="mod_mime">AddInputFilter</directive>
        <directive module="mod_mime">AddOutputFilter</directive>
        <directive module="mod_mime">RemoveInputFilter</directive>
        <directive module="mod_mime">RemoveOutputFilter</directive>
        <directive module="mod_ext_filter">ExtFilterDefine</directive>
        <directive module="mod_ext_filter">ExtFilterOptions</directive>
        <directive module="core">SetInputFilter</directive>
        <directive module="core">SetOutputFilter</directive>
      </directivelist>
    </related>

<p>La cha&#238;ne de filtrage est disponible depuis la version 2.0 d'Apache,
et permet aux applications de traiter les donn&#233;es en entr&#233;e et en sortie
d'une mani&#232;re hautement flexible et configurable, quelle que soit la
provenance de ces donn&#233;es.  Il est possible de pr&#233;-traiter les donn&#233;es
en entr&#233;e, et post-traiter les donn&#233;es en sortie, comme souhait&#233;.
Ces traitements sont tout &#224; fait ind&#233;pendants des traditionnelles phases
de traitement des requ&#234;tes.</p>
<p class="figure">
<img src="images/filter_arch.png" width="569" height="392" alt=
"les filtres peuvent s'encha&#238;ner, perpendiculairement au traitement
des requ&#234;tes"
/>
</p>
<p>Voici quelques exemples de filtrage avec la distribution standard d'Apache:</p>
<ul>
<li><module>mod_include</module>, impl&#233;mente les inclusions c&#244;t&#233; serveur.</li>
<li><module>mod_ssl</module>, impl&#233;mente le cryptage SSL (https).</li>
<li><module>mod_deflate</module>, impl&#233;mente la compression/d&#233;compression
&#224; la vol&#233;e.</li>
<li><module>mod_charset_lite</module>, transcodage entre diff&#233;rents
jeux de caract&#232;res.</li>
<li><module>mod_ext_filter</module>, utilisation d'un programme externe
comme filtre.</li>
</ul>
<p>Apache utilise aussi plusieurs filtres en interne pour accomplir des t&#226;ches
comme le d&#233;coupage des grosses requ&#234;tes (chunking) et la gestion des
requ&#234;tes portant sur une partie d'un fichier (byte-range).</p>

<p>Un grand choix d'applications sont impl&#233;ment&#233;es par des modules de filtrage
tiers disponibles &#224; <a
href="http://modules.apache.org/">modules.apache.org</a> entre autres.
En voici quelques exemples :</p>

<ul>
<li>Traitement et r&#233;&#233;criture HTML et XML</li>
<li>Transformations XSLT et inclusions XML (XIncludes)</li>
<li>Support de l'espace de nommage XML</li>
<li>Gestion du chargement de fichier et d&#233;codage des formulaires HTML</li>
<li>Traitement d'image</li>
<li>Protection des applications vuln&#233;rables comme les scripts PHP</li>
<li>Edition de texte par Chercher/Remplacer</li>
</ul>
</section>

<section id="smart">
<title>Filtrage intelligent</title>
<p class="figure">
<img src="images/mod_filter_new.png" width="423" height="331"
alt="Le filtrage intelligent applique diff&#233;rents fournisseurs de filtrage en
fonction de l'&#233;tat du traitement de la requ&#234;te"/>
</p>
<p><module>mod_filter</module>, inclus dans les version 2.1 et sup&#233;rieures
d'Apache, permet de configurer la cha&#238;ne de filtrage dynamiquement
&#224; l'ex&#233;cution.
Ainsi par exemple, vous pouvez d&#233;finir un proxy pour r&#233;&#233;crire du code HTML
avec un filtre HTML et traiter des images JPEG avec un filtre totalement
s&#233;par&#233;, bien que le proxy ne poss&#232;de aucune information pr&#233;liminaire
sur ce que le serveur &#224; l'origine des donn&#233;es &#224; filtrer va envoyer.
Ceci fonctionne gr&#226;ce &#224; l'utilisation d'un gestionnaire de filtre,
qui distribue les t&#226;ches &#224; diff&#233;rents fournisseurs de filtrage en fonction
du contenu r&#233;el &#224; filtrer &#224; l'ex&#233;cution.  Tout filtre peut se voir soit
ins&#233;r&#233; directement dans la cha&#238;ne et lanc&#233; inconditionnellement, soit
utilis&#233; comme un fournisseur de filtrage et ins&#233;r&#233; dynamiquement.
Par exemple,</p>
<ul>
<li>un filtre de traitement HTML sera lanc&#233; uniquement si le contenu est
de type text/html ou application/xhtml+xml</li>
<li>Un filtre de compression sera lanc&#233; uniquement si les donn&#233;es en entr&#233;e
sont de type compressible et non d&#233;j&#224; compress&#233;es</li>
<li>Un filtre de conversion de jeux de caract&#232;res ne sera ins&#233;r&#233; que si
le document texte n'est pas d&#233;j&#224; dans le jeu de caract&#232;res voulu</li>
</ul>
</section>

<section id="using">
<title>Utilisation des filtres</title>
<p>Il y a deux mani&#232;res d'utiliser le filtrage : Simple et Dynamique.
En g&#233;n&#233;ral, vous utiliserez l'une ou l'autre m&#233;thode; le m&#233;lange des deux
peut avoir des cons&#233;quences inattendues (bien que le filtrage simple en entr&#233;e
puisse &#234;tre associ&#233; sans probl&#232;me avec le filtrage simple ou dynamique
en sortie).</p>
<p>La m&#233;thode Simple est la seule permettant de configurer les filtres
en entr&#233;e, et suffit pour les filtres en sortie pour lesquels vous avez besoin
d'une cha&#238;ne de filtres statique.
Les directives correspondantes sont
    <directive module="core">SetInputFilter</directive>,
    <directive module="core">SetOutputFilter</directive>,
    <directive module="mod_mime">AddInputFilter</directive>,
    <directive module="mod_mime">AddOutputFilter</directive>,
    <directive module="mod_mime">RemoveInputFilter</directive>, et
    <directive module="mod_mime">RemoveOutputFilter</directive>.</p>

<p>La m&#233;thode Dynamique permet une configuration dynamique des filtres en
sortie &#224; la fois statique et flexible, comme discut&#233; dans la page
<module>mod_filter</module>.
Les directives correspondantes sont
    <directive module="mod_filter">FilterChain</directive>,
    <directive module="mod_filter">FilterDeclare</directive>, et
    <directive module="mod_filter">FilterProvider</directive>.</p>

<p>Une autre directive <directive
module="core">AddOutputFilterByType</directive> est encore support&#233;e,
mais peut poser des probl&#232;mes et est maintenant obsol&#232;te. Utilisez la
configuration dynamique &#224; la place.</p>

  </section>
</manualpage>
