/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.events;

import com.oracle.jrockit.jfr.ContentType;
import com.oracle.jrockit.jfr.DataType;
import com.oracle.jrockit.jfr.InvalidValueException;
import com.oracle.jrockit.jfr.Transition;
import com.oracle.jrockit.jfr.UseConstantPool;
import com.oracle.jrockit.jfr.ValueDefinition;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import oracle.jrockit.jfr.events.ContentTypeImpl;

@Deprecated
public class ValueDescriptor {
    private final String id;
    private final String name;
    private final String description;
    private final String relationKey;
    private final Field field;
    private final Class<?> valueType;
    private final Transition transition;
    private final ContentTypeImpl contentType;
    private final DataType dataType;
    private final int innerType;
    private final String constantPool;
    private static final HashMap<Class<?>, DataType> types = new HashMap();

    public String getRelationKey() {
        return this.relationKey;
    }

    public ContentTypeImpl getContentTypeImpl() {
        return this.contentType;
    }

    public ContentType getContentType() {
        return this.contentType.getMapped();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public int getContentTypeOrdinal() {
        return this.contentType.getOrdinal();
    }

    public int getDataTypeOrdinal() {
        return this.dataType.ordinal();
    }

    public String getConstantPool() {
        return this.constantPool;
    }

    public ValueDescriptor(String string, String string2, String string3, String string4, ContentType contentType, Transition transition, String string5, Field field, Class<?> clazz) throws InvalidValueException {
        Class<?> clazz2;
        if (string == null || string.length() == 0) {
            if (field != null) {
                string = field.getName();
            } else {
                throw new NullPointerException("id");
            }
        }
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.field = field;
        this.transition = transition;
        this.valueType = clazz;
        this.relationKey = string4;
        this.constantPool = string5;
        if (string4 != null) {
            try {
                new URI(string4);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new InvalidValueException("Illegal relation key : " + string4, uRISyntaxException);
            }
        }
        if (!(clazz2 = clazz).isPrimitive() && clazz2 != Class.class && clazz2 != Thread.class && clazz2 != String.class) {
            throw new InvalidValueException("Unsupported value type " + clazz);
        }
        DataType dataType = types.get(clazz2);
        assert (dataType != null || !clazz2.isPrimitive());
        ContentTypeImpl contentTypeImpl = null;
        if (!clazz2.isPrimitive()) {
            contentTypeImpl = ContentTypeImpl.forClass(clazz2);
            if (contentType != ContentType.None && contentType != contentTypeImpl.getMapped()) {
                throw new InvalidValueException("Illegal content type " + (Object)((Object)contentType));
            }
            contentType = contentTypeImpl.getMapped();
            DataType dataType2 = contentTypeImpl.getType();
            if (dataType2 != null) {
                dataType = dataType2;
            }
        } else {
            contentTypeImpl = contentType != ContentType.None ? ContentTypeImpl.forContentType(contentType) : ContentTypeImpl.forClass(clazz2);
        }
        assert (contentTypeImpl != null);
        assert (dataType != null);
        if (!contentTypeImpl.isCompatible(dataType)) {
            throw new InvalidValueException("Field " + string2 + ", incompatible content type: " + contentTypeImpl);
        }
        this.contentType = contentTypeImpl;
        this.dataType = dataType;
        this.innerType = 0;
    }

    public ValueDescriptor(String string, String string2, String string3, String string4, Transition transition, DataType dataType, ContentTypeImpl contentTypeImpl, int n, String string5, Class<?> clazz) throws InvalidValueException {
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.transition = transition;
        this.dataType = dataType;
        this.contentType = contentTypeImpl;
        this.field = null;
        this.valueType = clazz;
        this.innerType = n;
        this.relationKey = string4;
        this.constantPool = string5;
    }

    public ValueDescriptor(ValueDescriptor valueDescriptor) {
        this.id = valueDescriptor.id;
        this.innerType = valueDescriptor.innerType;
        this.contentType = valueDescriptor.contentType;
        this.dataType = valueDescriptor.dataType;
        this.description = valueDescriptor.description;
        this.name = valueDescriptor.name;
        this.field = valueDescriptor.field;
        this.valueType = valueDescriptor.valueType;
        this.transition = valueDescriptor.transition;
        this.relationKey = valueDescriptor.relationKey;
        this.constantPool = valueDescriptor.constantPool;
    }

    public ValueDescriptor(ValueDefinition valueDefinition, UseConstantPool useConstantPool, Field field) throws InvalidValueException {
        this(valueDefinition.id(), valueDefinition.name(), valueDefinition.description(), valueDefinition.relationKey(), valueDefinition.contentType(), valueDefinition.transition(), useConstantPool != null ? useConstantPool.name() : null, field, field.getType());
        if (!valueDefinition.contentType().isAllowedForUserValue()) {
            throw new InvalidValueException("Illegal content type for user event : " + valueDefinition);
        }
        this.field.setAccessible(true);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Transition getTransition() {
        return this.transition;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getValueType() {
        return this.valueType;
    }

    public int getInnerType() {
        return this.innerType;
    }

    public Object loadValue(Object object) throws IllegalArgumentException {
        try {
            return this.field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.getMessage());
        }
    }

    public void setValue(Object object, Object object2) throws IllegalArgumentException {
        try {
            this.field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError(illegalAccessException.getMessage());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.id).append(" '").append(this.name).append("' ").append((Object)this.dataType).append(' ').append(this.contentType);
        return stringBuilder.toString();
    }

    static {
        for (DataType dataType : DataType.values()) {
            if (!dataType.isPrimary()) continue;
            types.put(dataType.getJavaType(), dataType);
        }
        types.put(Character.class, DataType.U2);
    }
}

