/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.InvalidEventDefinitionException;
import com.oracle.jrockit.jfr.NoSuchEventException;
import com.oracle.jrockit.jfr.Producer;
import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import oracle.jrockit.jfr.FlightRecorder;
import oracle.jrockit.jfr.FlightRecording;
import oracle.jrockit.jfr.JFR;
import oracle.jrockit.jfr.JFRStats;
import oracle.jrockit.jfr.Logger;
import oracle.jrockit.jfr.MetaProducer;
import oracle.jrockit.jfr.MsgLevel;
import oracle.jrockit.jfr.NoSuchProducerException;
import oracle.jrockit.jfr.Options;
import oracle.jrockit.jfr.ProducerDescriptor;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.RecordingObserver;
import oracle.jrockit.jfr.RecordingOptions;
import oracle.jrockit.jfr.RecordingOptionsImpl;
import oracle.jrockit.jfr.Repository;
import oracle.jrockit.jfr.RepositoryChunk;
import oracle.jrockit.jfr.Settings;
import oracle.jrockit.jfr.StringConstantPool;
import oracle.jrockit.jfr.events.EventControl;
import oracle.jrockit.jfr.events.EventDescriptor;
import oracle.jrockit.jfr.events.EventHandler;
import oracle.jrockit.jfr.events.EventHandlerCreator;
import oracle.jrockit.jfr.events.JavaEventDescriptor;
import oracle.jrockit.jfr.events.JavaProducerDescriptor;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.EventSettings;

@Deprecated
public abstract class JFRImpl
extends JFR
implements RecordingObserver {
    protected final Logger logger = Logger.loggerFor("jfr");
    protected final TimeZone timezone = TimeZone.getDefault();
    protected final Locale locale = Locale.getDefault();
    private final AtomicInteger idCounter = new AtomicInteger(4096);
    private final AtomicLong recordingCounter = new AtomicLong();
    private final HashMap<Integer, ProducerDescriptor> producerMap = new HashMap();
    private final HashMap<Integer, EventControl> eventsControls = new HashMap();
    private final Object eventLock = new Object();
    private final Object mbeanLock = new Object();
    private final Timer timer = new Timer("JFR request timer", true);
    private final HashMap<Long, Recording> recordings = new HashMap();
    private final Repository repository;
    private final Object startBarrier = new Object();
    private int numRealRecordings;
    private final FlightRecorder mbeanObject;
    private final Options options;
    private final MetaProducer metaProducer = new MetaProducer(this);
    private final Settings settings = new Settings(this.eventLock, this.eventsControls, this.recordings.values(), this.metaProducer);
    private Recording defaultRecording;
    List<MBeanServer> mbeanServers = Collections.emptyList();
    private boolean active = true;

    JFRImpl(Options options) {
        this.options = options;
        this.repository = new Repository(this, options, this.logger);
        try {
            this.mbeanObject = new FlightRecorder(options, this.logger, this);
        }
        catch (Exception exception) {
            this.logger.error("Could not create Flight Recorder MBean", exception);
            throw new InternalError();
        }
        List<String> list = options.settingsFiles();
        if (!list.isEmpty()) {
            String string = list.get(SettingsOffsets.FIRST_INDEX_POS.ordinal());
            int n = Integer.parseInt(string);
            this.logger.log(MsgLevel.TRACE, "Reading default event settings. Start index: " + string, new Object[0]);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n; i < list.size(); ++i) {
                stringBuffer.append(list.get(i));
            }
            try {
                this.settings.addEventDefaultSet(new EventDefaultSet(stringBuffer.toString(), false));
            }
            catch (Exception exception) {
                this.logger.log(MsgLevel.TRACE, "Unable to create the EventDefaultSet from event settings string!", new Object[0]);
                this.logger.log(MsgLevel.TRACE, stringBuffer.toString(), new Object[0]);
                this.logger.log(MsgLevel.TRACE, "Events might not be visible since applying default event settings failed", new Object[0]);
            }
            if (n > SettingsOffsets.ZERO_SETTINGS_FILES.ordinal()) {
                for (int i = 1; i < n; ++i) {
                    this.logger.log(MsgLevel.TRACE, "Trying to create event settings from file: " + list.get(i), new Object[0]);
                    try {
                        this.loadDefaultSettings(this.settings, list.get(i));
                        continue;
                    }
                    catch (Exception exception) {
                        this.logger.log(MsgLevel.TRACE, "Unable to load and apply settings from file: " + list.get(i), new Object[0]);
                    }
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                JFRImpl.this.shutdown();
                JFRImpl.this.destroy();
            }
        }));
        this.addProducer(this.metaProducer, this.metaProducer.getControls());
    }

    protected void startDefaultRecording() {
        if (this.options.defaultRecording()) {
            this.enableDefaultRecording();
        }
    }

    @Override
    public boolean active() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(MBeanServer mBeanServer) {
        JFRImpl.checkControl();
        Object object = this.mbeanLock;
        synchronized (object) {
            ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>(this.mbeanServers.size() + 1);
            arrayList.addAll(this.mbeanServers);
            arrayList.add(mBeanServer);
            this.mbeanServers = arrayList;
        }
        try {
            mBeanServer.registerMBean(this.getMBean(), new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException jMException) {
            // empty catch block
        }
        object = this.eventLock;
        synchronized (object) {
            for (Recording recording : this.recordings.values()) {
                if (recording.objectName == null) continue;
                this.bind(recording, mBeanServer);
            }
        }
    }

    private void bind(Recording recording, MBeanServer mBeanServer) {
        try {
            FlightRecording flightRecording = new FlightRecording(recording, this.mbeanObject);
            mBeanServer.registerMBean(flightRecording, recording.objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException | OpenDataException jMException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ObjectName bind(Recording recording) {
        try {
            Object object = this.eventLock;
            synchronized (object) {
                if (recording.objectName == null) {
                    this.logger.log(MsgLevel.TRACE, "Binding recording %s", recording);
                    recording.objectName = new ObjectName("com.oracle.jrockit:type=FlightRecording,id=" + recording.getId() + ",name=" + recording.getName());
                    if (recording.isReleased()) {
                        return null;
                    }
                    for (MBeanServer mBeanServer : this.mbeanServers) {
                        this.bind(recording, mBeanServer);
                    }
                }
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return recording.objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(MBeanServer mBeanServer) {
        JFRImpl.checkControl();
        Object object = this.mbeanLock;
        synchronized (object) {
            ArrayList<MBeanServer> arrayList = new ArrayList<MBeanServer>(this.mbeanServers.size());
            for (MBeanServer mBeanServer2 : this.mbeanServers) {
                if (mBeanServer2 == mBeanServer) continue;
                arrayList.add(mBeanServer2);
            }
            this.mbeanServers = arrayList;
        }
        try {
            mBeanServer.unregisterMBean(new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException jMException) {
            // empty catch block
        }
        object = this.eventLock;
        synchronized (object) {
            for (Recording recording : this.recordings.values()) {
                this.unbind(recording, mBeanServer);
            }
        }
    }

    private void unbind(Recording recording, MBeanServer mBeanServer) {
        if (recording.objectName == null) {
            return;
        }
        ObjectName objectName = recording.objectName;
        try {
            mBeanServer.unregisterMBean(objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
            // empty catch block
        }
    }

    private void unbind(Recording recording) {
        assert (Thread.holdsLock(this.eventLock));
        for (MBeanServer mBeanServer : this.mbeanServers) {
            this.unbind(recording, mBeanServer);
        }
    }

    EventSettings getEventSettings() {
        return this.settings;
    }

    @Override
    public void addProducer(Producer producer, int n, List<EventHandler> list, Map<String, StringConstantPool> map) {
        ArrayList<JavaEventDescriptor> arrayList = new ArrayList<JavaEventDescriptor>();
        for (EventHandler eventHandler : list) {
            arrayList.add(eventHandler.getDescriptor());
        }
        JavaProducerDescriptor javaProducerDescriptor = new JavaProducerDescriptor(n, producer.getName(), producer.getDescription(), producer.getURI(), arrayList, map);
        this.addProducer(javaProducerDescriptor, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventsToRegisteredProducer(Producer producer, int n, List<EventHandler> list, Map<String, StringConstantPool> map) {
        ProducerDescriptor producerDescriptor;
        Object object = this.eventLock;
        synchronized (object) {
            producerDescriptor = this.producerMap.get(n);
            if (producerDescriptor == null) {
                throw new IllegalStateException("Not a registered producer " + producer);
            }
            if (!producerDescriptor.getURI().equals(producer.getURI())) {
                throw new IllegalStateException(n + " already registered as other producer" + producerDescriptor);
            }
            if (!(producerDescriptor instanceof JavaProducerDescriptor)) {
                throw new InternalError();
            }
        }
        object = (JavaProducerDescriptor)producerDescriptor;
        ArrayList<JavaEventDescriptor> arrayList = new ArrayList<JavaEventDescriptor>();
        for (EventDescriptor object2 : ((JavaProducerDescriptor)object).getEvents()) {
            arrayList.add((JavaEventDescriptor)object2);
        }
        for (EventHandler eventHandler : list) {
            arrayList.add(eventHandler.getDescriptor());
        }
        object = new JavaProducerDescriptor(n, producer.getName(), producer.getDescription(), producer.getURI(), arrayList, map);
        this.addProducer((ProducerDescriptor)object, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addProducer(ProducerDescriptor producerDescriptor, Collection<? extends EventControl> collection) {
        this.add(producerDescriptor);
        Object object = this.eventLock;
        synchronized (object) {
            this.producerMap.put(producerDescriptor.getId(), producerDescriptor);
            for (EventControl eventControl : collection) {
                this.eventsControls.put(eventControl.getId(), eventControl);
            }
            this.settings.addEvents(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(int n) {
        ProducerDescriptor producerDescriptor = null;
        Object object = this.eventLock;
        synchronized (object) {
            producerDescriptor = this.producerMap.get(n);
            if (producerDescriptor == null) {
                return;
            }
            ArrayList<EventControl> arrayList = new ArrayList<EventControl>();
            EventSetting eventSetting = new EventSetting(0);
            for (EventDescriptor eventDescriptor : producerDescriptor.getEvents()) {
                EventControl eventControl = this.eventsControls.remove(eventDescriptor.getId());
                eventControl.apply(eventSetting);
                arrayList.add(eventControl);
            }
            this.settings.removeEvents(arrayList);
        }
        this.rotate();
        this.remove(producerDescriptor);
        object = this.eventLock;
        synchronized (object) {
            this.producerMap.remove(n);
        }
    }

    protected final void loadDefaultSettings(EventSettings eventSettings, String string) {
        try {
            eventSettings.addEventDefaultSet(this.findEventDefaultSet(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final EventDefaultSet findEventDefaultSet(String string) throws Exception {
        try {
            return EventDefaultSet.find(string);
        }
        catch (IOException iOException) {
            this.logger.log(MsgLevel.WARN, iOException, "Could not read %s", string);
            throw iOException;
        }
        catch (Exception exception) {
            this.logger.log(MsgLevel.WARN, exception, "Syntax error in %s", string);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final EventDescriptor getEvent(int n) throws NoSuchEventException {
        Object object = this.eventLock;
        synchronized (object) {
            EventControl eventControl = this.eventsControls.get(n);
            if (eventControl == null) {
                throw new NoSuchEventException(String.valueOf(n));
            }
            return eventControl.getDescriptor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProducerDescriptor getProducer(int n) throws NoSuchProducerException {
        Object object = this.eventLock;
        synchronized (object) {
            ProducerDescriptor producerDescriptor = this.producerMap.get(n);
            if (producerDescriptor == null) {
                throw new NoSuchProducerException(String.valueOf(n));
            }
            return producerDescriptor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<ProducerDescriptor> getProducers() {
        Object object = this.eventLock;
        synchronized (object) {
            return new ArrayList<ProducerDescriptor>(this.producerMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<EventDescriptor> getEvents() {
        ArrayList<EventDescriptor> arrayList = new ArrayList<EventDescriptor>();
        Object object = this.eventLock;
        synchronized (object) {
            for (EventControl eventControl : this.eventsControls.values()) {
                arrayList.add(eventControl.getDescriptor());
            }
        }
        return arrayList;
    }

    @Override
    public final EventHandler createHandler(JavaEventDescriptor javaEventDescriptor, Class<?> clazz, Map<String, StringConstantPool> map) throws InvalidEventDefinitionException {
        EventHandlerCreator eventHandlerCreator = new EventHandlerCreator(this, javaEventDescriptor, clazz, map);
        return eventHandlerCreator.createHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void started(Recording recording) {
        this.settings.update();
        assert (!Thread.holdsLock(this.eventLock));
        Object object = this.startBarrier;
        synchronized (object) {
            if (recording.isToDisk()) {
                int n = ++this.numRealRecordings;
                assert (n >= 1);
                if (n == 1) {
                    this.logger.debug("First recording starting...");
                    this.start(recording.isClone());
                }
                if (n > 1) {
                    this.logger.debug("Recording starting, issuing buffer rotation...");
                    this.rotate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopping(Recording recording) {
        assert (!Thread.holdsLock(this.eventLock));
        Object object = this.startBarrier;
        synchronized (object) {
            if (recording.isToDisk()) {
                int n = --this.numRealRecordings;
                assert (n >= 0);
                if (n == 0) {
                    this.logger.debug("Last recording stopping...");
                    this.stop();
                }
                if (n > 0) {
                    this.logger.debug("Recording stopping, issuing buffer rotation...");
                    this.rotate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stopped(Recording recording) {
        boolean bl;
        assert (!Thread.holdsLock(this.eventLock));
        assert (recording.isStoppingDone());
        Object object = this.eventLock;
        synchronized (object) {
            bl = this.defaultRecording == recording;
        }
        this.settings.update();
        if (bl) {
            this.disableDefaultRecording();
        }
    }

    @Override
    public final FlightRecorder getMBean() {
        return this.mbeanObject;
    }

    protected abstract void add(ProducerDescriptor var1);

    protected abstract void remove(ProducerDescriptor var1);

    protected abstract void rotate();

    protected abstract void start(boolean var1);

    protected abstract void stop();

    protected abstract void shutdown();

    public abstract ByteBuffer getThreadBuffer(int var1);

    public abstract void releaseThreadBuffer(ByteBuffer var1, boolean var2);

    public abstract long counterTime();

    public abstract long nanoToCounter(long var1);

    public abstract long stackTraceID(int var1);

    public abstract long classID(Class<?> var1);

    public abstract int threadID();

    public abstract JFRStats getJFRStats();

    @Override
    public int nextID() {
        return this.idCounter.incrementAndGet();
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    protected final void onNewChunk() {
        this.metaProducer.onNewChunk();
    }

    protected final void chunkDone() {
        this.metaProducer.chunkDone();
    }

    protected final Repository getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addChunk(RepositoryChunk repositoryChunk) {
        Object object = this.eventLock;
        synchronized (object) {
            for (Recording recording : this.recordings.values()) {
                recording.addChunk(repositoryChunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Recording getRecording(long l) throws NoSuchRecordingException {
        Object object = this.eventLock;
        synchronized (object) {
            Recording recording = this.recordings.get(l);
            if (recording == null) {
                throw new NoSuchRecordingException();
            }
            return recording;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Collection<Recording> getRecordings() {
        Object object = this.eventLock;
        synchronized (object) {
            return new ArrayList<Recording>(this.recordings.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Recording createRecording(String string, long l, boolean bl) throws InstanceAlreadyExistsException {
        if (string == null) {
            string = "Recording " + l;
        }
        Object object = this.eventLock;
        synchronized (object) {
            if (!this.active) {
                throw new UnsupportedOperationException("Shutdown");
            }
            if (this.recordings.containsKey(l)) {
                throw new InstanceAlreadyExistsException(string);
            }
            Recording recording = new Recording(this.logger, this.timer, string, l, this.settings.subAggregator(), bl, this);
            this.recordings.put(l, recording);
            return recording;
        }
    }

    final Recording createRecording(String string) {
        try {
            return this.createRecording(string, this.recordingCounter.incrementAndGet(), false);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw JFRImpl.cannotHappen(instanceAlreadyExistsException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Recording cloneRecording(Recording recording, String string, boolean bl) throws IOException {
        Recording recording2 = null;
        Object object = this.eventLock;
        synchronized (object) {
            try {
                recording2 = this.createRecording(string, this.recordingCounter.incrementAndGet(), true);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                throw JFRImpl.cannotHappen(instanceAlreadyExistsException);
            }
        }
        recording2.settingsAggregator.copy(recording.settingsAggregator);
        object = new RecordingOptionsImpl(recording);
        ((RecordingOptionsImpl)object).setMaxAge(0L, TimeUnit.NANOSECONDS);
        ((RecordingOptionsImpl)object).setMaxSize(0L);
        recording2.setOptions((RecordingOptions)object);
        if (recording.isStarted()) {
            recording2.start();
        }
        Object object2 = this.eventLock;
        synchronized (object2) {
            recording2.copyChunks(recording);
        }
        if (bl) {
            recording2.stop();
        }
        recording2.setMaxAge(recording.getMaxAge(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        recording2.setMaxSize(recording.getMaxSize());
        return recording2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableDefaultRecording() {
        Recording recording = null;
        Object object = this.eventLock;
        synchronized (object) {
            if (this.defaultRecording == null) {
                try {
                    this.defaultRecording = this.createRecording("HotSpot default", 0L, false);
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    throw JFRImpl.cannotHappen(instanceAlreadyExistsException);
                }
                this.defaultRecording.setToDisk(this.options.defaultRecordingToDisk());
                this.defaultRecording.setMaxAge(this.options.defaultRecordingMaxAge(), TimeUnit.NANOSECONDS);
                this.defaultRecording.setMaxSize(this.options.defaultRecordingMaxSize());
                recording = this.defaultRecording;
            }
        }
        if (recording != null) {
            recording.start();
            this.bind(recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disableDefaultRecording() {
        Recording recording = null;
        Object object = this.eventLock;
        synchronized (object) {
            recording = this.defaultRecording;
            this.defaultRecording = null;
        }
        if (recording != null) {
            this.release(recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(Recording recording) {
        if (recording.isRunning()) {
            try {
                recording.stop();
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (IOException iOException) {
                this.logger.log(MsgLevel.WARN, iOException, "Exception while stopping %s", recording);
            }
        }
        recording.release();
        Object object = this.eventLock;
        synchronized (object) {
            this.recordings.remove(recording.getId());
            this.unbind(recording);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isContinuousModeRunning() {
        Object object = this.eventLock;
        synchronized (object) {
            return this.recordings.containsKey(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        ArrayList<Recording> arrayList;
        try {
            for (MBeanServer iterator2 : this.mbeanServers) {
                iterator2.unregisterMBean(new ObjectName("com.oracle.jrockit:type=FlightRecorder"));
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException jMException) {
            // empty catch block
        }
        this.timer.cancel();
        Object object = this.eventLock;
        synchronized (object) {
            this.active = false;
            arrayList = new ArrayList<Recording>(this.recordings.values());
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Recording recording = (Recording)iterator.next();
            this.release(recording);
        }
        this.mbeanObject.destroy();
        this.repository.destroy();
    }

    private static enum SettingsOffsets {
        FIRST_INDEX_POS,
        ZERO_SETTINGS_FILES;

    }
}

