/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.StyleableStringProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.PopupControl;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Window;
import javafx.util.Duration;

public class Tooltip
extends PopupControl {
    private static String TOOLTIP_PROP_KEY = "javafx.scene.control.Tooltip";
    private static TooltipBehavior BEHAVIOR = new TooltipBehavior(new Duration(1000.0), new Duration(5000.0), new Duration(200.0), false);
    private final StringProperty text = new SimpleStringProperty(this, "text", "");
    private ObjectProperty<Node> graphic;
    private final ReadOnlyBooleanWrapper activated = new ReadOnlyBooleanWrapper(this, "activated");

    public static void install(Node node, Tooltip tooltip) {
        Tooltip.BEHAVIOR.install(node, tooltip);
    }

    public static void uninstall(Node node, Tooltip tooltip) {
        Tooltip.BEHAVIOR.uninstall(node);
    }

    public Tooltip() {
        this.bridge = new CSSBridge();
        this.initialize();
    }

    public Tooltip(String string) {
        this.bridge = new CSSBridge();
        this.setText(string);
        this.initialize();
    }

    private void initialize() {
        if (this.bridge != null) {
            this.getContent().clear();
            this.bridge.idProperty().unbind();
            this.bridge.styleProperty().unbind();
        }
        this.bridge.idProperty().bind(this.idProperty());
        this.bridge.styleProperty().bind(this.styleProperty());
        this.getContent().add(this.bridge);
        this.getStyleClass().setAll((String[])new String[]{"tooltip"});
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String string) {
        if (this.isShowing() && string != null && !string.equals(this.getText())) {
            this.setX(BEHAVIOR.lastMouseX);
            this.setY(BEHAVIOR.lastMouseY);
        }
        this.textProperty().setValue(string);
    }

    public final String getText() {
        return this.text == null ? "" : this.text.getValue();
    }

    public final void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignmentProperty().setValue(textAlignment);
    }

    public final TextAlignment getTextAlignment() {
        return ((CSSBridge)this.bridge).textAlignment == null ? TextAlignment.LEFT : (TextAlignment)((Object)((CSSBridge)this.bridge).textAlignment.getValue());
    }

    public final ObjectProperty<TextAlignment> textAlignmentProperty() {
        return ((CSSBridge)this.bridge).textAlignmentProperty();
    }

    public final void setTextOverrun(OverrunStyle overrunStyle) {
        this.textOverrunProperty().setValue(overrunStyle);
    }

    public final OverrunStyle getTextOverrun() {
        return ((CSSBridge)this.bridge).textOverrun == null ? OverrunStyle.ELLIPSIS : (OverrunStyle)((Object)((CSSBridge)this.bridge).textOverrun.getValue());
    }

    public final ObjectProperty<OverrunStyle> textOverrunProperty() {
        return ((CSSBridge)this.bridge).textOverrunProperty();
    }

    public final void setWrapText(boolean bl) {
        this.wrapTextProperty().setValue(bl);
    }

    public final boolean isWrapText() {
        return ((CSSBridge)this.bridge).wrapText == null ? false : ((CSSBridge)this.bridge).wrapText.getValue();
    }

    public final BooleanProperty wrapTextProperty() {
        return ((CSSBridge)this.bridge).wrapTextProperty();
    }

    public final void setFont(Font font) {
        this.fontProperty().setValue(font);
    }

    public final Font getFont() {
        return ((CSSBridge)this.bridge).font == null ? Font.getDefault() : (Font)((CSSBridge)this.bridge).font.getValue();
    }

    public final ObjectProperty<Font> fontProperty() {
        return ((CSSBridge)this.bridge).fontProperty();
    }

    public final void setGraphic(Node node) {
        this.graphicProperty().setValue(node);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.getValue();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new ObjectPropertyBase<Node>(){

                @Override
                public Object getBean() {
                    return Tooltip.this;
                }

                @Override
                public String getName() {
                    return "graphic";
                }
            };
        }
        return this.graphic;
    }

    public final void setContentDisplay(ContentDisplay contentDisplay) {
        this.contentDisplayProperty().setValue(contentDisplay);
    }

    public final ContentDisplay getContentDisplay() {
        return ((CSSBridge)this.bridge).contentDisplay == null ? ContentDisplay.LEFT : (ContentDisplay)((Object)((CSSBridge)this.bridge).contentDisplay.getValue());
    }

    public final ObjectProperty<ContentDisplay> contentDisplayProperty() {
        return ((CSSBridge)this.bridge).contentDisplayProperty();
    }

    public final void setGraphicTextGap(double d) {
        this.graphicTextGapProperty().setValue(d);
    }

    public final double getGraphicTextGap() {
        return ((CSSBridge)this.bridge).graphicTextGap == null ? 4.0 : ((CSSBridge)this.bridge).graphicTextGap.getValue();
    }

    public final DoubleProperty graphicTextGapProperty() {
        return ((CSSBridge)this.bridge).graphicTextGapProperty();
    }

    final void setActivated(boolean bl) {
        this.activated.set(bl);
    }

    public final boolean isActivated() {
        return this.activated.get();
    }

    public final ReadOnlyBooleanProperty activatedProperty() {
        return this.activated.getReadOnlyProperty();
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return Tooltip.impl_CSS_STYLEABLES();
    }

    private static class TooltipBehavior {
        private Timeline activationTimer = new Timeline();
        private Timeline hideTimer = new Timeline();
        private Timeline leftTimer = new Timeline();
        private Node hoveredNode;
        private Tooltip activatedTooltip;
        private Tooltip visibleTooltip;
        private double lastMouseX;
        private double lastMouseY;
        private boolean hideOnExit;
        private EventHandler<MouseEvent> MOVE_HANDLER = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                double d = mouseEvent.getScreenX();
                double d2 = mouseEvent.getScreenY();
                if (d == TooltipBehavior.this.lastMouseX && d2 == TooltipBehavior.this.lastMouseY) {
                    return;
                }
                TooltipBehavior.this.lastMouseX = d;
                TooltipBehavior.this.lastMouseY = d2;
                if (TooltipBehavior.this.hideTimer.getStatus() == Animation.Status.RUNNING) {
                    return;
                }
                TooltipBehavior.this.hoveredNode = (Node)mouseEvent.getSource();
                Tooltip tooltip = (Tooltip)TooltipBehavior.this.hoveredNode.getProperties().get(TOOLTIP_PROP_KEY);
                if (tooltip != null) {
                    Window window = TooltipBehavior.this.getWindow(TooltipBehavior.this.hoveredNode);
                    boolean bl = TooltipBehavior.this.isWindowHierarchyVisible(TooltipBehavior.this.hoveredNode);
                    if (window != null && bl) {
                        if (TooltipBehavior.this.leftTimer.getStatus() == Animation.Status.RUNNING) {
                            if (TooltipBehavior.this.visibleTooltip != null) {
                                TooltipBehavior.this.visibleTooltip.hide();
                            }
                            TooltipBehavior.this.visibleTooltip = tooltip;
                            TooltipBehavior.this.hoveredNode = null;
                            tooltip.show(window, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                            TooltipBehavior.this.leftTimer.stop();
                            TooltipBehavior.this.hideTimer.playFromStart();
                        } else {
                            tooltip.setActivated(true);
                            TooltipBehavior.this.activatedTooltip = tooltip;
                            TooltipBehavior.this.activationTimer.stop();
                            TooltipBehavior.this.activationTimer.playFromStart();
                        }
                    }
                }
            }
        };
        private EventHandler<MouseEvent> LEAVING_HANDLER = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                double d = mouseEvent.getScreenX();
                double d2 = mouseEvent.getScreenY();
                if (d == TooltipBehavior.this.lastMouseX && d2 == TooltipBehavior.this.lastMouseY) {
                    return;
                }
                if (TooltipBehavior.this.activationTimer.getStatus() == Animation.Status.RUNNING) {
                    TooltipBehavior.this.activationTimer.stop();
                } else if (TooltipBehavior.this.hideTimer.getStatus() == Animation.Status.RUNNING) {
                    assert (TooltipBehavior.this.visibleTooltip != null);
                    TooltipBehavior.this.hideTimer.stop();
                    if (TooltipBehavior.this.hideOnExit) {
                        TooltipBehavior.this.visibleTooltip.hide();
                    }
                    TooltipBehavior.this.leftTimer.playFromStart();
                }
                TooltipBehavior.this.hoveredNode = null;
                TooltipBehavior.this.activatedTooltip = null;
                if (TooltipBehavior.this.hideOnExit) {
                    TooltipBehavior.this.visibleTooltip = null;
                }
            }
        };
        private EventHandler<MouseEvent> KILL_HANDLER = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                TooltipBehavior.this.activationTimer.stop();
                TooltipBehavior.this.hideTimer.stop();
                TooltipBehavior.this.leftTimer.stop();
                if (TooltipBehavior.this.visibleTooltip != null) {
                    TooltipBehavior.this.visibleTooltip.hide();
                }
                TooltipBehavior.this.hoveredNode = null;
                TooltipBehavior.this.activatedTooltip = null;
                TooltipBehavior.this.visibleTooltip = null;
            }
        };

        TooltipBehavior(Duration duration, Duration duration2, Duration duration3, final boolean bl) {
            this.hideOnExit = bl;
            this.activationTimer.getKeyFrames().add(new KeyFrame(duration, new KeyValue[0]));
            this.activationTimer.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    assert (TooltipBehavior.this.activatedTooltip != null);
                    Window window = TooltipBehavior.this.getWindow(TooltipBehavior.this.hoveredNode);
                    boolean bl = TooltipBehavior.this.isWindowHierarchyVisible(TooltipBehavior.this.hoveredNode);
                    if (window != null && window.isShowing() && bl) {
                        TooltipBehavior.this.activatedTooltip.show(window, TooltipBehavior.this.lastMouseX, TooltipBehavior.this.lastMouseY);
                        TooltipBehavior.this.visibleTooltip = TooltipBehavior.this.activatedTooltip;
                        TooltipBehavior.this.hoveredNode = null;
                        TooltipBehavior.this.hideTimer.playFromStart();
                    }
                    TooltipBehavior.this.activatedTooltip.setActivated(false);
                    TooltipBehavior.this.activatedTooltip = null;
                }
            });
            this.hideTimer.getKeyFrames().add(new KeyFrame(duration2, new KeyValue[0]));
            this.hideTimer.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    assert (TooltipBehavior.this.visibleTooltip != null);
                    TooltipBehavior.this.visibleTooltip.hide();
                    TooltipBehavior.this.visibleTooltip = null;
                    TooltipBehavior.this.hoveredNode = null;
                }
            });
            this.leftTimer.getKeyFrames().add(new KeyFrame(duration3, new KeyValue[0]));
            this.leftTimer.setOnFinished(new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    if (!bl) {
                        assert (TooltipBehavior.this.visibleTooltip != null);
                        TooltipBehavior.this.visibleTooltip.hide();
                        TooltipBehavior.this.visibleTooltip = null;
                        TooltipBehavior.this.hoveredNode = null;
                    }
                }
            });
        }

        private void install(Node node, Tooltip tooltip) {
            if (node == null) {
                return;
            }
            node.addEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.addEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            node.getProperties().put(TOOLTIP_PROP_KEY, tooltip);
        }

        private void uninstall(Node node) {
            if (node == null) {
                return;
            }
            node.removeEventHandler(MouseEvent.MOUSE_MOVED, this.MOVE_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_EXITED, this.LEAVING_HANDLER);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.KILL_HANDLER);
            Tooltip tooltip = (Tooltip)node.getProperties().get(TOOLTIP_PROP_KEY);
            if (tooltip != null) {
                node.getProperties().remove(TOOLTIP_PROP_KEY);
                if (tooltip.equals(this.visibleTooltip) || tooltip.equals(this.activatedTooltip)) {
                    this.KILL_HANDLER.handle(null);
                }
            }
        }

        private Window getWindow(Node node) {
            Scene scene = node == null ? null : node.getScene();
            return scene == null ? null : scene.getWindow();
        }

        private boolean isWindowHierarchyVisible(Node node) {
            Parent parent;
            boolean bl = node != null;
            Parent parent2 = parent = node == null ? null : node.getParent();
            while (parent != null && bl) {
                bl = parent.isVisible();
                parent = parent.getParent();
            }
            return bl;
        }
    }

    private final class CSSBridge
    extends PopupControl.CSSBridge {
        private ObjectProperty<TextAlignment> textAlignment;
        private ObjectProperty<OverrunStyle> textOverrun;
        private BooleanProperty wrapText;
        private ObjectProperty<Font> font;
        private StringProperty imageUrl = null;
        private ObjectProperty<ContentDisplay> contentDisplay;
        private DoubleProperty graphicTextGap;

        private CSSBridge() {
        }

        @Override
        public void impl_pseudoClassStateChanged(String string) {
            super.impl_pseudoClassStateChanged(string);
        }

        @Override
        public List<StyleableProperty> impl_getStyleableProperties() {
            return Tooltip.this.impl_getStyleableProperties();
        }

        private final ObjectProperty<TextAlignment> textAlignmentProperty() {
            if (this.textAlignment == null) {
                this.textAlignment = new StyleableObjectProperty<TextAlignment>(TextAlignment.LEFT){

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.TEXT_ALIGNMENT;
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "textAlignment";
                    }
                };
            }
            return this.textAlignment;
        }

        private final ObjectProperty<OverrunStyle> textOverrunProperty() {
            if (this.textOverrun == null) {
                this.textOverrun = new StyleableObjectProperty<OverrunStyle>(OverrunStyle.ELLIPSIS){

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.TEXT_OVERRUN;
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "textOverrun";
                    }
                };
            }
            return this.textOverrun;
        }

        private final BooleanProperty wrapTextProperty() {
            if (this.wrapText == null) {
                this.wrapText = new StyleableBooleanProperty(false){

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.WRAP_TEXT;
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "wrapText";
                    }
                };
            }
            return this.wrapText;
        }

        private final ObjectProperty<Font> fontProperty() {
            if (this.font == null) {
                this.font = new StyleableObjectProperty<Font>(Font.getDefault()){

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.FONT;
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "font";
                    }
                };
            }
            return this.font;
        }

        private StringProperty imageUrlProperty() {
            if (this.imageUrl == null) {
                this.imageUrl = new StyleableStringProperty(){

                    @Override
                    protected void invalidated() {
                        Object var1_1 = null;
                        if (this.get() != null) {
                            URL uRL = null;
                            try {
                                uRL = new URL(this.get());
                            }
                            catch (MalformedURLException malformedURLException) {
                                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                                uRL = classLoader.getResource(this.get());
                            }
                            if (uRL != null) {
                                Tooltip.this.setGraphic(new ImageView(new Image(uRL.toExternalForm())));
                            }
                        } else {
                            Tooltip.this.setGraphic(null);
                        }
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "imageUrl";
                    }

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.GRAPHIC;
                    }
                };
            }
            return this.imageUrl;
        }

        private final ObjectProperty<ContentDisplay> contentDisplayProperty() {
            if (this.contentDisplay == null) {
                this.contentDisplay = new StyleableObjectProperty<ContentDisplay>(ContentDisplay.LEFT){

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.CONTENT_DISPLAY;
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "contentDisplay";
                    }
                };
            }
            return this.contentDisplay;
        }

        private final DoubleProperty graphicTextGapProperty() {
            if (this.graphicTextGap == null) {
                this.graphicTextGap = new StyleableDoubleProperty(4.0){

                    @Override
                    public StyleableProperty getStyleableProperty() {
                        return StyleableProperties.GRAPHIC_TEXT_GAP;
                    }

                    @Override
                    public Object getBean() {
                        return CSSBridge.this;
                    }

                    @Override
                    public String getName() {
                        return "graphicTextGap";
                    }
                };
            }
            return this.graphicTextGap;
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty<CSSBridge, Font> FONT = new StyleableProperty.FONT<CSSBridge>("-fx-font", Font.getDefault()){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.font == null || !cSSBridge.font.isBound();
            }

            @Override
            public WritableValue<Font> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.fontProperty();
            }
        };
        private static final StyleableProperty<CSSBridge, TextAlignment> TEXT_ALIGNMENT = new StyleableProperty<CSSBridge, TextAlignment>("-fx-text-alignment", new EnumConverter(TextAlignment.class), TextAlignment.LEFT){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.textAlignment == null || !cSSBridge.textAlignment.isBound();
            }

            @Override
            public WritableValue<TextAlignment> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.textAlignmentProperty();
            }
        };
        private static final StyleableProperty<CSSBridge, OverrunStyle> TEXT_OVERRUN = new StyleableProperty<CSSBridge, OverrunStyle>("-fx-text-overrun", new EnumConverter(OverrunStyle.class), OverrunStyle.ELLIPSIS){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.textOverrun == null || !cSSBridge.textOverrun.isBound();
            }

            @Override
            public WritableValue<OverrunStyle> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.textOverrunProperty();
            }
        };
        private static final StyleableProperty<CSSBridge, Boolean> WRAP_TEXT = new StyleableProperty<CSSBridge, Boolean>("-fx-wrap-text", (StyleConverter)BooleanConverter.getInstance(), Boolean.FALSE){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.wrapText == null || !cSSBridge.wrapText.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.wrapTextProperty();
            }
        };
        private static final StyleableProperty<CSSBridge, String> GRAPHIC = new StyleableProperty<CSSBridge, String>("-fx-graphic", (StyleConverter)StringConverter.getInstance()){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.imageUrl == null || !cSSBridge.imageUrl.isBound();
            }

            @Override
            public WritableValue<String> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.imageUrlProperty();
            }
        };
        private static final StyleableProperty<CSSBridge, ContentDisplay> CONTENT_DISPLAY = new StyleableProperty<CSSBridge, ContentDisplay>("-fx-content-display", new EnumConverter(ContentDisplay.class), ContentDisplay.LEFT){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.contentDisplay == null || !cSSBridge.contentDisplay.isBound();
            }

            @Override
            public WritableValue<ContentDisplay> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.contentDisplayProperty();
            }
        };
        private static final StyleableProperty<CSSBridge, Number> GRAPHIC_TEXT_GAP = new StyleableProperty<CSSBridge, Number>("-fx-graphic-text-gap", (StyleConverter)SizeConverter.getInstance(), (Number)4.0){

            @Override
            public boolean isSettable(CSSBridge cSSBridge) {
                return cSSBridge.graphicTextGap == null || !cSSBridge.graphicTextGap.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(CSSBridge cSSBridge) {
                return cSSBridge.graphicTextGapProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(PopupControl.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, FONT, TEXT_ALIGNMENT, TEXT_OVERRUN, WRAP_TEXT, GRAPHIC, CONTENT_DISPLAY, GRAPHIC_TEXT_GAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

