/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.prism.CompositeMode;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.d3d.D3DFrameStats;
import com.sun.prism.d3d.D3DResourceFactory;
import com.sun.prism.d3d.D3DVertexBuffer;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.ps.Shader;

class D3DContext
extends BaseShaderContext {
    public static final int D3DERR_DEVICENOTRESET = -2005530519;
    public static final int D3DERR_DEVICELOST = -2005530520;
    public static final int E_FAIL = -2147467259;
    public static final int D3DERR_OUTOFVIDEOMEMORY = -2005532292;
    public static final int D3D_OK = 0;
    private static GeneralTransform3D projViewTx = new GeneralTransform3D();
    private BaseShaderContext.State state;
    private boolean isLost = false;
    private final long pContext;
    private final D3DResourceFactory factory;

    public static boolean FAILED(int n) {
        return n < 0;
    }

    static VertexBuffer createVertexBuffer(long l) {
        return new D3DVertexBuffer(l, 256);
    }

    D3DContext(long l, Screen screen, D3DResourceFactory d3DResourceFactory) {
        super(screen, d3DResourceFactory, D3DContext.createVertexBuffer(l));
        this.pContext = l;
        this.factory = d3DResourceFactory;
    }

    @Override
    public D3DResourceFactory getResourceFactory() {
        return this.factory;
    }

    protected void initState() {
        this.init();
        this.state = new BaseShaderContext.State();
        D3DContext.validate(D3DContext.nSetBlendEnabled(this.pContext, true, false));
        D3DContext.validate(D3DContext.nSet2DVShaderAndVertexBuffer(this.pContext));
    }

    long getContextHandle() {
        return this.pContext;
    }

    boolean isLost() {
        return this.isLost;
    }

    static void validate(int n) {
        if (PrismSettings.verbose && D3DContext.FAILED(n)) {
            System.out.println("D3D hresult failed :" + D3DContext.hResultToString(n));
            new Exception("Stack trace").printStackTrace(System.out);
        }
    }

    private void setLost() {
        this.isLost = true;
    }

    boolean testLostStateAndReset() {
        int n = D3DResourceFactory.nTestCooperativeLevel(this.pContext);
        if (n == -2005530520) {
            this.setLost();
        }
        if (n == -2005530519) {
            this.setLost();
            this.disposeLCDBuffer();
            this.factory.notifyReset();
            n = D3DResourceFactory.nResetDevice(this.pContext);
            if (n == 0) {
                this.isLost = false;
                this.initState();
            }
        }
        return n == 0;
    }

    boolean validatePresent(int n) {
        if (n == -2005530520 || n == -2005530519) {
            this.setLost();
        } else {
            D3DContext.validate(n);
        }
        return n == 0;
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget renderTarget, PrismCameraImpl prismCameraImpl, boolean bl) {
        int n = D3DContext.nSetRenderTarget(this.pContext, renderTarget.getNativeDestHandle());
        D3DContext.validate(n);
        int n2 = renderTarget.getPhysicalWidth();
        int n3 = renderTarget.getPhysicalHeight();
        GeneralTransform3D generalTransform3D = prismCameraImpl.getProjViewTx(projViewTx, n2, n3);
        n = D3DContext.nSetProjViewMatrix(this.pContext, bl, generalTransform3D.get(0), generalTransform3D.get(1), generalTransform3D.get(2), generalTransform3D.get(3), generalTransform3D.get(4), generalTransform3D.get(5), generalTransform3D.get(6), generalTransform3D.get(7), generalTransform3D.get(8), generalTransform3D.get(9), generalTransform3D.get(10), generalTransform3D.get(11), generalTransform3D.get(12), generalTransform3D.get(13), generalTransform3D.get(14), generalTransform3D.get(15));
        D3DContext.validate(n);
        return this.state;
    }

    @Override
    protected void updateTexture(int n, Texture texture) {
        int n2;
        boolean bl;
        long l;
        if (texture != null) {
            l = texture.getNativeSourceHandle();
            bl = texture.getLinearFiltering();
            n2 = texture.getWrapMode().ordinal();
        } else {
            l = 0L;
            bl = false;
            n2 = 0;
        }
        D3DContext.validate(D3DContext.nSetTexture(this.pContext, l, n, bl, n2));
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform baseTransform) {
        int n = baseTransform == null || baseTransform.isIdentity() ? D3DContext.nResetTransform(this.pContext) : D3DContext.nSetTransform(this.pContext, baseTransform.getMxx(), baseTransform.getMxy(), baseTransform.getMxz(), baseTransform.getMxt(), baseTransform.getMyx(), baseTransform.getMyy(), baseTransform.getMyz(), baseTransform.getMyt(), baseTransform.getMzx(), baseTransform.getMzy(), baseTransform.getMzz(), baseTransform.getMzt(), 0.0, 0.0, 0.0, 1.0);
        D3DContext.validate(n);
    }

    @Override
    protected void updateClipRect(Rectangle rectangle) {
        int n;
        if (rectangle == null || rectangle.isEmpty()) {
            n = D3DContext.nResetClipRect(this.pContext);
        } else {
            int n2 = rectangle.x;
            int n3 = rectangle.y;
            int n4 = n2 + rectangle.width;
            int n5 = n3 + rectangle.height;
            n = D3DContext.nSetClipRect(this.pContext, n2, n3, n4, n5);
        }
        D3DContext.validate(n);
    }

    @Override
    protected void updateCompositeMode(CompositeMode compositeMode) {
        int n;
        switch (compositeMode) {
            case CLEAR: {
                n = D3DContext.nSetBlendEnabled(this.pContext, true, true);
                break;
            }
            case SRC: {
                n = D3DContext.nSetBlendEnabled(this.pContext, false, false);
                break;
            }
            case SRC_OVER: {
                n = D3DContext.nSetBlendEnabled(this.pContext, true, false);
                break;
            }
            default: {
                throw new InternalError("Unrecognized composite mode: " + (Object)((Object)compositeMode));
            }
        }
        D3DContext.validate(n);
    }

    void sync() {
        this.getVertexBuffer().flush();
    }

    D3DFrameStats getFrameStats(boolean bl, D3DFrameStats d3DFrameStats) {
        if (d3DFrameStats == null) {
            d3DFrameStats = new D3DFrameStats();
        }
        return D3DContext.nGetFrameStats(this.pContext, d3DFrameStats, bl) ? d3DFrameStats : null;
    }

    private static native int nSetRenderTarget(long var0, long var2);

    private static native int nSetTexture(long var0, long var2, int var4, boolean var5, int var6);

    private static native int nResetTransform(long var0);

    private static native int nSetTransform(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, double var28, double var30, double var32);

    private static native int nSetProjViewMatrix(long var0, boolean var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    private static native int nResetClipRect(long var0);

    private static native int nSetClipRect(long var0, int var2, int var3, int var4, int var5);

    private static native int nSetBlendEnabled(long var0, boolean var2, boolean var3);

    private static native int nSet2DVShaderAndVertexBuffer(long var0);

    private static native boolean nGetFrameStats(long var0, D3DFrameStats var2, boolean var3);

    public static String hResultToString(long l) {
        switch ((int)l) {
            case -2005530519: {
                return "D3DERR_DEVICENOTRESET";
            }
            case -2005530520: {
                return "D3DERR_DEVICELOST";
            }
            case -2005532292: {
                return "D3DERR_OUTOFVIDEOMEMORY";
            }
            case 0: {
                return "D3D_OK";
            }
        }
        return "D3D_ERROR " + Long.toHexString(l);
    }
}

