/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public abstract class Pixels {
    protected final int width;
    protected final int height;
    protected final int bytesPerComponent;
    protected final ByteBuffer bytes;
    protected final IntBuffer ints;

    public static int getNativeFormat() {
        return Application.GetApplication().staticPixels_getNativeFormat();
    }

    protected Pixels(int width, int height, ByteBuffer pixels) {
        this.width = width;
        this.height = height;
        this.bytesPerComponent = 1;
        this.bytes = pixels.slice();
        if (this.width <= 0 || this.height <= 0 || this.width * this.height * 4 > this.bytes.capacity()) {
            throw new IllegalArgumentException("Too small byte buffer size " + this.width + "x" + this.height + " [" + this.width * this.height * 4 + "] > " + this.bytes.capacity());
        }
        this.ints = null;
    }

    protected Pixels(int width, int height, IntBuffer pixels) {
        this.width = width;
        this.height = height;
        this.bytesPerComponent = 4;
        this.ints = pixels.slice();
        if (this.width <= 0 || this.height <= 0 || this.width * this.height > this.ints.capacity()) {
            throw new IllegalArgumentException("Too small int buffer size " + this.width + "x" + this.height + " [" + this.width * this.height + "] > " + this.ints.capacity());
        }
        this.bytes = null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBytesPerComponent() {
        return this.bytesPerComponent;
    }

    public Buffer getPixels() {
        if (this.bytes != null) {
            this.bytes.rewind();
            return this.bytes;
        }
        if (this.ints != null) {
            this.ints.rewind();
            return this.ints;
        }
        throw new RuntimeException("Unexpected Pixels state.");
    }

    public ByteBuffer asByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocateDirect(this.getWidth() * this.getHeight() * 4);
        bb.order(ByteOrder.nativeOrder());
        bb.rewind();
        this.asByteBuffer(bb);
        return bb;
    }

    public void asByteBuffer(ByteBuffer bb) {
        if (!bb.isDirect()) {
            throw new RuntimeException("Expected direct buffer.");
        }
        if (bb.remaining() < this.getWidth() * this.getHeight() * 4) {
            throw new RuntimeException("Too small buffer.");
        }
        this._fillDirectByteBuffer(bb);
    }

    private void attachData(long ptr) {
        int[] array;
        if (this.ints != null) {
            array = !this.ints.isDirect() ? this.ints.array() : null;
            this._attachInt(ptr, this.width, this.height, this.ints, array, array != null ? this.ints.arrayOffset() : 0);
        }
        if (this.bytes != null) {
            array = !this.bytes.isDirect() ? this.bytes.array() : null;
            this._attachByte(ptr, this.width, this.height, this.bytes, (byte[])array, array != null ? this.bytes.arrayOffset() : 0);
        }
    }

    protected abstract void _fillDirectByteBuffer(ByteBuffer var1);

    protected abstract void _attachInt(long var1, int var3, int var4, IntBuffer var5, int[] var6, int var7);

    protected abstract void _attachByte(long var1, int var3, int var4, ByteBuffer var5, byte[] var6, int var7);

    public boolean equals(Object object) {
        boolean equals;
        boolean bl = equals = object != null && this.getClass().equals(object.getClass());
        if (equals) {
            Pixels pixels = (Pixels)object;
            boolean bl2 = equals = this.getWidth() == pixels.getWidth() && this.getHeight() == pixels.getHeight();
            if (equals) {
                ByteBuffer b2;
                ByteBuffer b1 = this.asByteBuffer();
                equals = b1.compareTo(b2 = pixels.asByteBuffer()) == 0;
            }
        }
        return equals;
    }

    public int hashCode() {
        int val = this.getWidth();
        val = 31 * val + this.getHeight();
        val = 17 * val + this.asByteBuffer().hashCode();
        return val;
    }

    public static class Format {
        public static final int BYTE_BGRA_PRE = 1;
        public static final int BYTE_ARGB = 2;
    }
}

