/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners.index;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSisuIndex {
    static final String META_INF_SISU = "META-INF/sisu/";
    private final Map<Object, Set<String>> index = new HashMap<Object, Set<String>>();

    protected final synchronized void addClassToIndex(Object anno, Object clazz) {
        Set<String> table = this.index.get(anno);
        if (null == table) {
            table = this.readTable(anno);
            this.index.put(anno, table);
        }
        table.add(String.valueOf(clazz));
    }

    protected final synchronized void flushIndex() {
        for (Map.Entry<Object, Set<String>> entry : this.index.entrySet()) {
            this.writeTable(entry.getKey(), entry.getValue());
        }
    }

    protected abstract void info(String var1);

    protected abstract void warn(String var1);

    protected abstract Reader getReader(String var1) throws IOException;

    protected abstract Writer getWriter(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<String> readTable(Object name) {
        LinkedHashSet<String> table = new LinkedHashSet<String>();
        try {
            BufferedReader reader = new BufferedReader(this.getReader(META_INF_SISU + name));
            try {
                String line = reader.readLine();
                while (line != null) {
                    table.add(line);
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeTable(Object name, Set<String> table) {
        try {
            BufferedWriter writer = new BufferedWriter(this.getWriter(META_INF_SISU + name));
            try {
                for (String line : table) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                writer.close();
            }
        }
        catch (Throwable e) {
            this.warn(e.toString());
        }
    }
}

