/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.reflect;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.DeferredClass;
import org.sonatype.guice.bean.reflect.NamedClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BundleClassSpace
implements ClassSpace {
    private static final Enumeration<URL> NO_URLS = Collections.enumeration(Collections.emptyList());
    private final Bundle bundle;

    public BundleClassSpace(Bundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Class<?> loadClass(String name) {
        try {
            return this.bundle.loadClass(name);
        }
        catch (Throwable e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    @Override
    public DeferredClass<?> deferLoadClass(String name) {
        return new NamedClass(this, name);
    }

    @Override
    public URL getResource(String name) {
        return this.bundle.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        try {
            return this.bundle.getResources(name);
        }
        catch (IOException e) {
            return NO_URLS;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String glob, boolean recurse) {
        Enumeration<URL> e = this.bundle.findEntries(null != path ? path : "/", glob, recurse);
        return null != e ? e : NO_URLS;
    }

    @Override
    public boolean loadedClass(Class<?> clazz) {
        return this.bundle.equals(FrameworkUtil.getBundle(clazz));
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof BundleClassSpace) {
            return this.bundle.equals(((BundleClassSpace)rhs).bundle);
        }
        return false;
    }

    public String toString() {
        return this.bundle.toString();
    }
}

