#	
# Copyright (C) 2005-2006 Team5	
# All rights reserved.	
#	
# This software is licensed as described in the file COPYING.txt, which	
# you should have received as part of this distribution.	
#	
# Author: Team5
#

from trac.core import *
from trac.env import IEnvironmentSetupParticipant
from trac.perm import IPermissionRequestor
#from codereview.db import version as codereview_version, schema

import db_default

class PeerReviewInit(Component):
    """ Initialise database and environment for codereview plugin """
    implements(IEnvironmentSetupParticipant, IPermissionRequestor)

    # IEnvironmentSetupParticipant
    def environment_created(self):
        self.found_db_version = 0
        self.upgrade_environment(self.env.get_db_cnx())
    
    def environment_needs_upgrade(self, db):
        cursor = db.cursor()
        cursor.execute("SELECT value FROM system WHERE name = 'codereview_version'")
        value = cursor.fetchone()
        if not value:
            self.found_db_version = 0
            return True
        else:
            self.found_db_version = int(value[0])
            return self.found_db_version < db_default.version

    def upgrade_environment(self, db):
        # 0.10 compatibility hack (thanks Alec)
        try:
            from trac.db import DatabaseManager
            db_manager, _ = DatabaseManager(self.env)._get_connector()
        except ImportError:
            db_manager = db

        # Insert the default table
        cursor = db.cursor()
        if not self.found_db_version:
            cursor.execute("INSERT INTO system (name, value) VALUES ('codereview_version', %s)",(db_default.version,))
            cursor.execute("INSERT INTO system VALUES ('CodeReviewVoteThreshold', '0')")
        else:
            cursor.execute("UPDATE system SET value = %s WHERE name = 'codereview_version'",(db_default.version,))
            for tbl in db_default.tables:
                try:
                    cursor.execute('DROP TABLE %s'%tbl.name,)
                except:
                    pass

        for tbl in db_default.tables:
            for sql in db_manager.to_sql(tbl):
                cursor.execute(sql)

    # IPermissionRequestor methods
    def get_permission_actions(self):
         return ['CODE_REVIEW_DEV', 'CODE_REVIEW_MGR']
                                        

