# -*- coding: utf-8 -*-

from pyExcelerator import *

# 標準のpyExceleratorでは作成したExcelデータの保存はファイル出力しかできない。
# httpresponseに直接データを流し込めるようにするためのカスタマイズクラス。

class XlsDoc(CompoundDoc.XlsDoc):
    def getdata(self, stream):
        padding = '\x00' * (0x1000 - (len(stream) % 0x1000))
        self.book_stream_len = len(stream) + len(padding)
        self.__build_directory()
        self.__build_sat()
        self.__build_header()
        return '%s%s%s%s%s%s%s' % (
            self.header,
            self.packed_MSAT_1st,
            stream,
            padding,
            self.packed_MSAT_2nd,
            self.packed_SAT,
            self.dir_stream)

class CustomWorkbook(Workbook):
    def getdata(self):
        doc = XlsDoc()
        return doc.getdata(self.get_biff_data())


