/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.BrowserSessionFactory;
import org.openqa.selenium.server.FrameGroupCommandQueueSet;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserSessionFactoryUnitTest
extends TestCase {
    private static final String SESSION_ID_1 = "testLookupByBrowserAndUrl1";
    private static final String BROWSER_1 = "*firefox";
    private static final String BASEURL1 = "http://www.google.com";
    private static final String SESSION_ID_2 = "testLookupByBrowserAndUrl2";
    private static final String BROWSER2 = "*firefox";
    private static final String BASEURL2 = "http://maps.google.com";

    public void testIsValidWithInvalidSessionInfo() {
        BrowserSessionFactory.BrowserSessionInfo info = new BrowserSessionFactory.BrowserSessionInfo("id1", "*firefox", null, null, null);
        BrowserSessionFactoryUnitTest.assertNotNull((Object)info);
    }

    public void testLookupByBrowserAndUrl() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoByBrowserAndUrl("*firefox", BASEURL1, infos);
        BrowserSessionFactoryUnitTest.assertEquals((String)SESSION_ID_1, (String)result.sessionId);
    }

    public void testLookupByBrowserAndUrlWithNoMatch() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoByBrowserAndUrl("*firefox", "fooey", infos);
        BrowserSessionFactoryUnitTest.assertNull((Object)result);
    }

    public void testLookupBySessionId() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoBySessionId(SESSION_ID_2, infos);
        BrowserSessionFactoryUnitTest.assertEquals((String)BASEURL2, (String)result.baseUrl);
    }

    public void testLookupBySessionIdWithNoMatch() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        Set<BrowserSessionFactory.BrowserSessionInfo> infos = this.getTestSessionSet();
        BrowserSessionFactory.BrowserSessionInfo result = factory.lookupInfoBySessionId("fooey", infos);
        BrowserSessionFactoryUnitTest.assertNull((Object)result);
    }

    public void testRegisterValidExternalSession() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        BrowserSessionFactory.BrowserSessionInfo info1 = this.getTestSession1();
        factory.registerExternalSession(info1);
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(info1.sessionId));
    }

    public void testRegisterInValidExternalSession() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        BrowserSessionFactory.BrowserSessionInfo info = new BrowserSessionFactory.BrowserSessionInfo(SESSION_ID_1, "*firefox", null, null, null);
        factory.registerExternalSession(info);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(info.sessionId));
    }

    public void testGrabAvailableSession() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.addToAvailableSessions(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasAvailableSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactory.BrowserSessionInfo result = factory.grabAvailableSession("*firefox", BASEURL1);
        BrowserSessionFactoryUnitTest.assertEquals((String)SESSION_ID_1, (String)result.sessionId);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(SESSION_ID_1));
    }

    public void testEndSessionWithNoCaching() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.registerExternalSession(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(SESSION_ID_1));
        factory.endBrowserSession(SESSION_ID_1, new RemoteControlConfiguration());
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    public void testEndSessionWithCaching() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.registerExternalSession(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasActiveSession(SESSION_ID_1));
        long closingTime = System.currentTimeMillis();
        RemoteControlConfiguration configuration = new RemoteControlConfiguration();
        configuration.setReuseBrowserSessions(true);
        factory.endBrowserSession(SESSION_ID_1, configuration);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasAvailableSession(SESSION_ID_1));
        BrowserSessionFactory.BrowserSessionInfo info = factory.lookupInfoBySessionId(SESSION_ID_1, factory.availableSessions);
        BrowserSessionFactoryUnitTest.assertTrue((info.lastClosedAt >= closingTime ? 1 : 0) != 0);
    }

    public void testEndAllBrowserSessions() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.registerExternalSession(this.getTestSession1());
        factory.addToAvailableSessions(this.getTestSession2());
        factory.endAllBrowserSessions(new RemoteControlConfiguration());
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasActiveSession(SESSION_ID_1));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_2));
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    public void testRemoveIdleAvailableSessions() {
        BrowserSessionFactory factory = this.getTestSessionFactory();
        factory.addToAvailableSessions(this.getTestSession1());
        BrowserSessionFactoryUnitTest.assertTrue((boolean)factory.hasAvailableSession(SESSION_ID_1));
        factory.removeIdleAvailableSessions();
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    public void testRemoveIdleAvailableSessionsViaCleanup() {
        BrowserSessionFactory factory = new BrowserSessionFactory(null, 5L, 0L, true);
        BrowserSessionFactory.BrowserSessionInfo info1 = this.getTestSession1();
        info1.lastClosedAt = 0L;
        factory.addToAvailableSessions(info1);
        FrameGroupCommandQueueSet.sleepForAtLeast((long)5L);
        BrowserSessionFactoryUnitTest.assertFalse((boolean)factory.hasAvailableSession(SESSION_ID_1));
    }

    private Set<BrowserSessionFactory.BrowserSessionInfo> getTestSessionSet() {
        HashSet<BrowserSessionFactory.BrowserSessionInfo> infos = new HashSet<BrowserSessionFactory.BrowserSessionInfo>();
        BrowserSessionFactory.BrowserSessionInfo info1 = this.getTestSession1();
        infos.add(info1);
        BrowserSessionFactory.BrowserSessionInfo info2 = this.getTestSession2();
        infos.add(info2);
        return infos;
    }

    private BrowserSessionFactory.BrowserSessionInfo getTestSession1() {
        DummyLauncher mockLauncher1 = new DummyLauncher();
        return new BrowserSessionFactory.BrowserSessionInfo(SESSION_ID_1, "*firefox", BASEURL1, (BrowserLauncher)mockLauncher1, null);
    }

    private BrowserSessionFactory.BrowserSessionInfo getTestSession2() {
        DummyLauncher mockLauncher2 = new DummyLauncher();
        return new BrowserSessionFactory.BrowserSessionInfo(SESSION_ID_2, "*firefox", BASEURL2, (BrowserLauncher)mockLauncher2, null);
    }

    private BrowserSessionFactory getTestSessionFactory() {
        return new BrowserSessionFactory(null, 0L, 0L, false);
    }

    private static class DummyLauncher
    implements BrowserLauncher {
        private boolean closed = true;

        public void close() {
            this.closed = true;
        }

        public Process getProcess() {
            return null;
        }

        public void launchHTMLSuite(String startURL, String suiteUrl, boolean multiWindow, String defaultLogLevel) {
            this.closed = false;
        }

        public void launchRemoteSession(String url, boolean multiWindow) {
            this.closed = false;
        }

        protected boolean isClosed() {
            return this.closed;
        }

        protected void setOpen() {
            this.closed = false;
        }

        public void launchRemoteSession(String url, boolean multiWindow, BrowserConfigurationOptions browserConfigurationOptions) {
            this.closed = false;
        }
    }
}

