/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id: eggArc.h 355 2010-09-25 03:19:57Z sirakaba $
*******************************************************************************/

//******************************************************************************
//	Defines
//******************************************************************************

// Result code.
#define SQX_PROGRESS_CANCEL     0
#define SQX_PROGRESS_OK         1
#define SQX_REPLACE_OVERWRITE   0
#define SQX_REPLACE_SKIP        1
#define SQX_REPLACE_CANCEL      2
#define SQX_PASSWORD_CANCEL     0
#define SQX_PASSWORD_OK         1
#define SQX_SKIPFILE_SKIP       1
#define SQX_SKIPFILE_CANCEL     2
#define SQX_NEXTDISK_CANCEL     0
#define SQX_NEXTDISK_OK         1

// Format code.
#define SQX_FILEFORMAT_10       0
#define SQX_FILEFORMAT_20       1

// Dictionary code.
#define SQX_DICTIONARY_0K       0
#define SQX_DICTIONARY_8K       1
#define SQX_DICTIONARY_16K      2
#define SQX_DICTIONARY_32K      3
#define SQX_DICTIONARY_64K      4
#define SQX_DICTIONARY_128K     5
#define SQX_DICTIONARY_256K     6
#define SQX_DICTIONARY_512K     7
#define SQX_DICTIONARY_1M       8
#define SQX_DICTIONARY_2M       9
#define SQX_DICTIONARY_4M       10
#define SQX_DICTIONARY_8M       11
#define SQX_DICTIONARY_16M      12
#define SQX_DICTIONARY_32M      13
#define SQX_DICTIONARY_64M      14
#define SQX_DICTIONARY_128M     15
#define SQX_DICTIONARY_256M     16

// Charset code.
#define SQX_FILENAME_ANSI       0
#define SQX_FILENAME_ASCII      1
#define SQX_FILENAME_UNICODE    2

// Encryption code.
#define SQX_ENCRYPTION_NONE         0
#define SQX_ENCRYPTION_AES_128BIT   2
#define SQX_ENCRYPTION_AES_256BIT   4

// Signature code.
#define SQX_AVENVELOPE_128BIT   0
#define SQX_AVENVELOPE_256BIT   1
#define SQX_AVENVELOPE_512BIT   2

// Level code.
#define SQX_COMPRATE_STORED     0
#define SQX_COMPRATE_FAST       1
#define SQX_COMPRATE_NORMAL     2
#define SQX_COMPRATE_HIGH       3
#define SQX_COMPRATE_MAXIMIUM   4
#define SQX_COMPRATE_ULTRA      5

// Method code.
#define SQX_METHOD_STORED       0
#define SQX_METHOD_NORMAL       1
#define SQX_METHOD_GOOD         2
#define SQX_METHOD_HIGH         3
#define SQX_METHOD_BEST         4
#define SQX_METHOD_AUDIO        5
#define SQX_METHOD_TEXT         6
#define SQX_METHOD_ULTRA        7

// RR code.
#define	SQX_RECOVERYDATA_NONE   0
#define	SQX_RECOVERYDATA_1      1
#define	SQX_RECOVERYDATA_2      2
#define	SQX_RECOVERYDATA_3      3
#define	SQX_RECOVERYDATA_4      4
#define	SQX_RECOVERYDATA_5      5

// Special mode code.
#define SQX_SPECIALCOMP_DISABLED    0
#define SQX_SPECIALCOMP_AUTOMATIC   1
#define SQX_SPECIALCOMP_FORCE       2

// OS code.
#define SQX_HOSTOS_DOSWIN       0
#define SQX_HOSTOS_DOS          1
#define SQX_HOSTOS_OS2          2
#define SQX_HOSTOS_WIN32        3
#define SQX_HOSTOS_WINNT        4
#define SQX_HOSTOS_UNIX         5
#define SQX_HOSTOS_MAC          6
#define SQX_HOSTOS_WINNT_ALPHA  7
#define SQX_HOSTOS_ATARI        8
#define SQX_HOSTOS_VAX_VMS      9
#define SQX_HOSTOS_AMIGA        10
#define SQX_HOSTOS_NEXT         11
#define SQX_HOSTOS_LINUX        12
#define SQX_HOSTOS_CPM          13
#define SQX_HOSTOS_ZSYS         14
#define SQX_HOSTOS_VMCMS        15
#define SQX_HOSTOS_BEOS         16
#define SQX_HOSTOS_UNKNOWN      17
#define SQX_HOSTOS_OS2_HPFS     18
#define SQX_HOSTOS_WIN32_FAT32  19
#define SQX_HOSTOS_WINNT_NTFS   20
#define SQX_HOSTOS_WINNTAXP_NTFS 21
#define SQX_HOSTOS_MVS          22
#define SQX_HOSTOS_VSE          23
#define SQX_HOSTOS_ARCORN_RISC  24
#define SQX_HOSTOS_MVS_ALT      25

// Splitsize code.
#define	SQX_VOLUMESIZE_NONE     0
#define	SQX_VOLUMESIZE_360      1
#define	SQX_VOLUMESIZE_720      2
#define	SQX_VOLUMESIZE_1200     3
#define	SQX_VOLUMESIZE_1400     4
#define	SQX_VOLUMESIZE_2000     5
#define	SQX_VOLUMESIZE_5000     6
#define	SQX_VOLUMESIZE_10000    7
#define	SQX_VOLUMESIZE_30000    8
#define	SQX_VOLUMESIZE_ZIP100   9
#define	SQX_VOLUMESIZE_LS120    10
#define	SQX_VOLUMESIZE_ZIP250   11
#define	SQX_VOLUMESIZE_CDR650   12
#define	SQX_VOLUMESIZE_CDR700   13

// Status code.
#define SQX_CALLBACK_FILENAME           0
#define SQX_CALLBACK_PROGRESS           1
#define SQX_CALLBACK_REPLACE            2
#define SQX_CALLBACK_PASSWORD           3
#define SQX_CALLBACK_PASSWORD_HEADER    4
#define SQX_CALLBACK_SKIP               5
#define SQX_CALLBACK_NEXTDISK           6
#define SQX_CALLBACK_SIGNAL             7

// Signal code.
#define SQX_SIGNAL_COMPRESS             1
#define SQX_SIGNAL_UNCOMPRESS           2
#define SQX_SIGNAL_DELETE               3
#define SQX_SIGNAL_TEMP_ARC_COPY        4
#define SQX_SIGNAL_CREATE_AV_SIG        5
#define SQX_SIGNAL_TEST_AV_SIG          6
#define SQX_SIGNAL_ADD_MV_UNCOMPRESS    7
#define SQX_SIGNAL_CREATE_RDATA         8
#define SQX_SIGNAL_REPAIR_ARCHIVE       9
#define SQX_SIGNAL_STRIP_RDATA          10
#define SQX_SIGNAL_TEST_ARCHIVE         11
#define SQX_SIGNAL_CREATE_SFX_ARCHIVE   12
#define SQX_SIGNAL_ADD_MV_TEST          13
#define SQX_SIGNAL_EX_TEST_ARCHIVE      14
#define SQX_SIGNAL_ADD_MV_EX_TEST       15

// Error code.
#define SQX_ERR_SUCCESS                         0
#define SQX_ERR_ERROR                           1
#define SQX_ERR_FILE_NOT_FOUND                  2
#define SQX_ERR_PATH_NOT_FOUND                  3
#define SQX_ERR_TOO_MANY_FILES                  4
#define SQX_ERR_ACCESS_DENIED                   5
#define SQX_ERR_INVALID_HANDLE                  6
#define SQX_ERR_DISK_FULL                       7
#define SQX_ERR_OUT_OF_MEMORY                   8
#define SQX_ERR_CANT_ACCESS_TEMP_DIR            9
#define SQX_ERR_TEMP_DIR_FULL                   10
#define SQX_ERR_USER_ABORT                      11
#define SQX_ERR_INVALID_ARC_HANDLE              12
#define SQX_ERR_CANT_FIND_LANG_DATA             13
#define SQX_ERR_UNKNOWN_SUBSTREAM               14
#define SQX_ERR_BAD_SUBSTREAM_CRC               15
#define SQX_ERR_UNKNOWN_METHOD                  16
#define SQX_ERR_FILE_ENCRYPTED                  17
#define SQX_ERR_BAD_CRC                         18
#define SQX_ERR_CANT_CREATE_FILE                19
#define SQX_ERR_BAD_FILE_FORMAT                 20
#define SQX_ERR_FUNCTION_NOT_SUPPORTED          21
#define SQX_ERR_FUNC_NOT_SUPPORTED_BY_ARCHIVE   22
#define SQX_ERR_CANT_CREATE_ARC_DIR             23
#define SQX_ERR_INVALID_DIR_NAME                24
#define SQX_ERR_INVALID_FILE_NAME               25
#define SQX_ERR_TOO_MANY_BROKEN_FBLOCKS         26
#define SQX_ERR_ARCHIVE_OK_RDATA_NOT            27
#define SQX_ERR_RDATA_DAMAGED                   28
#define SQX_ERR_RDATA_NEW_VERSION               29
#define SQX_ERR_RDATA_DOES_NOT_MATCH            30
#define SQX_ERR_CANT_FIND_RDATA                 31
#define SQX_ERR_ARCHIVE_IS_LOCKED               32
#define SQX_ERR_CANT_ADD_TO_MV                  33
#define SQX_ERR_CANT_DELETE_FROM_MV             34
#define SQX_ERR_NEED_1ST_VOLUME                 35
#define SQX_ERR_MISSING_VOLUME                  36
#define SQX_ERR_VOLUME_LIMIT_REACHED            37
#define SQX_ERR_SFXSTUB_NOT_INSTALLED           38
#define	SQX_ERR_BACKUP_READ_ACCESS_DENIED       39
#define	SQX_ERR_BACKUP_WRITE_ACCESS_DENIED      40
#define	SQX_ERR_ACL_READ_ACCESS_DENIED          41
#define	SQX_ERR_ACL_WRITE_ACCESS_DENIED         42
#define SQX_ERR_WRONG_ARCHIVER_VERSION          43
#define SQX_ERR_CANT_COPY_SOURCE_TO_SOURCE      44
#define SQX_ERR_VOLUMES_TOO_SMALL               45
#define SQX_ERR_ARCHIVE_VERSION_TOO_HIGH        46
#define SQX_ERR_EXT_RDATA_DOES_NOT_MATCH        47
#define SQX_ERR_BAD_PARAMETER                   48
#define SQX_ERR_EQUAL_PASSWORDS                 49
#define SQX_ERR_REQUIRES_ENCRYPTION             50
#define SQX_ERR_MISSING_HEADER_PASSWORD         51
#define SQX_ERR_MISSING_SQX_PRIVATE_KEY         52
#define SQX_ERR_MISSING_SQX_AVKEY               53
#define SQX_ERR_MISSING_EXTERNAL_AVKEY          54
#define SQX_ERR_INVALID_SQX_AVKEY               55
#define SQX_ERR_SQX_AVKEY_VERSION               56
#define SQX_ERR_SQX_AVDATA_VERSION              57
#define SQX_ERR_SQX_BROKEN_AVRECORD             58
#define SQX_ERR_RIJNDAEL_RSA                    59
#define SQX_ERR_REQUIRES_NTFS                   60
#define SQX_ERR_REQUIRES_WINNT                  61
#define SQX_ERR_REQUIRES_W2K                    62
#define SQX_ERR_REQUIRES_WINXP                  63
#define SQX_ERR_REQUIRES_WINXP_SP1              64
#define SQX_ERR_REQUIRES_WINXP_SP2              65
#define SQX_ERR_REQUIRES_LONGHORN               66
#define SQX_ERR_NO_RESOURCES_FOUND              67
#define SQX_ERR_UNKNOWN_ICON_FORMAT             68
#define SQX_ERR_NO_MATCHING_ICON_SIZE           69
#define SQX_ERR_UNKNOWN_EXE_FORMAT              70
#define SQX_ERR_REQUIRES_SOURCE_PATH            71
#define SQX_ERR_FILE_DATA_NOT_EQUAL             72
#define SQX_ERR_COMMENT_BIGGER_4K               73
#define	SQX_ERR_CANT_CREATE_SFX_FROM_MV         74

//******************************************************************************
//	Structures
//******************************************************************************

#pragma pack(push, 1)

typedef struct tagSQX_FILETIME
{
	BOOL     fBlockPresent;
	FILETIME ftCreationTime;
	FILETIME ftLastAccessTime;
	FILETIME ftLastWriteTime;
} SQX_FILETIME;

typedef struct tagSQX_ARCNODE
{
	const wchar_t * pszFileName;
	DWORD       dwFileNameLen;
	void *      pExtraName;
	DWORD       dwExtraNameLen;
	DWORD       dwFileNameType;
	LONGLONG    dwlSize;
	LONGLONG    dwlSizeOrig;
	DWORD       dwDosFileTime;
	DWORD       dwAttributes;
	DWORD       dwArcerVersion;
	DWORD       dwFileCRC;
	DWORD       dwHostOS;
	DWORD       dwMethod;
	DWORD       dwCommentLen;
	const wchar_t * pszComment;
	BOOL        fEncrypted;
	BOOL        fTagged;
	DWORD       dwMappedMethod;
	DWORD       dwExtendedError;
	SQX_FILETIME win32FileTime;
} SQX_ARCNODE;

typedef struct tagSQX_ARCLISTNODE
{
	tagSQX_ARCLISTNODE * pNext;
	SQX_ARCNODE *        pArcNode;
} SQX_ARCLISTNODE;

typedef struct tagSQX_ARCLIST
{
	DWORD               dwItemCount;
	SQX_ARCLISTNODE *   pHead;
	SQX_ARCLISTNODE *   pTail;
} SQX_ARCLIST;

typedef struct tagSQX_AVINFO
{
	BOOL        fAVInfoPresent;
	wchar_t     szAV_ID[MAX_PATH];
	FILETIME    ftCreationTime;
} SQX_AVINFO;

typedef struct tagSQX_ARCINFO
{
	DWORD       cbSize;
	DWORD       dwFileFormat;
	DWORD       dwArcerMajorVersion;
	DWORD       dwArcerMinorVersion;
	DWORD       dwDictionarySize;
	BOOL        fRecoveryData;
	DWORD       dwEncryption;
	BOOL        fSolid;
	DWORD       dwHostOS;
	DWORD       dwTotalFiles;
	LONGLONG    dwlCompressedSize;
	LONGLONG    dwlUncompressedSize;
	int         iRatio;
	BOOL        fHeaderEncrypted;
	BOOL        fIsMultiVolume;
	BOOL        fArchiveComment;
	BOOL        fFileComments;
	SQX_AVINFO  avInfo;
} SQX_ARCINFO;

typedef struct tagSQX_EXTRACTOPTIONS 
{
	DWORD   cbSize;
	wchar_t szPassword[MAX_PATH];
	wchar_t szPasswordHeader[MAX_PATH];
	wchar_t szTempDir[MAX_PATH];
	wchar_t szRelativePath[MAX_PATH];
	wchar_t szOutputPath[MAX_PATH];
	BOOL    fResetArchiveAttribute;
	BOOL    fOverwriteAlways;
	BOOL    fKeepBrokenFiles;
	BOOL    fCreateFolders;
	BOOL    fRestoreACLs;
	BOOL    fRestoreStreams;
	BOOL    fRestoreUnicodeNames;
	BOOL    fRestoreWin32FileTimes;
	BOOL    fRestoreDirectoryTimeStamps;
	BOOL    fAutoRestoreComments;
	BOOL    fSetZoneID;
} SQX_EXTRACTOPTIONS;

typedef struct tagSQX_FORCECOMP
{
	DWORD   dwCompRate;
	BOOL    fSolidFlag;
	DWORD   dwDictionarySize;
	DWORD   dwExeCompression;
	DWORD   dwTextCompression;
	DWORD   dwTextMemory;
	DWORD   dwTextOrder;
	DWORD   dwMultimediaCompression;
	DWORD   dwMultimediaChannels;
	DWORD   dwAudioCompression;
	DWORD   dwAudioChannels;
	DWORD   dwAudioChannelsWidth;
	DWORD   dwRgbCompression;
	DWORD   dwUltraMatchLink;
} SQX_FORCECOMP;


typedef struct tagSQX_VERSIONINFO
{
	wchar_t szLegalCopyright[40];
	wchar_t szCompanyName[40];
	wchar_t szFileDescription[40];
	wchar_t szFileVersion[40];
	wchar_t szProductName[40];
	wchar_t szProductVersion[40];

} SQX_VERSIONINFO;

typedef struct tagSQX_SFXCOMMAND
{
	BOOL    fCreateSfx;
	DWORD   dwSfxType;
	DWORD   dwSfxSystem;
	wchar_t szSfxHintTitle[256];
	wchar_t szSfxHintMsg[4096];
	DWORD   dwSfxHintBtn;
	wchar_t szSfxInfoAboutMsg[256];
	wchar_t szSfxNormalFolder[MAX_PATH];
	wchar_t szSfxNormalCmd[MAX_PATH];
	BOOL    fSfxNormalOverwriteWOPrompt;
	BOOL    fSfxNormalAutoExtract;
	wchar_t szSfxInstallMsg[256];
	wchar_t szSfxInstallCmd[MAX_PATH];
	wchar_t szSfxInstallWaitFor[MAX_PATH];
	wchar_t szIconFile[MAX_PATH];
	wchar_t szLanguageFile[MAX_PATH];
	SQX_VERSIONINFO versionInfo;
} SQX_SFXCOMMAND;

typedef struct tagSQX_COMPRESSOPTIONS 
{
	DWORD           cbSize;
	DWORD           dwFileFormat;
	SQX_FORCECOMP   compOptions;
	SQX_SFXCOMMAND  sfxCommand;
	DWORD           dwRecoveryData;
	BOOL            fExternalRecoveryData;
	const wchar_t * pszMainComment;
	DWORD           dwEncryption;
	BOOL            fEncryptHeaders;
	BOOL            fAVSignature;
	BOOL            fAVSignatureExternal;
	DWORD           dwAVEnvelope;
	wchar_t         szSignatureFile[MAX_PATH];
	wchar_t         szPassword[MAX_PATH];
	wchar_t         szPasswordHeader[MAX_PATH];
	BOOL            fRetainFolderStructure;
	BOOL            fRetainDrivePart;
	wchar_t         szRelativePath[MAX_PATH];
	wchar_t         szInputPath[MAX_PATH];
	DWORD           dwFileNames;
	BOOL            fStoreWin32FileTime;
	BOOL            fStoreACL;
	BOOL            fStoreStreams;
	BOOL            fAutoSaveComments;
	BOOL            fExtendedTest;
	wchar_t         szTempDir[MAX_PATH];
	DWORDLONG       dwlVolumeSize;
	BOOL            fAutoVolumeSize;
	BOOL            fCreateAlwaysNewArchive;
	BOOL            fResetArchiveAttribute;
	DWORD           dwLogType;

} SQX_COMPRESSOPTIONS;

typedef struct tagSQX_CALLBACKINFO
{
	DWORD               dwCallbackType;
	const wchar_t *     pszSourceFileName;
	const wchar_t *     pszTargetFileName;
	int                 iProgress;
	LPWIN32_FIND_DATA   pFindDataExist;
	LPWIN32_FIND_DATA   pFindDataReplace;
	wchar_t             szCryptKey[MAX_PATH];
	wchar_t             szOldCryptKey[MAX_PATH];
	wchar_t             szCryptFileName[MAX_PATH];
	DWORD               dwTotalSize;
	DWORD               dwDiskNum;
	wchar_t             szNextDiskPath[MAX_PATH];
	DWORD               dwSignal;
	LONGLONG            dwlBlockSize;
} SQX_CALLBACKINFO;

typedef int (CALLBACK* SQXCALLBACK)(void * pParam, SQX_CALLBACKINFO * pCallbackInfo);

#pragma pack(pop)
