/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

//******************************************************************************
//    Defines
//******************************************************************************

#ifndef FNAME_MAX32
#define FNAME_MAX32 512
#endif

// Window Message
#define	WM_ARCEXTRACT           wxT("wm_arcextract")
#define	ARCEXTRACT_BEGIN		0
#define	ARCEXTRACT_INPROCESS	1
#define	ARCEXTRACT_END			2
#define ARCEXTRACT_OPEN			3
#define ARCEXTRACT_COPY			4

// Warning Code
#ifndef ERROR_START
#define ERROR_START				0x8000
#define ERROR_DISK_SPACE		0x8005
#define ERROR_READ_ONLY			0x8006
#define ERROR_USER_SKIP			0x8007
#define ERROR_UNKNOWN_TYPE		0x8008
#define ERROR_METHOD			0x8009
#define ERROR_PASSWORD_FILE		0x800A
#define ERROR_VERSION			0x800B
#define ERROR_FILE_CRC			0x800C
#define ERROR_FILE_OPEN			0x800D
#define ERROR_MORE_FRESH		0x800E
#define ERROR_NOT_EXIST			0x800F
#define ERROR_ALREADY_EXIST		0x8010
#define ERROR_TOO_MANY_FILES	0x8011
// Error Code
#define ERROR_MAKEDIRECTORY		0x8012
#define ERROR_CANNOT_WRITE		0x8013
#define ERROR_HUFFMAN_CODE		0x8014
#define ERROR_COMMENT_HEADER	0x8015
#define ERROR_HEADER_CRC		0x8016
#define ERROR_HEADER_BROKEN		0x8017
#define ERROR_ARC_FILE_OPEN		0x8018
#define ERROR_NOT_ARC_FILE		0x8019
#define ERROR_CANNOT_READ		0x801A
#define ERROR_FILE_STYLE		0x801B
#define ERROR_COMMAND_NAME		0x801C
#define ERROR_MORE_HEAP_MEMORY	0x801D
#define ERROR_ENOUGH_MEMORY		0x801E
#define ERROR_ALREADY_RUNNING	0x801F
#define ERROR_USER_CANCEL		0x8020
#define ERROR_HARC_ISNOT_OPENED	0x8021
#define ERROR_NOT_SEARCH_MODE	0x8022
#define ERROR_NOT_SUPPORT		0x8023
#define ERROR_TIME_STAMP		0x8024
#define ERROR_TMP_OPEN			0x8025
#define ERROR_LONG_FILE_NAME	0x8026
#define ERROR_ARC_READ_ONLY		0x8027
#define ERROR_SAME_NAME_FILE	0x8028
#define ERROR_NOT_FIND_ARC_FILE	0x8029
#define ERROR_RESPONSE_READ		0x802A
#define ERROR_NOT_FILENAME		0x802B
#define ERROR_TMP_COPY			0x802C
#define ERROR_EOF				0x802D
#define ERROR_ADD_TO_LARC		0x802E
#define ERROR_TMP_BACK_SPACE    0x802F
#define ERROR_SHARING			0x8030
#define ERROR_NOT_FIND_FILE		0x8031
#define ERROR_LOG_FILE			0x8032
#define	ERROR_NO_DEVICE			0x8033
#define ERROR_GET_ATTRIBUTES    0x8034
#define ERROR_SET_ATTRIBUTES	0x8035
#define ERROR_GET_INFORMATION   0x8036
#define ERROR_GET_POINT			0x8037
#define ERROR_SET_POINT			0x8038
#define ERROR_CONVERT_TIME		0x8039
#define ERROR_GET_TIME			0x803A
#define ERROR_SET_TIME			0x803B
#define ERROR_CLOSE_FILE		0x803C
#define ERROR_HEAP_MEMORY		0x803D
#define ERROR_HANDLE			0x803E
#define ERROR_TIME_STAMP_RANGE  0x803F
#define ERROR_MAKE_ARCHIVE		0x8040
#define ERROR_NOT_CONFIRM_NAME	0x8041
#define ERROR_UNEXPECTED_EOF	0x8042
#define ERROR_INVALID_END_MARK	0x8043
#define ERROR_INVOLVED_LZH		0x8044
#define ERROR_NO_END_MARK		0x8045
#define ERROR_HDR_INVALID_SIZE	0x8046
#define ERROR_UNKNOWN_LEVEL		0x8047
#define ERROR_BROKEN_DATA		0x8048
#define ERROR_INVALID_PATH		0x8049
#define ERROR_TOO_BIG			0x804A
#define ERROR_EXECUTABLE_FILE	0x804B
#define ERROR_INVALID_VALUE		0x804C
#define ERROR_END				ERROR_INVALID_VALUE
#define ERROR_HDR_EXPLOIT		0x804D
#define ERROR_HDR_NO_CRC		0X804E
#define ERROR_HDR_NO_NAME		0X804F
#endif

#define COMMAND_LIST	1
#define COMMAND_ADD		2
#define COMMAND_FRESH	3
#define COMMAND_DELETE	4
#define COMMAND_EXTRACT	5
#define COMMAND_PRINT	6
#define COMMAND_TEST	7
#define COMMAND_MAKESFX	8
#define COMMAND_JOINT	9
#define COMMAND_CONVERT	10
#define COMMAND_RENAME	11

#pragma pack(1)

typedef struct _tagINDIVIDUALINFO
{
	DWORD dwOriginalSize;
 	DWORD dwCompressedSize;
	DWORD dwCRC;
	unsigned int uFlag;
	unsigned int uOSType;
	WORD wRatio;
	WORD wDate;
	WORD wTime;
	char szFileName[FNAME_MAX32 + 1];
	char dummy1[3];
	char szAttribute[8];
	char szMode[8];
}	INDIVIDUALINFO, * LPINDIVIDUALINFO;

typedef struct _tagINDIVIDUALINFOW
{
	DWORD dwOriginalSize;
 	DWORD dwCompressedSize;
	DWORD dwCRC;
	unsigned int uFlag;
	unsigned int uOSType;
	WORD wRatio;
	WORD wDate;
	WORD wTime;
	wchar_t szFileName[FNAME_MAX32 + 1];
	wchar_t dummy1[3];
	wchar_t szAttribute[8];
	wchar_t szMode[8];
}	INDIVIDUALINFOW, * LPINDIVIDUALINFOW;

typedef struct EXTRACTINGINFO
{
	DWORD dwFileSize;
	DWORD dwWriteSize;
	char szSourceFileName[FNAME_MAX32 + 1];
	char dummy1[3];
	char szDestFileName[FNAME_MAX32 + 1];
	char dummy[3];
}	EXTRACTINGINFO, * LPEXTRACTINGINFO;

typedef struct EXTRACTINGINFOW
{
	DWORD dwFileSize;
	DWORD dwWriteSize;
	wchar_t szSourceFileName[FNAME_MAX32 + 1];
	wchar_t dummy1[3];
	wchar_t szDestFileName[FNAME_MAX32 + 1];
	wchar_t dummy[3];
}	EXTRACTINGINFOW, * LPEXTRACTINGINFOW;

typedef struct EXTRACTINGINFOEX
{
	EXTRACTINGINFO exinfo;
	DWORD dwCompressedSize;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	WORD wDate;
	WORD wTime;
	char szAttribute[8];
	char szMode[8];
}	EXTRACTINGINFOEX, * LPEXTRACTINGINFOEX;

typedef struct EXTRACTINGINFOEXW
{
	EXTRACTINGINFOW exinfo;
	DWORD dwCompressedSize;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	WORD wDate;
	WORD wTime;
	wchar_t szAttribute[8];
	wchar_t szMode[8];
}	EXTRACTINGINFOEXW, * LPEXTRACTINGINFOEXW;

typedef struct EXTRACTINGINFOEX64
{
	DWORD dwStructSize;
	EXTRACTINGINFO exinfo;
	LONGLONG llFileSize;
	LONGLONG llCompressedSize;
	LONGLONG llWriteSize;
	DWORD dwAttributes;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	FILETIME ftCreateTime;
	FILETIME ftAccessTime;
	FILETIME ftWriteTime;
	char szMode[8];
	char szSourceFileName[FNAME_MAX32 + 1];
	char dummy1[3];
	char szDestFileName[FNAME_MAX32 + 1];
	char dummy2[3];
}	EXTRACTINGINFOEX64, * LPEXTRACTINGINFOEX64;

typedef struct EXTRACTINGINFOEX64W
{
	DWORD dwStructSize;
	EXTRACTINGINFOW exinfo;
	LONGLONG llFileSize;
	LONGLONG llCompressedSize;
	LONGLONG llWriteSize;
	DWORD dwAttributes;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	FILETIME ftCreateTime;
	FILETIME ftAccessTime;
	FILETIME ftWriteTime;
	wchar_t szMode[8];
	wchar_t szSourceFileName[FNAME_MAX32 + 1];
	wchar_t dummy1[3];
	wchar_t szDestFileName[FNAME_MAX32 + 1];
	wchar_t dummy2[3];
}	EXTRACTINGINFOEX64W, * LPEXTRACTINGINFOEX64W;

typedef BOOL(CALLBACK * ARCHIVERPROC)(HWND, unsigned int, unsigned int, void *);

typedef struct ENUM_MEMBER_INFO
{
	DWORD dwStructSize;
	unsigned int uCommand;
	DWORD dwOriginalSize;
	DWORD dwCompressedSize;
	DWORD dwAttributes;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	FILETIME ftCreateTime;
	FILETIME ftAccessTime;
	FILETIME ftWriteTime;
	char szFileName[FNAME_MAX32 + 1];
	char dummy1[3];
	char szAddFileName[FNAME_MAX32 + 1];
	char dummy2[3];
}	ENUM_MEMBER_INFO, *LPENUM_MEMBER_INFO;

typedef struct
{
	DWORD dwStructSize;
	unsigned int uCommand;
	DWORD dwOriginalSize;
	DWORD dwCompressedSize;
	DWORD dwAttributes;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	FILETIME ftCreateTime;
	FILETIME ftAccessTime;
	FILETIME ftWriteTime;
	wchar_t szFileName[FNAME_MAX32 + 1];
	wchar_t dummy1[3];
	wchar_t szAddFileName[FNAME_MAX32 + 1];
	wchar_t dummy2[3];
}	ENUM_MEMBER_INFOW, *LPENUM_MEMBER_INFOW;

typedef struct
{
	DWORD dwStructSize;
	unsigned int uCommand;
	LONGLONG llOriginalSize;
	LONGLONG llCompressedSize;
	DWORD dwAttributes;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	FILETIME ftCreateTime;
	FILETIME ftAccessTime;
	FILETIME ftWriteTime;
	char szFileName[FNAME_MAX32 + 1];
	char dummy1[3];
	char szAddFileName[FNAME_MAX32 + 1];
	char dummy2[3];
}	ENUM_MEMBER_INFO64, *LPENUM_MEMBER_INFO64;

typedef struct
{
	DWORD dwStructSize;
	unsigned int uCommand;
	LONGLONG llOriginalSize;
	LONGLONG llCompressedSize;
	DWORD dwAttributes;
	DWORD dwCRC;
	unsigned int uOSType;
	WORD wRatio;
	FILETIME ftCreateTime;
	FILETIME ftAccessTime;
	FILETIME ftWriteTime;
	wchar_t szFileName[FNAME_MAX32 + 1];
	wchar_t dummy1[3];
	wchar_t szAddFileName[FNAME_MAX32 + 1];
	wchar_t dummy2[3];
}	ENUM_MEMBER_INFO64W, *LPENUM_MEMBER_INFO64W;

typedef BOOL(CALLBACK * WND_ENUMMEMBPROC)(void *);

#pragma pack()
