#include "jsp_kernel.h"

#ifdef __GNUC__
#include "cdefBF609.h"       /* gnu tool chain */
#elif defined(__ECC__)
#error "Don't use sys_debugboot.c for VDSP "
#else
#error "Compiler is not supported"
#endif


/*
* gdbserverがターゲットのリセット機能を提供しないため、gdb経由でターゲット
* にアプリッケーションをダウンロードすると正しく動作しないことがある。
* このルーチンはターゲットを一度だけリセットする。
*/
void boot_for_gdb( void )
{
    if ( enable_boot_for_gdb ){   /* ソフトウェアリセットが起きていないなら以下実行 */
        enable_boot_for_gdb = 0;            /* リブートは一回だけ */
        *pREG_RCU0_CTL = BITM_RCU_CTL_SYSRST;
        asm volatile( "ssync;" );
        while( 1 )
            ;                               /*リセットが発生するまでループ*/
    }
}
