/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by TOPPERS/ASP for LPC project
 *              http://sourceforge.jp/projects/toppersasp4lpc/
 * 
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 * 
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 * 
 */
/**
 * \addtogroup TOPPERS_CHIP
 * \{
 */
/**
 * \file chip_config.c
 * \brief カーネル実装のチップ依存モジュール（LPC18xx汎用）
 */
#include "kernel_impl.h"
#include <sil.h>
#include "lpc1800.h"
#include "target_serial.h"
#include "target_syssvc.h"



void chip_initialize(void)
{

	/*
	 *  プロセッサ依存部の初期化
	 */
	core_initialize();

}

extern void initPLL1( unsigned int  Hz  )
{

    LPC_CGU->BASE_M3_CLK = 0x01000800;          // select IRC as cortex-m4 input, auto hold

            // Set PLL1 frequency to 96MHz
    LPC_CGU->PLL1_CTRL =
                        1 << 24 |   // 28:24, clock sel = 1 (IRC)
                       23 << 16 |   // 23:16, MSEL = 23 ( multiply by (MSEL+1) )
                        2 << 12 |   // 13:12, NSEL = 2  ( pre division by (NSEL+1) )
                        1 << 11 |   // 11,    AUTOBLOCK = 1
                        1 << 8  |   // 9:8,   PSEL = 1 ( post division by (PSEL+1))
                        1 << 7  |   // 7,     DIRECT=1 ( 1 : bypass PSEL, 0 : use PSEL )
                        0 << 6  |   // 6,     FBSEL=0  ( 1 : output, 0 : CCO )
                        0 << 1  |   // 1,     BYPASS=0 ( 1 : input, 0 : CCO )
                             0;      // 0,     PD = 0   ( 1 : power down, 0 active );
            // wait for lock
    while ( ! LPC_CGU->PLL1_STAT )
       ;
    LPC_CGU->BASE_M3_CLK = 0x09000800;          // select PLL1, auto hold
        // Set PLL1 frequency to desired
        // PLL reference is 4MHz (12MHz/3). So, the multiplier have to be ( desired freq / 4 )-1
    LPC_CGU->PLL1_CTRL =
                1 << 24 |   // 28:24, clock sel = 1 (IRC)
               (Hz/4000000-1) << 16 |   // 23:16, MSEL = 47 ( multiply by (MSEL+1) )
                2 << 12 |   // 13:12, NSEL = 2  ( pre division by (NSEL+1) )
                1 << 11 |   // 11,    AUTOBLOCK = 1
                1 << 8  |   // 9:8,   PSEL = 1 ( post division by (PSEL+1))
                1 << 7  |   // 7,     DIRECT=1 ( 1 : bypass PSEL, 0 : use PSEL )
                0 << 6  |   // 6,     FBSEL=0  ( 1 : output, 0 : CCO )
                0 << 1  |   // 1,     BYPASS=0 ( 1 : input, 0 : CCO )
                     0;      // 0,     PD = 0   ( 1 : power down, 0 active );
    // wait for lock

}


void chip_exit(void)
{
	/* チップ依存部の終了処理 */
	core_terminate();
}



void chip_fput_log(char_t c)
{
	/*　Newlineなら、CRも追加する */
	if (c == '\n') {
		sio_pol_snd_chr('\r', LOGTASK_PORTID);
	}
	sio_pol_snd_chr(c, LOGTASK_PORTID);
}

//Todo : これが必要かどうか慎重にチェックすること。
/**
 * \brief 低レベルのターゲット依存の初期化
 * \details
 * メモリ初期化の前に呼び出される
 * CCRのSTKALIGNビットをクリアする
 * このビットはCORTEX-M3コアがR1からR2に変化する過程で"1"に変更された。クリアしないと
 * TOPPERS/ASPはクラッシュする。
 */
void hardware_init_hook()
{
	SCB->CCR &= ~SCB_CCR_STKALIGN_Msk;
}

/**
 * \}
 */


