/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: icmp6.h,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet/icmp6.h,v 1.2.2.3 2001/07/06 05:36:35 sumikawa Exp $	*/
/*	$KAME: icmp6.h,v 1.46 2001/04/27 15:09:48 itojun Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright (c) 1982, 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)ip_icmp.h	8.1 (Berkeley) 6/10/93
 */

#ifndef _IP_ICMP6_H_
#define _IP_ICMP6_H_

#ifdef SUPPORT_INET6

/*
 *  ICMPv6 wb_
 */

typedef struct t_icmp6_hdr {
	uint8_t		type;		/* bZ[W̌^	*/
	uint8_t		code;		/* Tu^		*/
	uint16_t	sum;		/* `FbNT		*/
	union {
		uint32_t	data32;
		uint16_t	data16[2];
		uint8_t		data8[4];
	} data;
} T_ICMP6_HDR;

#define icmp6_data32			data.data32
#define icmp6_data16			data.data16
#define icmp6_data8			data.data8
#define icmp6_pptr			data.data32		/* p[^ُ	*/
#define icmp6_mtu			data.data32		/* p[^ُ	*/
#define icmp6_id			data.data16[0]		/* GR[vƉ	*/
#define icmp6_seq			data.data16[1]		/* GR[vƉ	*/

#define ICMP6_HDR_SIZE			(sizeof(T_ICMP6_HDR))
#define IF_IP6_ICMP6_HDR_OFFSET		(IF_IP6_HDR_SIZE)

#define GET_ICMP6_HDR(nbuf,ihoff)	((T_ICMP6_HDR*)((uint8_t*)((nbuf)->buf) + ihoff))
#define GET_ICMP6_SDU(nbuf,ihoff)	((uint8_t*)((nbuf)->buf) + ihoff + ICMP6_HDR_SIZE)

#define GET_IP6_ICMP6_HDR_SIZE(nbuf)	(GET_IP6_HDR_SIZE(GET_IP6_HDR(nbuf)) + ICMP6_HDR_SIZE)
#define GET_IF_IP6_ICMP6_HDR_SIZE(nbuf)	(IF_HDR_SIZE + GET_IP6_ICMP6_HDR_SIZE(nbuf))

/*
 *  ICMP6 ^Cv
 */

#define ICMP6_DST_UNREACH		UINT_C(1)	/* 擞Bs\		*/
#define ICMP6_PACKET_TOO_BIG		UINT_C(2)	/* pPbg傫B	*/
#define ICMP6_TIME_EXCEEDED		UINT_C(3)	/* TTL 𒴉߂B		*/
#define ICMP6_PARAM_PROB		UINT_C(4)	/* IPv6 wb_sB		*/

#define ICMP6_ECHO_REQUEST		UINT_C(128)	/* GR[v			*/
#define ICMP6_ECHO_REPLY		UINT_C(129)	/* GR[			*/

#define ICMP6_MEMBERSHIP_QUERY		UINT_C(130)	/* O[voƉ		*/
#define ICMP6_MEMBERSHIP_REPORT		UINT_C(131)	/* O[vo		*/
#define ICMP6_MEMBERSHIP_REDUCTION	UINT_C(132)	/* O[voI		*/

#define MLD_LISTENER_QUERY		UINT_C(130)	/* }`LXgMҏƉ	*/
#define MLD_LISTENER_REPORT		UINT_C(131)	/* }`LXgMҕ	*/
#define MLD_LISTENER_DONE		UINT_C(132)	/* }`LXgMҏI	*/

#define ND_ROUTER_SOLICIT		UINT_C(133)	/* [^v			*/
#define ND_ROUTER_ADVERT		UINT_C(134)	/* [^ʒm			*/
#define ND_NEIGHBOR_SOLICIT		UINT_C(135)	/* ߗחv			*/
#define ND_NEIGHBOR_ADVERT		UINT_C(136)	/* ߗגʒm			*/
#define ND_REDIRECT			UINT_C(137)	/* 			*/

#define ICMP6_ROUTER_RENUMBERING	UINT_C(138)	/* [^ԍĐݒ		*/

#define ICMP6_WRU_REQUEST		UINT_C(139)	/* vm[hT		*/
#define ICMP6_WRU_REPLY			UINT_C(140)	/* m[hT		*/

#define ICMP6_FQDN_QUERY		UINT_C(139)	/* FQDN Ɖ			*/
#define ICMP6_FQDN_REPLY		UINT_C(140)	/* FQDN 			*/

#define ICMP6_NI_QUERY			UINT_C(139)	/* m[hƉ		*/
#define ICMP6_NI_REPLY			UINT_C(140)	/* m[h񉞓		*/

#define ICMP6_MAX_TYPE			UINT_C(203)	/* ICMP6 ^Cv̍ől		*/

/*
 *  ICMP6 R[h
 */

/* 擞Bs\ */

#define ICMP6_DST_UNREACH_NOROUTE	UINT_C(0)	/* B[gȂB		*/
#define ICMP6_DST_UNREACH_ADMIN		UINT_C(1)	/* Ǘ҂ɂ薳B	*/
#define ICMP6_DST_UNREACH_NOTEIGHBOR	UINT_C(2)	/* ߗ׎҂ł͂ȂȂB	*/
#define ICMP6_DST_UNREACH_BEYOND_SCOPE	UINT_C(2)	/* XR[v𒴂ĂB	*/
#define ICMP6_DST_UNREACH_ADDR		UINT_C(3)	/* AhXɓBs\B	*/
#define ICMP6_DST_UNREACH_NOPORT	UINT_C(4)	/* |[gɓBs\B	*/

/* TTL  */

#define ICMP6_TIME_EXCEED_TRANSIT	UINT_C(0)	/* ] TTL==0 ɂȂB	*/
#define ICMP6_TIME_EXCEED_REASSEMBLY	UINT_C(1)	/* IP č\Ń^CAEgB*/

/* wb_s */

#define ICMP6_PARAMPROB_HEADER		UINT_C(0)	/* wb_ɕsB	*/
#define ICMP6_PARAMPROB_NEXT_HEADER	UINT_C(1)	/* wb_FłȂB	*/
#define ICMP6_PARAMPROB_OPTION		UINT_C(2)	/* IvVFłȂB	*/

/* gp */
#define ND_REDIRECT_ONLINK		UINT_C(0)	/* INւ̌	*/
#define ND_REDIRECT_ROUTER		UINT_C(1)	/* [^ւ̌		*/

/*
 *  l
 */

							/* ICMPv6 ̍őyC[h	*/
#define ICMPV6_PAYLOAD_MAXLEN		(IPV6_MMTU - (IP6_HDR_SIZE + ICMP6_HDR_SIZE))

/*
 *  ߗחv
 */

typedef struct t_neighbor_solicit_hdr {
	T_ICMP6_HDR	hdr;
	T_IN6_ADDR	target;
	/* ̌ɃIvV */
} T_NEIGHBOR_SOLICIT_HDR;

#define NEIGHBOR_SOLICIT_HDR_SIZE	(sizeof(T_NEIGHBOR_SOLICIT_HDR))
#define IF_IP6_NEIGHBOR_SOLICIT_HDR_OFFSET	\
					(IF_IP6_HDR_SIZE)

#define GET_NEIGHBOR_SOLICIT_HDR(nbuf,nhoff)	\
					((T_NEIGHBOR_SOLICIT_HDR*)((uint8_t*)((nbuf)->buf) + nhoff))
#define GET_NEIGHBOR_SOLICIT_SDU(nbuf,nhoff)	\
					((uint8_t*)((nbuf)->buf) + nhoff + NEIGHBOR_SOLICIT_HDR_SIZE)

#define GET_IP6_NEIGHBOR_SOLICIT_HDR_SIZE(nbuf)		\
					(GET_IP6_HDR_SIZE(GET_IP6_HDR(nbuf)) + NEIGHBOR_SOLICIT_HDR_SIZE)
#define GET_IF_IP6_NEIGHBOR_SOLICIT_HDR_SIZE(nbuf)	\
					(GET_IP6_NEIGHBOR_SOLICIT_HDR_SIZE(nbuf) + IF_HDR_SIZE)

/*
 *  ߗגʒm
 */

typedef struct t_neighbor_advert_hdr {
	T_ICMP6_HDR	hdr;
	T_IN6_ADDR	target;
	/* ̌ɃIvV */
} T_NEIGHBOR_ADVERT_HDR;

/* ICMP6 wb_̃f[^̒` */

#define nd_na_flags_reserved		hdr.data.data32

#define NEIGHBOR_ADVERT_HDR_SIZE	(sizeof(T_NEIGHBOR_ADVERT_HDR))
#define IP6_NEIGHBOR_ADVERT_HDR_SIZE	(IP6_HDR_SIZE + NEIGHBOR_ADVERT_HDR_SIZE)
#define IF_IP6_NEIGHBOR_ADVERT_HDR_SIZE	\
					(IF_IP6_HDR_SIZE + NEIGHBOR_ADVERT_HDR_SIZE)
#define IF_IP6_NEIGHBOR_ADVERT_HDR_OFFSET	\
					(IF_IP6_HDR_SIZE)

#define GET_NEIGHBOR_ADVERT_HDR(nbuf,nhoff)	\
					((T_NEIGHBOR_ADVERT_HDR*)((uint8_t*)((nbuf)->buf) + nhoff))
#define GET_NEIGHBOR_ADVERT_SDU(nbuf,nhoff)	\
					((uint8_t*)((nbuf)->buf) + nhoff + NEIGHBOR_ADVERT_HDR_SIZE)

#define GET_IP6_NEIGHBOR_ADVERT_HDR_SIZE(nbuf)		\
					(GET_IP6_HDR_SIZE(GET_IP6_HDR(nbuf)) + NEIGHBOR_ADVERT_HDR_SIZE)
#define GET_IF_IP6_NEIGHBOR_ADVERT_HDR_SIZE(nbuf)	\
					(GET_IP6_NEIGHBOR_ADVERT_HDR_SIZE(nbuf) + IF_HDR_SIZE)

/*
 *  ߗגʒmtOAnd_na_flags_reserved (hdr.data32) ɐݒ肷B
 */

#if SIL_ENDIAN == SIL_ENDIAN_BIG

#define ND_NA_FLG_OVERRIDE		ULONG_C(0x20000000)	/* ߗ׃LbV㏑	*/
#define ND_NA_FLG_SOLICITED		ULONG_C(0x40000000)	/* ߗחvւ̉	*/
#define ND_NA_FLG_ROUTER		ULONG_C(0x80000000)	/* [^ʒm		*/

#elif SIL_ENDIAN == SIL_ENDIAN_LITTLE

#define ND_NA_FLG_OVERRIDE		ULONG_C(0x00000020)	/* ߗ׃LbV㏑	*/
#define ND_NA_FLG_SOLICITED		ULONG_C(0x00000040)	/* ߗחvւ̉	*/
#define ND_NA_FLG_ROUTER		ULONG_C(0x00000080)	/* [^ʒm		*/

#endif	/* #if SIL_ENDIAN == SIL_ENDIAN_BIG */

/*
 *  [^ʒm
 */

typedef struct t_router_advert_hdr {
	T_ICMP6_HDR	hdr;
	uint32_t	reachable;		/* [ms] B\	*/
	uint32_t	retransmit;		/* [ms] ߗחvMԊu	*/
	/* ̌ɃIvV */
} T_ROUTER_ADVERT_HDR;

/* ICMP6 wb_̃f[^̒` */

#define nd_ra_current_hoplimit		hdr.data.data8[0]
#define nd_ra_flags			hdr.data.data8[1]
#define nd_ra_router_lifetime		hdr.data.data16[1]	/* [s] [^L	*/

#define ROUTER_ADVERT_HDR_SIZE		(sizeof(T_ROUTER_ADVERT_HDR))
#define IP6_ROUTER_ADVERT_HDR_SIZE	(IP6_HDR_SIZE + ROUTER_ADVERT_HDR_SIZE)
#define IF_IP6_ROUTER_ADVERT_HDR_SIZE	(IF_IP6_HDR_SIZE + ROUTER_ADVERT_HDR_SIZE)
#define IF_IP6_ROUTER_ADVERT_HDR_OFFSET	(IF_IP6_HDR_SIZE)

#define GET_ROUTER_ADVERT_HDR(nbuf,nhoff)	\
					((T_ROUTER_ADVERT_HDR*)((uint8_t*)((nbuf)->buf) + nhoff))
#define GET_ROUTER_ADVERT_SDU(nbuf,nhoff)	\
					((uint8_t*)((nbuf)->buf) + nhoff + ROUTER_ADVERT_HDR_SIZE)

#define GET_IP6_ROUTER_ADVERT_HDR_SIZE(nbuf)	\
					(GET_IP6_HDR_SIZE(GET_IP6_HDR(nbuf)) + ROUTER_ADVERT_HDR_SIZE)
#define GET_IF_IP6_ROUTER_ADVERT_HDR_SIZE(nbuf)	\
					(GET_IP6_ROUTER_ADVERT_HDR_SIZE(nbuf) + IF_HDR_SIZE)

/*
 *  [^ʒmwb_̃tO
 */

#define ND_RA_FLAG_MANAGED		UINT_C(0x80)
#define ND_RA_FLAG_OTHER		UINT_C(0x40)
#define ND_RA_FLAG_HA			UINT_C(0x20)

/*
 *  [^v
 */

typedef struct t_router_solicit_hdr {
	T_ICMP6_HDR	hdr;
} T_ROUTER_SOLICIT_HDR;

/* ICMP6 wb_̃f[^̒` */

#define nd_rs_reserved			hdr.data.data32

#define ROUTER_SOLICIT_HDR_SIZE		(sizeof(T_ROUTER_SOLICIT_HDR))
#define IP6_ROUTER_SOLICIT_HDR_SIZE	(IP6_HDR_SIZE + ROUTER_SOLICIT_HDR_SIZE)
#define IF_IP6_ROUTER_SOLICIT_HDR_SIZE	(IF_IP6_HDR_SIZE + ROUTER_SOLICIT_HDR_SIZE)
#define IF_IP6_ROUTER_SOLICIT_HDR_OFFSET	\
					(IF_IP6_HDR_SIZE)

#define GET_ROUTER_SOLICIT_HDR(nbuf,nhoff)	\
					((T_ROUTER_SOLICIT_HDR*)((uint8_t*)((nbuf)->buf) + nhoff))
#define GET_ROUTER_SOLICIT_SDU(nbuf,nhoff)	\
					((uint8_t*)((nbuf)->buf) + nhoff + ROUTER_SOLICIT_HDR_SIZE)

#define GET_IP6_ROUTER_SOLICIT_HDR_SIZE(nbuf)		\
					(GET_IP6_HDR_SIZE(GET_IP6_HDR(nbuf)) + ROUTER_SOLICIT_HDR_SIZE)
#define GET_IF_IP6_ROUTER_SOLICIT_HDR_SIZE(nbuf)	\
					(GET_IP6_ROUTER_SOLICIT_HDR_SIZE(nbuf) + IF_HDR_SIZE)

/*
 *  ߗגTIvV
 */

/* ߗגTwb_ */

typedef struct t_neighbor_hdr {
	T_ICMP6_HDR	hdr;
	T_IN6_ADDR	target;
} T_NEIGHBOR_HDR;

/* ߗגTIvVwb_ */

typedef struct t_nd_opt_hdr {
	uint8_t		type;			/* IvV^Cv			*/
	uint8_t		len;			/* IvVAPʂ 8 oCg	*/
} T_ND_OPT_HDR;

#define ND_OPT_HDR_SIZE			(sizeof(T_ND_OPT_HDR))

#define ND_OPT_SOURCE_LINKADDR		UINT_C(1)	/* Mlbg[NC^tF[X̃AhX	*/
#define ND_OPT_TARGET_LINKADDR		UINT_C(2)	/* Ώۃlbg[NC^tF[X̃AhX	*/
#define ND_OPT_PREFIX_INFORMATION	UINT_C(3)	/* vtBbNX				*/
#define ND_OPT_REDIRECTED_HEADER	UINT_C(4)	/* _CNgEwb_				*/
#define ND_OPT_MTU			UINT_C(5)	/* MTU						*/

#define ND_OPT_PREFIX_INFO_COUNT	UINT_C(6)	/* vtBbNX̌			*/
#define ND_OPT_OFF_ARRAY_SIZE		UINT_C(7)	/* ND IvṼItZbgL^zTCY*/

#define ND_OPT_OFF_ARRAY_IX(t)		((t)-1)		/* ItZbgz̃CfbNX			*/

/* vtBbNXIvV */

typedef struct t_nd_opt_prefix_info {
	uint8_t		type;		/* ߗגTIvV^Cv = 3	*/
	uint8_t		len;		/* IvV = 8~4=32	*/
	uint8_t		prefix_len;	/* vtBbNX		*/
	uint8_t		flags;		/* tO			*/
	uint32_t	valid;		/* [s] L			*/
	uint32_t	preferred;	/* [s] L		*/
	uint32_t	reserved;
	T_IN6_ADDR	prefix;		/* vtBbNX		*/
} T_ND_OPT_PREFIX_INFO;

#define ND_OPT_PI_FLAG_ONLINK	UINT_C(0x80)		/* INvtBbNX	*/
#define ND_OPT_PI_FLAG_AUTO	UINT_C(0x40)		/* Xe[gXEAhXݒ*/

/* MTU IvVwb_ */

typedef struct t_nd_opt_mtu_hdr {
	uint8_t		type;		/* IvV^Cv		*/
	uint8_t		len;		/* IvVAPʂ 8 oCg*/
	uint16_t	reserved;
	uint32_t	mtu;		/* MTU				*/
} T_ND_OPT_MTU_HDR;

/*
 *  
 */

typedef struct t_nd_redirect_hdr {
	T_ICMP6_HDR	hdr;
	T_IN6_ADDR	target;		/* [^̃AhX		*/
	T_IN6_ADDR	dst;		/* ̏I_AhX		*/
	/* ̌ɃIvV */
} T_ND_REDIRECT_HDR;

#define ND_REDIRECT_HDR_SIZE		(sizeof(T_ND_REDIRECT_HDR))

#ifdef SUPPORT_MIB

/*
 *  SNMP  Ǘx[X (MIB)
 */

typedef struct t_icmp6_ifstat {
	uint32_t	ipv6IfIcmpInMsgs;
	uint32_t	ipv6IfIcmpInErrors;
	uint32_t	ipv6IfIcmpInDestUnreachs;
/*	uint32_t	ipv6IfIcmpInAdminProhibs;*/
	uint32_t	ipv6IfIcmpInTimeExcds;
	uint32_t	ipv6IfIcmpInParmProblems;
	uint32_t	ipv6IfIcmpInPktTooBigs;
	uint32_t	ipv6IfIcmpInEchos;
	uint32_t	ipv6IfIcmpInEchoReplies;
/*	uint32_t	ipv6IfIcmpInRouterSolicits;*/
	uint32_t	ipv6IfIcmpInRouterAdvertisements;
	uint32_t	ipv6IfIcmpInNeighborSolicits;
	uint32_t	ipv6IfIcmpInNeighborAdvertisements;
	uint32_t	ipv6IfIcmpInRedirects;
/*	uint32_t	ipv6IfIcmpInGroupMembQueries;*/
/*	uint32_t	ipv6IfIcmpInGroupMembResponses;*/
/*	uint32_t	ipv6IfIcmpInGroupMembReductions;*/
	uint32_t	ipv6IfIcmpOutMsgs;
	uint32_t	ipv6IfIcmpOutErrors;
	uint32_t	ipv6IfIcmpOutDestUnreachs;
/*	uint32_t	ipv6IfIcmpOutAdminProhibs;*/
/*	uint32_t	ipv6IfIcmpOutTimeExcds;*/
	uint32_t	ipv6IfIcmpOutParmProblems;
	uint32_t	ipv6IfIcmpOutPktTooBigs;
	uint32_t	ipv6IfIcmpOutEchos;
	uint32_t	ipv6IfIcmpOutEchoReplies;
	uint32_t	ipv6IfIcmpOutRouterSolicits;
/*	uint32_t	ipv6IfIcmpOutRouterAdvertisements;*/
	uint32_t	ipv6IfIcmpOutNeighborSolicits;
	uint32_t	ipv6IfIcmpOutNeighborAdvertisements;
/*	uint32_t	ipv6IfIcmpOutRedirects;*/
/*	uint32_t	ipv6IfIcmpOutGroupMembQueries;*/
/*	uint32_t	ipv6IfIcmpOutGroupMembResponses;*/
/*	uint32_t	ipv6IfIcmpOutGroupMembReductions;*/
} T_ICMP6_IFSTAT;

extern T_ICMP6_IFSTAT icmp6_ifstat;

#endif	/* of #ifdef SUPPORT_MIB */

/*
 *  ֐
 */

extern uint_t icmp6_input (T_NET_BUF **inputp, uint_t *offp, uint_t *nextp);
extern void icmp6_error (T_NET_BUF *input, uint8_t type, uint8_t code, uint32_t param);

#ifdef ICMP_CFG_CALLBACK_ECHO_REPLY

extern void icmp6_echo_reply (T_NET_BUF *input, uint_t ihoff);

#endif	/* of #ifdef ICMP_CFG_CALLBACK_ECHO_REPLY */

#endif	/* of #ifdef SUPPORT_INET6 */

#endif	/* of #ifndef _IP_ICMP6_H_ */
