/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: echo.h,v 1.5 2009/12/24 05:44:56 abe Exp abe $
 */

#ifndef _ECHO_H_
#define _ECHO_H_

/* 
 *  ECHO NCAgET[õX^bNTCY
 */

#define TCP_ECHO_SRV_STACK_SIZE		1024		/* TCP ECHO T[o^XÑX^bNTCY		*/

#ifdef TOPPERS_S810_CLG3_85
#define TCP_ECHO_CLI_RCV_STACK_SIZE	512		/* TCP ECHO NCAgM^XÑX^bNTCY	*/
#define TCP_ECHO_CLI_SND_STACK_SIZE	512		/* TCP ECHO NCAgM^XÑX^bNTCY	*/
#else	/* of #ifdef TOPPERS_S810_CLG3_85 */
#define TCP_ECHO_CLI_RCV_STACK_SIZE	1024		/* TCP ECHO NCAgM^XÑX^bNTCY	*/
#define TCP_ECHO_CLI_SND_STACK_SIZE	1024		/* TCP ECHO NCAgM^XÑX^bNTCY	*/
#endif	/* of #ifdef TOPPERS_S810_CLG3_85 */

#define UDP_ECHO_SRV_STACK_SIZE		1024		/* UDP ECHO T[o^XÑX^bNTCY		*/
#define UDP_ECHO_CLI_STACK_SIZE		1024		/* UDP ECHO NCAg^XÑX^bNTCY	*/

/* 
 *  ECHO NCAgET[o̗Dx
 */

#define TCP_ECHO_SRV_MAIN_PRIORITY	5		/* TCP ECHO T[o^XN̗Dx			*/
#define TCP_ECHO_CLI_RCV_MAIN_PRIORITY	5		/* TCP ECHO NCAgM^XN̗Dx		*/
#define TCP_ECHO_CLI_SND_MAIN_PRIORITY	5		/* TCP ECHO NCAgM^XN̗Dx		*/

#define UDP_ECHO_SRV_MAIN_PRIORITY	5		/* UDP ECHO T[o^XN̗Dx			*/
#define UDP_ECHO_CLI_MAIN_PRIORITY	5		/* UDP ECHO NCAg^XN̗Dx		*/

/*
 *  TCP MEChobt@TCY
 */

#if defined(NUM_MPF_NET_BUF_IF_PDU) && NUM_MPF_NET_BUF_IF_PDU > 0

#define TCP_ECHO_CLI_SWBUF_SIZE		((IF_MTU-(IP_HDR_SIZE+TCP_HDR_SIZE))*1)
#define TCP_ECHO_CLI_RWBUF_SIZE		((IF_MTU-(IP_HDR_SIZE+TCP_HDR_SIZE))*1)

#define TCP_ECHO_SRV_SWBUF_SIZE		((IF_MTU-(IP_HDR_SIZE+TCP_HDR_SIZE))*2)
#define TCP_ECHO_SRV_RWBUF_SIZE		((IF_MTU-(IP_HDR_SIZE+TCP_HDR_SIZE))*2)

#else	/* of #if defined(NUM_MPF_NET_BUF_IF_PDU) && NUM_MPF_NET_BUF_IF_PDU > 0 */

#if defined(SUPPORT_INET4)

#define TCP_ECHO_CLI_SWBUF_SIZE		(TCP_MSS)
#define TCP_ECHO_CLI_RWBUF_SIZE		(TCP_MSS)

#define TCP_ECHO_SRV_SWBUF_SIZE		(TCP_MSS)
#define TCP_ECHO_SRV_RWBUF_SIZE		(TCP_MSS)

#endif	/* of #if defined(SUPPORT_INET4) */

#if defined(SUPPORT_INET6)

#define TCP_ECHO_CLI_SWBUF_SIZE		(TCP6_MSS)
#define TCP_ECHO_CLI_RWBUF_SIZE		(TCP6_MSS)

#define TCP_ECHO_SRV_SWBUF_SIZE		(TCP6_MSS)
#define TCP_ECHO_SRV_RWBUF_SIZE		(TCP6_MSS)

#endif	/* of #if defined(SUPPORT_INET6) */

#endif	/* of #if defined(NUM_MPF_NET_BUF_IF_PDU) && NUM_MPF_NET_BUF_IF_PDU > 0 */

/*
 *  ^XN
 */

#if !(defined(USE_TCP_ECHO_SRV1) && !defined(USE_TCP_NON_BLOCKING) && defined(USE_COPYSAVE_API))

#undef  NUM_TCP_ECHO_SRV_TASKS
#define NUM_TCP_ECHO_SRV_TASKS		1

#endif	/* of #if !(defined(USE_TCP_ECHO_SRV1) && !defined(USE_TCP_NON_BLOCKING) && defined(USE_COPYSAVE_API)) */

/*
 *  ϐ
 */

extern bool_t	tcp_echo_cli_valid;
extern bool_t	udp_echo_cli_valid;

/* TCP Mobt@ */

extern uint8_t tcp_echo_cli_swbuf[];
extern uint8_t tcp_echo_cli_rwbuf[];

#ifdef _TCP_H_

extern uint8_t tcp_echo_srv_swbuf[NUM_TCP_ECHO_SRV_TASKS][TCP_ECHO_SRV_SWBUF_SIZE];
extern uint8_t tcp_echo_srv_rwbuf[NUM_TCP_ECHO_SRV_TASKS][TCP_ECHO_SRV_RWBUF_SIZE];

#endif	/* of #ifdef _TCP_H_ */

/*
 *  ^XN
 */

extern void	tcp_echo_srv_task(intptr_t exinf);
extern void	tcp_echo_srv_rcv_task(intptr_t exinf);
extern void	tcp_echo_srv_snd_task(intptr_t exinf);
extern void	tcp_echo_cli_rcv_task(intptr_t exinf);
extern void	tcp_echo_cli_snd_task(intptr_t exinf);

extern void	udp_echo_srv_task(intptr_t exinf);
extern void	udp_echo_cli_task(intptr_t exinf);

/*
 *  ֐
 */

extern ER callback_nblk_tcp_echo_srv (ID cepid, FN fncd, void *p_parblk);
extern ER callback_nblk_tcp_echo_cli (ID cepid, FN fncd, void *p_parblk);

extern ER callback_udp_echo_srv (ID cepid, FN fncd, void *p_parblk);
extern ER callback_udp_echo_cli (ID cepid, FN fncd, void *p_parblk);

extern ER callback_nblk_udp_echo_srv (ID cepid, FN fncd, void *p_parblk);
extern ER callback_nblk_udp_echo_cli (ID cepid, FN fncd, void *p_parblk);

#endif	/* of #ifndef _ECHO_H_ */
