/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: ppp_lcp.h,v 1.5 2009/12/24 05:42:40 abe Exp abe $
 */

/*
 * lcp.h - Link Control Protocol definitions.
 *
 * Copyright (c) 1989 Carnegie Mellon University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by Carnegie Mellon University.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/pppd/lcp.h,v 1.6.2.1 1999/08/29 15:47:03 peter Exp $
 */

/*
 *	    Written by Toshiharu OHNO (tony-o@iij.ad.jp)
 *
 *   Copyright (C) 1993, Internet Initiative Japan, Inc. All rights reserverd.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the Internet Initiative Japan.  The name of the
 * IIJ may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 * $FreeBSD: src/usr.sbin/ppp/lcp.h,v 1.23.2.1 2000/08/19 09:30:04 brian Exp $
 *
 *	TODO:
 */

#ifndef _PPP_LCP_H_
#define _PPP_LCP_H_

#ifdef SUPPORT_PPP

/*
 *  LCP L PPP N (CP) ̐R[h
 */

#define PPP_PROTREJ		UINT_C(8)	/* Protocol Reject	*/
#define PPP_ECHOREQ		UINT_C(9)	/* Echo Request		*/
#define PPP_ECHOREP		UINT_C(10)	/* Echo Reply		*/
#define PPP_DISCREQ		UINT_C(11)	/* Discard Request	*/

/*
 *  LCP ̍\ (CI)
 */

/*
 *  CI ̌^
 */

#define LCP_CIT_MRU		UINT_C(1)	/* őM (Maximum Receive Unit)	*/
#define LCP_CIT_ACCM		UINT_C(2)	/* Async Control Character Map		*/
#define LCP_CIT_AUTH		UINT_C(3)	/* F؃vgR			*/
#define LCP_CIT_QUALITY		UINT_C(4)	/* ivgR͖			*/
#define LCP_CIT_MAGIC		UINT_C(5)	/* }WbNԍ				*/
#define LCP_CIT_PCOMP		UINT_C(7)	/* vgRk͎\		*/
#define LCP_CIT_ACCOMP		UINT_C(8)	/* AhXE䕔k͎\		*/
#define LCP_CIT_FCS_ALTER	UINT_C(9)	/* FCS-Alternatives ͖		*/
#define LCP_CIT_SELF_PAD	UINT_C(10)	/* Self-Describing-Padding ͖	*/
#define LCP_CIT_CALLBACK	UINT_C(13)	/* Callback ͖			*/
#define LCP_CIT_CFRAMES		UINT_C(15)	/* Compound-Frames ͖		*/

/*
 *  LCP ̍\IvV
 */

typedef struct t_lcp_configs {
	uint32_t	ACCM;		/* ACCM			*/

#ifdef LCP_CFG_MAGIC

	uint32_t	magic;		/* }WbNԍ		*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

	uint16_t	MRU;		/* MRU			*/
	uint16_t	options;	/* IvVtO	*/
} T_LCP_CONFIGS;

/*
 *  ϐ
 */

extern T_PPP_FSM	lcp_fsm;
extern T_PPP_PROTENT	lcp_protent;
extern T_LCP_CONFIGS	lcp_local_ack_cfg;	/* ɋꂽ̎\	*/
extern T_LCP_CONFIGS	lcp_remote_ack_cfg;	/* ɋ\		*/

/*
 *  ֐
 */

extern void lcp_lowerup (void);
extern void lcp_lowerdown (void);
extern void lcp_down (T_PPP_FSM *fsm);
extern void lcp_finished (T_PPP_FSM *fsm);
extern void lcp_open (uint8_t open_mode);
extern void lcp_close (void);
extern void lcp_sprotrej (T_NET_BUF *data);

#endif	/* of #ifdef SUPPORT_PPP */

#endif	/* of #ifndef _PPP_LCP_H_ */
