//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: core_support.cpp 92 2011-08-07 05:57:30Z nagasima $
#include "StdAfx.h"
#include "prc_insn.h"
#include "WinKernel.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// hsqnmJ[l
extern CKernel *g_Kernel;

volatile uint32_t psw;

uint32_t current_psw(void)
{
	return psw;
}

void set_psw(uint32_t psw)
{
	::psw = psw;
}

void disable_int(void)
{
	g_Kernel->LockCPU();
}

void enable_int(void)
{
	g_Kernel->UnlockCPU();
}

bool faultmask;

/*
 *  NMIׂĂ݂̊̋֎~
 */
bool_t TOPPERS_disint(void)
{
	bool val = faultmask;

	if (!val) {
		g_Kernel->LockCPU();
		faultmask = true;
	}

	return val;
}

void TOPPERS_enaint(bool_t locked)
{
	if (!locked) {
		faultmask = false;
		g_Kernel->UnlockCPU();
	}
}

/*
 *  ݃nh̐ݒ
 */
void x_define_inh(uint_t inhno, FP int_entry)
{
	g_Kernel->DefineInterruptHandler(inhno - 8, int_entry);
}

bool starting = true;

/*
 *  ReLXg̎Q
 */
bool_t sense_context(void)
{
	return !g_Kernel->InTaskContext() && !starting;
}

/*
 *  CPUO̔̃ReLXg̎Q
 */
bool_t exc_sense_context(void)
{
	return !g_Kernel->InTaskContext() && !starting;
}

/*
 *  J[lN^XNfBXpb`
 */
void _start_dispatch(void)
{
	starting = false;
}

/*
 *  ^XNfBXpb`
 */
void dispatch(void)
{
	g_Kernel->Dispatch();
}

/*
 *  ݂̃ReLXĝĂăfBXpb`
 */
void exit_and_dispatch(void)
{
	TCB *Task = get_tcb_self(TSK_SELF);
	t_unlock_cpu();
	g_Kernel->ReleaseCPUContext((CCPUContext *)Task->tskctxb.cpu_context);
}

/*
 *  J[l̏Ǐďo
 *
 *  X^bN^XNReLXgpɐ؂ւD
 *  
 */
void call_exit_kernel(void)
{
	g_Kernel->Terminate();
}

/*
 *  ^XNN
 *
 */ 
void start_r(void)
{
	lock_flag = false;
	psw = 0;
}

extern "C" void Throw()
{
	throw 1;
}
