/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: frag6.c,v 1.5 2009/12/24 05:48:16 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet6/frag6.c,v 1.9 2002/04/19 04:46:22 suz Exp $	*/
/*	$KAME: frag6.c,v 1.33 2002/01/07 11:34:48 kjc Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <string.h>

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include "kernel_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>
#include "kernel_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_loop.h>
#include <net/if_ppp.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net.h>
#include <net/net_buf.h>
#include <net/net_var.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet/icmp6.h>

#ifdef SUPPORT_INET6

#ifdef IP6_CFG_FRAGMENT

/*
 *  f[^Oč\L[z
 */

static T_NET_BUF	*ip6_frag_queue[NUM_IP6_FRAG_QUEUE];
static T_IN6_ADDR	 ip6_frag_dest [NUM_IP6_FRAG_QUEUE];

/*
 *  ip6_get_frag_queue -- f[^Oč\L[lB
 */

const T_NET_BUF **
ip6_get_frag_queue (void)
{
	return (const T_NET_BUF **)ip6_frag_queue;
}

/*
 *  frag6_free_queue -- f[^Oč\L[B
 *
 *    : f[^Oč\L[zbNĂĂяoƁB
 */

static void
frag6_free_queue (T_NET_BUF **queue)
{
	T_NET_BUF 	*frag, *next;
	T_QIP6_HDR	*qip6h;

	frag = *queue;
	while (frag != NULL) {
		qip6h = GET_QIP6_HDR(frag);
		next  = qip6h->next_frag;
		syscall(rel_net_buf(frag));
		frag = next;
	}
	*queue = NULL;
}

/*
 *  frag6_timer -- f[^Oč\Ǘ^C}
 */

void
frag6_timer (void)
{
	T_NET_BUF	*frag;
	T_QIP6_HDR	*qip6h;
	T_IP6_FRAG_HDR	*qip6fh;
	int_t		ix;

	syscall(wai_sem(SEM_IP6_FRAG_QUEUE));
	for (ix = NUM_IP6_FRAG_QUEUE; ix -- > 0; ) {
		frag = ip6_frag_queue[ix];
		if (frag != NULL) {
			qip6h = GET_QIP6_HDR(frag);
			if (qip6h->ftim > 0 && -- qip6h->ftim == 0) {

				qip6fh = (T_IP6_FRAG_HDR *)(frag->buf + qip6h->foff);
				if (ntohs(qip6fh->off_flag & IP6F_OFF_MASK) == 0) {

					/*
					 *  擪̒fЂ̃ItZbg 0 ̎̂
					 *  ICMPv6 G[bZ[W𑗐MB
					 */

					/* 擪̒fЂf[^Oč\L[OB*/
					ip6_frag_queue[ix] = qip6h->next_frag;

					/* ĐAhXɖ߂B*/
					GET_IP6_HDR(frag)->dst = ip6_frag_dest[ix];

					/* ICMPv6 G[bZ[W𑗐MB*/
					icmp6_error(frag, ICMP6_TIME_EXCEEDED,
					                  ICMP6_TIME_EXCEED_REASSEMBLY, 0);
				}

				/* f[^Oč\L[B*/
				NET_COUNT_IP6(net_count_ip6[NC_IP6_FRAG_IN_TMOUT], 1);
				NET_COUNT_IP6(net_count_ip6[NC_IP6_FRAG_IN_DROP], 1);
				frag6_free_queue(&ip6_frag_queue[ix]);
			}
		}
	}
	syscall(sig_sem(SEM_IP6_FRAG_QUEUE));
}

#endif	/* #ifdef IP6_CFG_FRAGMENT */

/*
 *  frag6_input -- fЃwb_̓͊֐
 */

uint_t
frag6_input (T_NET_BUF **inputp, uint_t *offp, uint_t *nextp)
{
	T_IP6_HDR	*ip6h;
	T_IP6_FRAG_HDR	*ip6fh;
	T_NET_BUF	*input = *inputp;
	uint_t		off = *offp;

#ifdef IP6_CFG_FRAGMENT

	T_QIP6_HDR	*qip6h, *rip6h;
	T_IP6_FRAG_HDR	*qip6fh = NULL;
	T_NET_BUF	**ip6fq = NULL, *prev, *next, *frag;
	int_t		ix;
	int32_t		unfraglen, diff;
	uint16_t	fragpartlen, qfragpartlen, fragoff, qfragoff, plen;
	uint8_t		ftim, *prev_next;
	uint_t		nextproto = IPPROTO_DONE;

#endif	/* #ifdef IP6_CFG_FRAGMENT */

	/* lbg[Nobt@̎c̒`FbNB*/
	if (input->len - off < sizeof(T_IP6_FRAG_HDR))
		goto buf_rel;

	/* 
	 *  yC[hIvVƒfЃwb_𓯎Ɏgp邱Ƃ
	 *  łȂByC[h 0 ȂAyC[hIvV
	 *  w肳Ă邱ƂɂȂ̂ ICMP ŃG[𑗐M҂
	 *  ʒmB
	 */
	ip6h = GET_IP6_HDR(input);
	if (ip6h->plen == 0) {
		icmp6_error(input, ICMP6_PARAM_PROB,
		                   ICMP6_PARAMPROB_HEADER,
		                   off - IF_HDR_SIZE);
		NET_COUNT_MIB(in6_stats.ipv6IfStatsReasmFails, 1);
		return IPPROTO_DONE;
	}

	/*
	 *  ItZbg 0 ŁAŏItOgł΁A
	 *  sṽf[^OȂ̂ŁA
	 *  wb_wϐ𒲐ďIB
	 */
	ip6fh = (T_IP6_FRAG_HDR *)(input->buf + off);
	if (ip6fh->off_flag == 0) {
		*nextp = *offp - IF_HDR_SIZE + offsetof(T_IP6_FRAG_HDR, next);
		*offp = off + sizeof(T_IP6_FRAG_HDR);
		return ip6fh->next;
	}

#ifdef IP6_CFG_FRAGMENT

	/*
	 *  yC[h`FbNB
	 */
	if ((ip6fh->off_flag & IP6F_MORE_FRAG) && 
	    ((ntohs(ip6h->plen) - (off - IF_HDR_SIZE)) & 0x7) != 0) {
		icmp6_error(input, ICMP6_PARAM_PROB,
		                   ICMP6_PARAMPROB_HEADER,
		                   offsetof(T_IP6_HDR, plen));
		NET_COUNT_MIB(in6_stats.ipv6IfStatsReasmFails, 1);
		return nextproto;
	}
	NET_COUNT_MIB(in6_stats.ipv6IfStatsReasmReqds, 1);

	syscall(wai_sem(SEM_IP6_FRAG_QUEUE));

	/*
 	 *  f[^Oč\L[z񂩂AΉGgTB
 	 */
	for (ix = NUM_IP6_FRAG_QUEUE; ix -- > 0; ) {
		if (ip6_frag_queue[ix] != NULL) {
			qip6h  = GET_QIP6_HDR(ip6_frag_queue[ix]);
			qip6fh = (T_IP6_FRAG_HDR *)(ip6_frag_queue[ix]->buf + qip6h->foff);
			if (ip6fh->ident == qip6fh->ident               &&
			    IN6_ARE_ADDR_EQUAL(&ip6h->src, &qip6h->src) &&
			    IN6_ARE_ADDR_EQUAL(&ip6h->dst, &ip6_frag_dest[ix])) {
				ip6fq = &ip6_frag_queue[ix];
			    	break;
			    	}
		}
	}

 	if (ip6fq == NULL) {

		/*
	 	 *  fЂ̐`FbNB
		 */
		unfraglen = 0;
		fragoff = ntohs(ip6fh->off_flag & IP6F_OFF_MASK);
		if (fragoff == 0) {

			/*
		 	 *  ͂fЂ擪̒f
			 *  łȂ̒ unfraglen vZB
			 */
			unfraglen = (off - IF_HDR_SIZE) - sizeof(T_IP6_HDR);
		}

		/*
		 *             off
		 *  |<--------------------------->|
		 *  |          off - IF_HDR_SIZE  |
		 *  |        |<------------------>|
		 *  |        | off - IF_HDR_SIZE + IP6_FRAG_HDR_SIZE |
		 *  |        |<------------------------------------->|
		 *  +--------+----------+---------+------------------+-------------+
		 *  | IF HDR | IPv6 HDR | EXT HDR |     FRAG HDR     |   Payload   |
		 *  +--------+----------+---------+------------------+-------------+
		 *                      |<---------------------------------------->|
		 *                      |             Payload Size                 |
		 *           |<--------------------------------------------------->|
		 *           |         IP6_HDR_SIZE + Payload Size                 |
		 *                                                   |<----------->|
		 *                                                   | fragpartlen |
		 */
		fragpartlen = sizeof(T_IP6_HDR) + ntohs(ip6h->plen) - (off - IF_HDR_SIZE + sizeof(T_IP6_FRAG_HDR));
		if (unfraglen + fragoff + fragpartlen > IPV6_MAXPACKET) {
			icmp6_error(input, ICMP6_PARAM_PROB,
			                   ICMP6_PARAMPROB_HEADER,
			                   (off - IF_HDR_SIZE) +
			                   offsetof(T_IP6_FRAG_HDR, off_flag));
			goto sig_ret;
		}

		/*
	 	 *  ip6fq == NULL ł΁AΉGĝ͖ŁA
	 	 *  f[^Oč\L[zɁAGgǉB
	 	 */
		for (ix = NUM_IP6_FRAG_QUEUE; ix -- > 0; ) {

			/* 󂫃GgTB*/
			if (ip6_frag_queue[ix] == NULL) {
				ip6fq = &ip6_frag_queue[ix];
				break;
			}
		}

		/*
		 *  ip6fq == NULL ł΁A󂫃GĝŁA
		 *  ^CAEgihlimjZGgJB
		 */
 		if (ip6fq == NULL) {

		 	ftim = IPV6_MAXHLIM;
			for (ix = NUM_IP6_FRAG_QUEUE; ix -- > 0; ) {
				if (ip6_frag_queue[ix] != NULL) {
					rip6h  = GET_QIP6_HDR(ip6_frag_queue[ix]);
					if (rip6h->ftim < ftim) {
						ftim  = rip6h->ftim;
						ip6fq = &ip6_frag_queue[ix];
					}
				}
			}
			frag6_free_queue(ip6fq);
		}

		/*
		 *  Ggݒ肷B
		 */
		*ip6fq = input; 
		ip6_frag_dest[ip6fq - ip6_frag_queue] = ip6h->dst;
		qip6h  = GET_QIP6_HDR(*ip6fq);
		qip6h->ftim = IPV6_FRAGTTL;
		qip6h->foff = off;
		qip6h->flen = fragpartlen;
		qip6h->next_frag = NULL;
 		}
 	else {

		/*
	 	 *  fЂ̐`FbNB
		 */
		unfraglen = 0;
		fragoff = ntohs(((T_IP6_FRAG_HDR *)((*ip6fq)->buf + GET_QIP6_HDR(*ip6fq)->foff))->off_flag & IP6F_OFF_MASK);
		if (fragoff == 0) {

			/*
		 	 *  f[^Oč\L[̍ŏ̒fЂ擪̒f
			 *  łȂ̒ unfraglen vZB
			 */
			unfraglen = (GET_QIP6_HDR(*ip6fq)->foff - IF_HDR_SIZE) - sizeof(T_IP6_HDR);
		}

		fragoff = ntohs(ip6fh->off_flag & IP6F_OFF_MASK);
		if (fragoff == 0) {

			/*
		 	 *  ͂fЂ擪̒f
			 *  łȂ̒ unfraglen vZB
			 */
			unfraglen = (off - IF_HDR_SIZE) - sizeof(T_IP6_HDR);
		}

		/*
		 *             off
		 *  |<--------------------------->|
		 *  |          off - IF_HDR_SIZE  |
		 *  |        |<------------------>|
		 *  |        | off - IF_HDR_SIZE + IP6_FRAG_HDR_SIZE |
		 *  |        |<------------------------------------->|
		 *  +--------+----------+---------+------------------+-------------+
		 *  | IF HDR | IPv6 HDR | EXT HDR |     FRAG HDR     |   Payload   |
		 *  +--------+----------+---------+------------------+-------------+
		 *                      |<---------------------------------------->|
		 *                      |             Payload Size                 |
		 *           |<--------------------------------------------------->|
		 *           |         IP6_HDR_SIZE + Payload Size                 |
		 *                                                   |<----------->|
		 *                                                   | fragpartlen |
		 */
		fragpartlen = sizeof(T_IP6_HDR) + ntohs(ip6h->plen) - (off - IF_HDR_SIZE + sizeof(T_IP6_FRAG_HDR));
		if (unfraglen + fragoff + fragpartlen > IPV6_MAXPACKET) {
			icmp6_error(input, ICMP6_PARAM_PROB,
			                   ICMP6_PARAMPROB_HEADER,
			                   (off - IF_HDR_SIZE) +
			                   offsetof(T_IP6_FRAG_HDR, off_flag));
			goto sig_ret;
		}
		
		if (ntohs(ip6fh->off_flag & IP6F_OFF_MASK) == 0) {

			/*
		 	 *  ͂fЂ擪̒f
		 	 *  f[^Oč\L[̍Ō̒fЂA
		 	 *  f[^O̍ő咷𒴂ĂȂ`FbNB
			 */

			/* Ō̒fЂTB*/
			next = *ip6fq;
			while ((qip6h = GET_QIP6_HDR(next))->next_frag != NULL)
				next = qip6h->next_frag;

			/* Ō̒fЂ̃ItZbgƒfЃTCYvZB*/
			qip6fh = (T_IP6_FRAG_HDR *)(next->buf + qip6h->foff);
			fragoff = ntohs(qip6fh->off_flag & IP6F_OFF_MASK);
			fragpartlen = sizeof(T_IP6_HDR) + ntohs(qip6h->plen) - (qip6h->foff - IF_HDR_SIZE + sizeof(T_IP6_FRAG_HDR));
			if (unfraglen + fragoff + fragpartlen > IPV6_MAXPACKET) {

				/*
				 *  f[^O̍ő咷𒴂Ăꍇ́A
			 	 *  f[^Oč\L[ŜjB
			 	 */
				frag6_free_queue(ip6fq);
				syscall(rel_net_buf(input));
				goto sig_ret;
			}
		}

		/* ECN ̐`FbN͖ */

		/*
		 *  fЂGgɑ}B
	 	 *  f[^Oč\L[A͂fЂO̒fЂTB
		 */
		prev = NULL;
		next = *ip6fq;
		while (next != NULL) {
			qip6h  = GET_QIP6_HDR(next);
			qip6fh = (T_IP6_FRAG_HDR *)(next->buf + qip6h->foff);
			if (ntohs(ip6fh->off_flag & IP6F_OFF_MASK) <= ntohs(qip6fh->off_flag & IP6F_OFF_MASK))
				break;
			prev = next;
			next = qip6h->next_frag;
		}

		/*
		 *  prev ́A͂fЂO̒fЁB NULL ̏ꍇ́A
		 *  ͂fЂf[^Oč\L[̒ōłO̒fЁB
		 *  next ́A͂fЂ̒fЁB NULL ̏ꍇ́A
		 *  ͂fЂf[^Oč\L[̒ōł̒fЁB
		 */
		fragoff = ntohs(ip6fh->off_flag & IP6F_OFF_MASK);
		if (prev != NULL) {

			/*
			 *  O̒fЂƁA͂fЂdȂĂȂ`FbNB
			 *
			 *    qfragoff
			 *    |   qfragparglen
			 *    |<------------------>|
			 *    +--------------------+
			 *    |        prev        |
			 *    +--------------------+
			 *
			 *                         +--------------------+
			 *                         |        input       |
			 *                         +--------------------+
			 *                         |
			 *                         fragoff
			 */
			qip6h  = GET_QIP6_HDR(prev);
			qip6fh = (T_IP6_FRAG_HDR *)(prev->buf + qip6h->foff);
			qfragoff = ntohs(qip6fh->off_flag & IP6F_OFF_MASK);
			qfragpartlen = sizeof(T_IP6_HDR) + ntohs(qip6h->plen) - (off - IF_HDR_SIZE + sizeof(T_IP6_FRAG_HDR));

			diff = ((int32_t)qfragoff + qfragpartlen) - fragoff;
			if (diff > 0) {

				/* dȂĂ΁A͂fЂjďIB*/
				syscall(rel_net_buf(input));
				goto sig_ret;
			}
		}

		if (next != NULL) {

			/*
			 *  ̒fЂƁA͂fЂdȂĂȂ`FbNB
			 *
			 *    fragoff
			 *    |    fragparglen
			 *    |<------------------>|
			 *    +--------------------+
			 *    |       input        |
			 *    +--------------------+
			 *
			 *                         +--------------------+
			 *                         |         next       |
			 *                         +--------------------+
			 *                         |
			 *                         qfragoff
			 */
			qip6h  = GET_QIP6_HDR(next);
			qip6fh = (T_IP6_FRAG_HDR *)(next->buf + qip6h->foff);
			qfragoff = ntohs(qip6fh->off_flag & IP6F_OFF_MASK);
			fragpartlen = sizeof(T_IP6_HDR) + ntohs(ip6h->plen) - (off - IF_HDR_SIZE + sizeof(T_IP6_FRAG_HDR));

			diff = ((int32_t)fragoff + fragpartlen) - qfragoff;
			if (diff > 0) {

				/* dȂĂ΁A͂fЂjďIB*/
				syscall(rel_net_buf(input));
				goto sig_ret;
			}
		}

		/* ͂fЂݒ肷B*/
		qip6h  = GET_QIP6_HDR(input);
		qip6h->foff = off;
		qip6h->flen = sizeof(T_IP6_HDR) + ntohs(qip6h->plen) - (off - IF_HDR_SIZE + sizeof(T_IP6_FRAG_HDR));

		if (prev == NULL) {
			*ip6fq = input;
			qip6h->ftim = IPV6_FRAGTTL;
		}
		else
			GET_QIP6_HDR(prev)->next_frag = input;
		qip6h->next_frag = next;

		/*
		 *  SĂ̒fЂM`FbNB
		 */
		plen = 0;
		frag = *ip6fq;
		while (frag != NULL) {
			qip6h  = GET_QIP6_HDR(frag);
			qip6fh = (T_IP6_FRAG_HDR *)(frag->buf + qip6h->foff);
			if (ntohs(qip6fh->off_flag & IP6F_OFF_MASK) != plen) {

				/* fЂAĂȂB*/
				goto sig_ret;
			}
			plen += qip6h->flen;
			frag = qip6h->next_frag;
		}
		if (ntohs(qip6fh->off_flag & IP6F_MORE_FRAG) != 0) {

			/* Ō̒fЂMĂȂB*/
			goto sig_ret;
		}

		/*
		 *  SĂ̒fЂM̂ŁAč\B
		 */

		/* lbg[Nobt@lB*/
		qip6h  = GET_QIP6_HDR(*ip6fq);
		qip6fh = (T_IP6_FRAG_HDR *)((*ip6fq)->buf + qip6h->foff);
		if (tget_net_buf(inputp, qip6h->foff + plen, TMO_IP6_FRAG_GET_NET_BUF) == E_OK) {

			/*
			 *  fЃwb_̒Õwb_ NEXT tB[h̃AhXlA
			 *  ɖ߂B
			 */
			if ((prev_next = ip6_get_prev_hdr(*ip6fq, qip6h->foff)) == NULL) {
				syscall(rel_net_buf(input));
				goto sig_ret;
			}
			*prev_next = qip6fh->next;
			input = *inputp;

			NET_COUNT_IP6(net_count_ip6[NC_IP6_FRAG_IN_OK], 1);
			NET_COUNT_MIB(in6_stats.ipv6IfStatsReasmOKs, 1);

			/*
			 *  IPv6 wb_ƕłȂ
			 *  f[^Oč\L[̒̐擪̒fЂRs[B
			 */
			memcpy(input->buf, (*ip6fq)->buf, qip6h->foff);

			/* MAhXɖ߂B*/
			ip6h = GET_IP6_HDR(input);
			ip6h->dst = ip6_frag_dest[ip6fq - ip6_frag_queue];

			/* offp Ač\fЂ̐擪ɐݒ肷B*/
			*offp = qip6h->foff;

			/* lbg[Nobt@ݒ肷B*/
			input->len = plen + qip6h->foff;

			/*
			 *  SĂ̒fЂRs[B
			 */
			frag = *ip6fq;
			off  = qip6h->foff;
			while (frag != NULL) {
				qip6h  = GET_QIP6_HDR(frag);
				memcpy(input->buf + off,
				       frag->buf + qip6h->foff + sizeof(T_IP6_FRAG_HDR),
				       qip6h->flen);
				off += qip6h->flen;
				frag = qip6h->next_frag;
			}

			/* yC[hݒ肷B*/
			ip6h->plen = htons(plen);

			*nextp = offsetof(T_IP6_HDR, next);
			nextproto = ip6h->next;
		}
		else {
			NET_COUNT_IP6(net_count_ip6[NC_IP6_FRAG_IN_NO_BUF], 1);
			NET_COUNT_IP6(net_count_ip6[NC_IP6_FRAG_IN_DROP], 1);
			NET_COUNT_MIB(in6_stats.ipv6IfStatsReasmFails, 1);
		}

		/* f[^Oč\L[B*/
		frag6_free_queue(ip6fq);
 		}

sig_ret:
	syscall(sig_sem(SEM_IP6_FRAG_QUEUE));
	return nextproto;

#else	/* #ifdef IP6_CFG_FRAGMENT */

	/*
	 *  f[^O̕Eč\sȂꍇ́ASfЂjA
	 *  Ō̒fЂMƂA
	 *  ICMP G[𑗐M҂ɒʒmB
	 */
	if ((ip6fh->off_flag & IP6F_MORE_FRAG) == 0) {
		icmp6_error(input, ICMP6_TIME_EXCEEDED,
		                   ICMP6_TIME_EXCEED_REASSEMBLY, 0);
		NET_COUNT_MIB(in6_stats.ipv6IfStatsReasmFails, 1);
		return IPPROTO_DONE;
	}

#endif	/* #ifdef IP6_CFG_FRAGMENT */

buf_rel:
	syscall(rel_net_buf(input));
	return IPPROTO_DONE;
}

#endif /* of #ifdef SUPPORT_INET6 */
