/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: in.h,v 1.5 2009/12/24 05:47:21 abe Exp abe $
 */

/*
 * Copyright (c) 1982, 1986, 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)in.h	8.3 (Berkeley) 1/3/94
 * $FreeBSD: src/sys/netinet/in.h,v 1.38.2.3 1999/08/29 16:29:34 peter Exp $
 */
 
#ifndef _IN_H_
#define _IN_H_

#include <tinet_kernel_defs.h>

#include <netinet6/in6.h>

/*
 *  TINET ̃o[W
 */

#define TINET_PRVER		UINT_C(0x1052)	/* TINET ̃o[Wԍ */

/*
 *  C^[lbgVXe̒`ARFC790 Q
 */

/*
 *  vgR (RFC1700)
 */

#define IPPROTO_IP		UINT_C(0)	/* IP ̃_~[				*/
#define IPPROTO_HOPOPTS		UINT_C(0)	/* IPv6 p_ (Hop-by-Hop) IvV	*/
#define IPPROTO_ICMP		UINT_C(1)	/* ICMP					*/
#define IPPROTO_TCP		UINT_C(6)	/* TCP					*/
#define IPPROTO_UDP		UINT_C(17)	/* UDP					*/
#define IPPROTO_IPV6		UINT_C(41)	/* IPv6					*/
#define IPPROTO_ROUTING		UINT_C(43)	/* oHIvV			*/
#define IPPROTO_FRAGMENT	UINT_C(44)	/* fЉIvV			*/
#define IPPROTO_RSVP		UINT_C(46)	/* RSVP					*/
#define IPPROTO_ESP		UINT_C(50)	/* IPv6 ÍIvV		*/
#define IPPROTO_AH		UINT_C(51)	/* IPv6 F؃IvV			*/
#define IPPROTO_ICMPV6		UINT_C(58)	/* ICMPv6				*/
#define IPPROTO_NONE		UINT_C(59)	/* IPv6 wb_			*/
#define IPPROTO_DSTOPTS		UINT_C(60)	/* IPv6 I_IvV			*/
#define IPPROTO_IPCOMP		UINT_C(108)	/* yC[hk			*/
#define IPPROTO_DONE		UINT_C(257)	/* IPv6 ŏʃvgR͏I	*/

/*
 *  IPv4 AhX
 */

/* OQ */

#ifndef T_IN4_ADDR_DEFINED

typedef uint32_t T_IN4_ADDR;

#define T_IN4_ADDR_DEFINED

#endif	/* of #ifndef T_IN4_ADDR_DEFINED */

/*
 *  ITRON TCP/IPv4 AhX/|[gԍ̒`
 */

typedef struct t_ipv4ep {
	uint32_t	ipaddr;		/* IPv4 AhX	*/
	uint16_t	portno;		/* |[gԍ		*/
} T_IPV4EP;

/*
 *  AhX/|[g̒
 */

#define IPV4_ADDR_LEN		4
#define PORT_NUM_LEN		2

/*
 *  |[gԍ̒`
 */

#define TCP_PORTANY			UINT_C(0x0000)	/* ITRON TCP/IP W	*/
#define UDP_PORTANY			UINT_C(0x0000)	/* ITRON TCP/IP W	*/

#define TCP_PORT_LAST_WELL_KNOWN	UINT_C(1023)	/* Well Known Iԍ	*/
#define TCP_PORT_FIRST_AUTO		UINT_C(1024)	/* 蓖ĊJnԍ	*/
#define TCP_PORT_LAST_AUTO		UINT_C(4999)	/* 蓖ďIԍ	*/

#define UDP_PORT_LAST_WELL_KNOWN	UINT_C(1023)	/* Well Known Iԍ	*/
#define UDP_PORT_FIRST_AUTO		UINT_C(1024)	/* 蓖ĊJnԍ	*/
#define UDP_PORT_LAST_AUTO		UINT_C(4999)	/* 蓖ďIԍ	*/

/*
 *  IP AhX̒`
 */

#define IPV4_ADDRANY		ULONG_C(0x00000000)	/* ITRON TCP/IP W	*/

#define IPV4_ADDR_LOOPBACK	ULONG_C(0x7f000001)
#define IPV4_ADDR_LOOPBACK_MASK	IPV4_CLASS_A_MASK
#define IPV4_ADDR_BROADCAST	ULONG_C(0xffffffff)

#define IPV4_CLASS_A(i)		(((i) & ULONG_C(0x80000000)) == 0)
#define IPV4_CLASS_A_NET	ULONG_C(0xff000000)
#define IPV4_CLASS_A_MASK	ULONG_C(0xff000000)
#define IPV4_CLASS_A_HOST	ULONG_C(0x00ffffff)

#define IPV4_CLASS_B(i)		(((i) & ULONG_C(0xc0000000)) == ULONG_C(0x80000000))
#define IPV4_CLASS_B_NET	ULONG_C(0xffff0000)
#define IPV4_CLASS_B_MASK	ULONG_C(0xffff0000)
#define IPV4_CLASS_B_HOST	ULONG_C(0x0000ffff)

#define IPV4_CLASS_C(i)		(((i) & ULONG_C(0xe0000000)) == ULONG_C(0xc0000000))
#define IPV4_CLASS_C_NET	ULONG_C(0xffffff00)
#define IPV4_CLASS_C_MASK	ULONG_C(0xffffff00)
#define IPV4_CLASS_C_HOST	ULONG_C(0x000000ff)

#define IPV4_CLASS_D(i)		(((i) & ULONG_C(0xf0000000)) == ULONG_C(0xe0000000))

#define IN4_IS_ADDR_MULTICAST(i)	IPV4_CLASS_D(i)

#define MAKE_IPV4_LOCAL_BROADCAST(i)	(IPV4_CLASS_A(i)?((i)|IPV4_CLASS_A_HOST):\
					 IPV4_CLASS_B(i)?((i)|IPV4_CLASS_B_HOST):\
					 IPV4_CLASS_C(i)?((i)|IPV4_CLASS_C_HOST):\
					 IPV4_ADDR_BROADCAST)

#define MAKE_IPV4_LOCAL_MASK(i)		(IPV4_CLASS_A(i)?IPV4_CLASS_A_MASK:\
					 IPV4_CLASS_B(i)?IPV4_CLASS_B_MASK:\
					 IPV4_CLASS_C(i)?IPV4_CLASS_C_MASK:\
					 IPV4_ADDRANY)

#define MAKE_IPV4_ADDR(a,b,c,d)		((T_IN4_ADDR)(((uint32_t)(a)<<24)|((uint32_t)(b)<<16)|((uint32_t)(c)<<8)|(d)))

/*
 *  Ip TCP ʐM[_
 */

typedef struct t_tcp_ccep {
	/* W */
	ATR		cepatr;		/* ʐM[_			*/
	void		*sbuf;		/* MpEBhobt@	*/
	int_t		sbufsz;		/* MpEBhobt@TCY	*/
	void		*rbuf;		/* MpEBhobt@	*/
	int_t		rbufsz;		/* MpEBhobt@TCY	*/
	FP		callback;	/* R[obN			*/
	/* ˑ */
} T_TCP_CCEP;

/*
 *  Ip TCP t
 */

#if defined(SUPPORT_INET4)

typedef struct t_tcp_crep {
	/* W */
	ATR		repatr;		/* t		*/
	T_IPV4EP	myaddr;		/* ̃AhX	*/
	/* ˑ */
} T_TCP_CREP;

#endif	/* of #if defined(SUPPORT_INET4) */

/*
 *  Ip UDP ʐM[_
 */

#if defined(SUPPORT_INET4)

typedef struct t_udp_ccep {
	/* W */
	ATR		cepatr;		/* UDP ʐM[_		*/
	T_IPV4EP	myaddr;		/* ̃AhX		*/
	FP		callback;	/* R[obN֐		*/
	/* ˑ */
} T_UDP_CCEP;

#endif	/* of #if defined(SUPPORT_INET4) */

/*
 *  IPv4  IPv6 RpCɑI邽߂̃}N
 */

#if defined(SUPPORT_INET4)

#define T_IN_ADDR			T_IN4_ADDR
#define T_IPEP				T_IPV4EP
#define IP_ADDRANY			IPV4_ADDRANY

#define IN_ARE_ADDR_EQUAL(n,h)		(*(n)==*(h))
#define IN_ARE_NET_ADDR_EQUAL(n,h)	(ntohl(*(n))==*(h))
#define IN_COPY_TO_NET(d,s)		(*(d)=htonl(*(s)))
#define IN_COPY_TO_HOST(d,s)		(*(d)=ntohl(*(s)))
#define IN_IS_ADDR_MULTICAST(a)		IN4_IS_ADDR_MULTICAST(*(a))
#define IN_IS_NET_ADDR_MULTICAST(a)	IN4_IS_ADDR_MULTICAST(ntohl(*(a)))
#define IN_IS_ADDR_ANY(a)		(*(a)==IPV4_ADDRANY)

#endif	/* of #if defined(SUPPORT_INET4) */

/*
 *  TINET Ǝ API
 */

extern const char *in_strtfn (FN fncd);

#if defined(SUPPORT_INET4)

extern ER in4_add_ifaddr (T_IN4_ADDR addr, T_IN4_ADDR mask);
extern ER in4_add_route (int_t index, T_IN4_ADDR target,
                                      T_IN4_ADDR mask, T_IN4_ADDR gateway);
extern char *ip2str (char *buf, const T_IN4_ADDR *p_ipaddr);
extern const T_IN4_ADDR *in4_get_ifaddr (int_t index);

#endif	/* of #if defined(SUPPORT_INET4) */

#endif	/* of #ifndef _IN_H_ */
