/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  $Id: time_event.c 60 2010-09-27 10:50:44Z nagasima $
 */

/*
 *		^CCxgǗW[
 */

#include "kernel_impl.h"
#include "check.h"
#include "time_event.h"

/*
 *  ^CCxgq[v}N
 */
#define	PARENT(index)		((index) >> 1)		/* em[h߂ */
#define	LCHILD(index)		((index) << 1)		/* ̎qm[h߂ */
#define	TMEVT_NODE(index)	(tmevt_heap[(index) - 1])

/*
 *  Cxgr}N
 *
 *  CxǵCmin_timȇΒlŔrDȂ킿C
 *  min_timeŏlił߂jCmit_time-1őliłj
 *  Ƃ݂ȂĔrD
 */
#define	EVTTIM_LT(t1, t2) (((t1) - min_time) < ((t2) - min_time))
#define	EVTTIM_LE(t1, t2) (((t1) - min_time) <= ((t2) - min_time))

#ifdef TOPPERS_tmeini

/*
 *  ݂̃VXeiP: 1~bj
 *
 *  ɂ́CÕ^CeBbÑVXeD
 */
EVTTIM	current_time;

/*
 *  ^CCxgq[vŗLȍŏ̃VXeiP: 1~bj
 */
EVTTIM	min_time;

/*
 *  ̃^CeBbÑVXeiP: 1~bj
 */
EVTTIM	next_time;

/*
 *  VXeώZpϐiP: 1/TIC_DENO~bj
 */
#if TIC_DENO != 1U
uint_t	next_subtime;
#endif /* TIC_DENO != 1U */

/*
 *  ^CCxgq[v̍Ō̎gp̈̃CfbNX
 */
uint_t	last_index;

/*
 *  ^C}W[̏
 */
void
initialize_tmevt(void)
{
	current_time = min_time = 0U;
	next_time = current_time + TIC_NUME / TIC_DENO;
#if TIC_DENO != 1U
	next_subtime = TIC_NUME % TIC_DENO;
#endif /* TIC_DENO != 1U */
	last_index = 0U;
}

#endif /* TOPPERS_tmeini */

/*
 *  ^CCxg̑}ʒuɒT
 *
 *  timeɔ^CCxg}m[h󂯂邽߂ɁC
 *  q[v̏Ɍċm[hړDړŐm[ḧʒu
 *  indexɓnƁCړ̋m[ḧʒuiȂ킿}ʒujԂD
 */
#ifdef TOPPERS_tmeup

uint_t
tmevt_up(uint_t index, EVTTIM time)
{
	uint_t	parent;

	while (index > 1) {
		/*
		 *  em[h̃Cxg̕i܂͓jȂ΁C
		 *  index}ʒuȂ̂Ń[v𔲂D
		 */
		parent = PARENT(index);
		if (EVTTIM_LE(TMEVT_NODE(parent).time, time)) {
			break;
		}

		/*
		 *  em[hindeẍʒuɈړD
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).p_tmevtb->index = index;

		/*
		 *  indexem[ḧʒuɍXVD
		 */
		index = parent;
	}
	return(index);
}

#endif /* TOPPERS_tmeup */

/*
 *  ^CCxg̑}ʒuɒT
 *
 *  timeɔ^CCxg}m[h󂯂邽߂ɁC
 *  q[v̉Ɍċm[hړDړŐm[ḧʒu 
 *  indexɓnƁCړ̋m[ḧʒuiȂ킿}ʒujԂD
 */
#ifdef TOPPERS_tmedown

uint_t
tmevt_down(uint_t index, EVTTIM time)
{
	uint_t	child;

	while ((child = LCHILD(index)) <= last_index) {
		/*
		 *  E̎qm[h̃CxgrC̎qm[h
		 *  ̈ʒuchildɐݒ肷Dȉ̎qm[h́CőI΂ꂽ
		 *  ̎qm[ĥƁD
		 */
		if (child + 1 <= last_index
						&& EVTTIM_LT(TMEVT_NODE(child + 1).time,
										TMEVT_NODE(child).time)) {
			child = child + 1;
		}

		/*
		 *  qm[h̃Cxg̕xi܂͓jȂ΁C
		 *  index}ʒuȂ̂Ń[v𔲂D
		 */
		if (EVTTIM_LE(time, TMEVT_NODE(child).time)) {
			break;
		}

		/*
		 *  qm[hindeẍʒuɈړD
		 */
		TMEVT_NODE(index) = TMEVT_NODE(child);
		TMEVT_NODE(index).p_tmevtb->index = index;

		/*
		 *  indexqm[ḧʒuɍXVD
		 */
		index = child;
	}
	return(index);
}

#endif /* TOPPERS_tmedown */

/*
 *  ^CCxgq[vւ̓o^
 *
 *  p_tmevtbŎw肵^CCxgubNCtimeŎw肵Ԃo
 *  ߌɃCxg悤ɁC^CCxgq[vɓo^D
 */
#ifdef TOPPERS_tmeins

void
tmevtb_insert(TMEVTB *p_tmevtb, EVTTIM time)
{
	uint_t	index;

	/*
	 *  last_indexCNgCɑ}ʒuTD
	 */
	index = tmevt_up(++last_index, time);

	/*
	 *  ^CCxgindeẍʒuɑ}D
	 */ 
	TMEVT_NODE(index).time = time;
	TMEVT_NODE(index).p_tmevtb = p_tmevtb;
	p_tmevtb->index = index;
}

#endif /* TOPPERS_tmeins */

/*
 *  ^CCxgq[v̍폜
 */
#ifdef TOPPERS_tmedel

void
tmevtb_delete(TMEVTB *p_tmevtb)
{
	uint_t	index = p_tmevtb->index;
	uint_t	parent;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  폜ɂ^CCxgq[vɂȂꍇ͉ȂD
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  폜m[ḧʒuɍŌ̃m[hilast_index+1̈ʒũm[hj
	 *  }CK؂ȈʒuֈړDۂɂ́CŌ̃m[h
	 *  ۂɑ}̂ł͂ȂC폜m[ḧʒum[hɂ
	 *  ̂ŁCŌ̃m[h}ׂʒu֌ċm[hړ
	 *  D
	 *  Ō̃m[h̃CxgC폜m[h̐em[h̃C
	 *  xgȌꍇɂ́CɌđ}ʒuTD
	 *  łȂꍇɂ́CɌĒTD
	 */
	if (index > 1 && EVTTIM_LT(event_time,
								TMEVT_NODE(parent = PARENT(index)).time)) {
		/*
		 *  em[hindeẍʒuɈړD
		 */
		TMEVT_NODE(index) = TMEVT_NODE(parent);
		TMEVT_NODE(index).p_tmevtb->index = index;

		/*
		 *  폜m[h̐em[hɌđ}ʒuTD
		 */
		index = tmevt_up(parent, event_time);
	}
	else {
		/*
		 *  폜m[h牺Ɍđ}ʒuTD
		 */
		index = tmevt_down(index, event_time);
	}

	/*
	 *  Ō̃m[hindeẍʒuɑ}D
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).p_tmevtb->index = index;
}

#endif /* TOPPERS_tmedel */

/*
 *  ^CCxgq[v̐擪̃m[h̍폜
 */
Inline void
tmevtb_delete_top(void)
{
	uint_t	index;
	EVTTIM	event_time = TMEVT_NODE(last_index).time;

	/*
	 *  폜ɂ^CCxgq[vɂȂꍇ͉ȂD
	 */
	if (--last_index == 0) {
		return;
	}

	/*
	 *  [gm[hɍŌ̃m[hilast_index + 1 ̈ʒũm[hj
	 *  }CK؂ȈʒuֈړDۂɂ́CŌ̃m[h
	 *  ۂɑ}̂ł͂ȂC[gm[hm[hɂȂ̂ŁC
	 *  ̃m[h}ׂʒu֌ċm[hړD
	 */
	index = tmevt_down(1, event_time);

	/*
	 *  Ō̃m[hindeẍʒuɑ}D
	 */ 
	TMEVT_NODE(index) = TMEVT_NODE(last_index + 1);
	TMEVT_NODE(index).p_tmevtb->index = index;
}

/*
 *  ^CCxg܂ł̎c莞Ԃ̌vZ
 */
#ifdef TOPPERS_tmeltim

RELTIM
tmevt_lefttim(TMEVTB *p_tmevtb)
{
	EVTTIM	time;

	time = TMEVT_NODE(p_tmevtb->index).time;
	if (EVTTIM_LE(time, next_time)) {
		/*
		 *  ̃^CeBbNŏꍇɂ0ԂD
		 */
		return(0U);
	}
	else {
		return((RELTIM)(time - base_time));
	}
}

#endif /* TOPPERS_tmeltim */

/*
 *  ^CeBbN̋
 */
#ifdef TOPPERS_sigtim

void
signal_time(void)
{
	TMEVTB	*p_tmevtb;

	assert(sense_context());
	assert(!i_sense_lock());

	i_lock_cpu();

	/*
	 *  current_timeXVD
	 */
	current_time = next_time;

	/*
	 *  next_timeCnext_subtimeXVD
	 */
#if TIC_DENO == 1U
	next_time = current_time + TIC_NUME;
#else /* TIC_DENO == 1U */
	next_subtime += TIC_NUME % TIC_DENO;
	next_time = current_time + TIC_NUME / TIC_DENO;
	if (next_subtime >= TIC_DENO) {
		next_subtime -= TIC_DENO;
		next_time += 1U;
	}
#endif /* TIC_DENO == 1U */

	/*
	 *  current_timeCxg̑i܂͓j^CCx
	 *  gC^CCxgq[v폜CR[obN֐Ă
	 *  oD
	 */
	while (last_index > 0 && EVTTIM_LE(TMEVT_NODE(1).time, current_time)) {
		p_tmevtb = TMEVT_NODE(1).p_tmevtb;
		tmevtb_delete_top();
		(*(p_tmevtb->callback))(p_tmevtb->arg);
	}

	/*
	 *  min_timeXVD
	 */
	min_time = current_time;

	i_unlock_cpu();
}

#endif /* TOPPERS_sigtim */
