﻿//------------------------------------------------------------------------------
// Embedded Software Simulation Base Classes
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: Caret.cs 86 2011-04-04 09:35:04Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace SimBase
{
	public class UnitInterfaceAdpt : IUnitInterface, IUnitInterfaceAdpt
	{
		IUnitInterface m_UnitInterface;
		IUnitSim m_UnitSim;
		string m_InterfaceName;

		public UnitInterfaceAdpt(IUnitInterface unitInterface, IUnitSim unitSim)
		{
			m_UnitInterface = unitInterface;
			m_InterfaceName = unitInterface.InterfaceName;
			m_UnitSim = unitSim;
		}

		public IUnitInterface Target
		{
			get { return m_UnitInterface; }
			set { m_UnitInterface = value; }
		}

		#region IUnitInterface メンバ

		public string InterfaceName
		{
			get { return m_InterfaceName; }
		}

		public IUnitSim UnitSim
		{
			get { return m_UnitSim; }
		}

		#endregion

		public static bool Is<C>(IUnitInterface item) where C : class
		{
			C cast = item as C;
			if (cast == null)
			{
				IUnitInterfaceAdpt adpt = item as IUnitInterfaceAdpt;
				cast = adpt.Target as C;
			}

			return cast != null;
		}

		public static C As<C>(IUnitInterface item) where C : class
		{
			C cast = item as C;
			if (cast == null)
			{
				IUnitInterfaceAdpt adpt = item as IUnitInterfaceAdpt;
				cast = adpt.Target as C;
			}

			return cast;
		}
	}
}
