/*
  Tiny sprintf module
   for Embedded microcontrollers
   File Version : 1.0
   Yasuhiro ISHII 2005

   yo[WAbvz
   0.1 : Ƃ肠Ȃ񂩓
   0.2 : decimal0\Ή   20050313
   0.3 : hexa decimal0\Ή 20050313
   0.4 : \[X̕ςȃR[h(^M)폜 20050503
   0.5 : tsprintf֐̕ϐ size悤ɂ 20050503
   0.6 : %d̕Ή,%xunsigned 20050522
   0.7 : %d,%x̌w(%[n]d)/0⊮w(%0[n]d)Ή 20050522
   0.8 : va_listœnvtsprintf쐬Avsprintfvtsprintf̐e֐ɂ 20050522
   0.9 : hexŁAl0̎Ɍ1ɂȂĂ܂oOC 20050526
   1.0 : decŁAl0̎Ɍ1ɂȂĂ܂oOC 20050629
   
   printf̏ݒȈՓIȂ̂ɂĎĂ̂Ŏgpɂ
   mFĉB

*/

#include <stdarg.h>

int tsprintf(char* ,char* , ...);
int vtsprintf(char* buff,char* fmt,va_list arg);

static int tsprintf_string(char* ,char* );
static int tsprintf_char(int ,char* );
static int tsprintf_decimal(signed long,char* ,int ,int );
static int tsprintf_hexadecimal(unsigned long ,char* ,int ,int ,int );

/*
  Tiny sprintf֐
*/
int tsprintf(char* buff,char* fmt, ...){
	va_list arg;
	int len;

	len = 0;
	va_start(arg, fmt);

	len = vtsprintf(buff,fmt,arg);
	
	va_end(arg);
	return len;
}

int vtsprintf(char* buff,char* fmt,va_list arg){
	int len;
	int size;
	int zeroflag,width;

	size = 0;
	len = 0;

	while(*fmt){
		if(*fmt=='%'){		/* % Ɋւ鏈 */
			zeroflag = width = 0;
			fmt++;

			if (*fmt == '0'){
				fmt++;
				zeroflag = 1;
			}
			if ((*fmt >= '0') && (*fmt <= '9')){
				width = *(fmt++) - '0';
			}

			/* printf ("zerof = %d,width = %d\n",zeroflag,width); */

			switch(*fmt){
			case 'd':		/* 10i */
				size = tsprintf_decimal(va_arg(arg,signed long),buff,zeroflag,width);
				break;
			case 'x':		/* 16i 0-f */
				size = tsprintf_hexadecimal(va_arg(arg,unsigned long),buff,0,zeroflag,width);
				break;
			case 'X':		/* 16i 0-F */
				size = tsprintf_hexadecimal(va_arg(arg,unsigned long),buff,1,zeroflag,width);
				break;
			case 'c':		/* LN^[ */
				size = tsprintf_char(va_arg(arg,int),buff);
				break;
			case 's':		/* ASCIIZ */
				size = tsprintf_string(va_arg(arg,char*),buff);
				break;
			default:		/* Rg[R[hȊO̕ */
				/* %%(%ɑΉ)͂őΉ */
				len++;
				*(buff++) = *fmt;
				break;
			}
			len += size;
			buff += size;
			fmt++;
		} else {
			*(buff++) = *(fmt++);
			len++;
		}
	}

	*buff = '\0';		/* I[ */

	va_end(arg);
	return (len);
}




/*
  l => 10iϊ
*/
static int tsprintf_decimal(signed long val,char* buff,int zf,int wd){
	int i;
	char tmp[10];
	char* ptmp = tmp + 9;
	int len = 0;
	int minus = 0;

	if (!val){		/* wl0̏ꍇ */
		*(ptmp--) = '0';
		len++;
	} else {
		/* }CiX̒l̏ꍇɂ2̕␔ */
		if (val < 0){
			val = ~val;
			val++;
			minus = 1;
		}
		while (val){
			/* obt@A_[t[΍ */
			if (len >= 8){
				break;
			}
	
			*ptmp = (val % 10) + '0';
			val /= 10;
			ptmp--;
			len++;
		}

	}

	/* A킹Ɋւ鏈 */
	if (zf){
		if (minus){
			wd--;
		}
		while (len < wd){
			*(ptmp--) =  '0';
			len++;
		}
		if (minus){
			*(ptmp--) = '-';
			len++;
		}
	} else {
		if (minus){
			*(ptmp--) = '-';
			len++;
		}
		while (len < wd){
			*(ptmp--) =  ' ';
			len++;
		}
	}

	/* ̃obt@Rs[ */
	for (i=0;i<len;i++){
		*(buff++) = *(++ptmp);
	}

	return (len);
}

/*
  l => 16iϊ
*/
static int tsprintf_hexadecimal(unsigned long val,char* buff,
								int capital,int zf,int wd){
	int i;
	char tmp[10];
	char* ptmp = tmp + 9;
	int len = 0;
	char str_a;

	/* A`F啶ɂ邩ɂ邩؂ւ */
	if (capital){
		str_a = 'A';
	} else {
		str_a = 'a';
	}
	
	if (!val){		/* wl0̏ꍇ */
		*(ptmp--) = '0';
		len++;
	} else {
		while (val){
			/* obt@A_[t[΍ */
			if (len >= 8){
				break;
			}

			*ptmp = (val % 16);
			if (*ptmp > 9){
				*ptmp += str_a - 10;
			} else {
				*ptmp += '0';
			}
		
			val >>= 4;		/* 16Ŋ */
			ptmp--;
			len++;
		}
	}
	while (len < wd){
		*(ptmp--) =  zf ? '0' : ' ';
		len++;
	}
		
	for (i=0;i<len;i++){
		*(buff++) = *(++ptmp);
	}

	return(len);
}

/*
  l => 1LN^ϊ
*/
static int tsprintf_char(int ch,char* buff){
	*buff = (char)ch;
	return(1);
}

/*
  l => ASCIIZϊ
*/
static int tsprintf_string(char* str,char* buff){
	int count = 0;
	while(*str){
		*(buff++) = *str;
		str++;
		count++;
	}
	return(count);
}

