#ifndef ET_UTILITYSTUFF_H
#define ET_UTILITYSTUFF

#include "GyroSensor.h"
#include "LightSensor.h"
#include "Clock.h"

namespace ecrobot{
    class TouchSensor;
    class ETTailControl;
    class Lcd;
    class Speaker;
    struct ETBluetoothString{
        static const char* PASS_KEY;
        static const char CMD_START;
        static const char CMD_STOP;
    };

    namespace ETUtilityStuff{
        bool IsBluetoothReceived(char cmd);
        bool Istouched(ecrobot::TouchSensor& touch,ecrobot::ETTailControl& tailcontroler);
        void Waitstart(ecrobot::TouchSensor& touch,ecrobot::ETTailControl& tailcontroler,char cmd);
        void DisplayCalibResult(Lcd& lcd,
                                Speaker& speaker,
                                char* disp,
                                const unsigned long offset,
                                const int tone,
                                const unsigned long y);

            template<class T>
            struct traits{
                unsigned long foo(T& x){
                    return 0;
                }
            };

            //traitsクラス（デフォルトはアルゴリズムA）
            template<>
            struct traits<GyroSensor>{
                static unsigned long foo(GyroSensor& x){
                    return x.get();
                }
            };
            //traitsクラス（Hoge型はアルゴリズムB）
            template<>
            struct traits<LightSensor>{
                static unsigned long foo(LightSensor& x){
                    return x.getBrightness();
                }
            };

            //タグごとに処理を切り替えて実行
            template<class T>
            unsigned long GetOffset(T & x,Clock& clock){
                const int sum_num = 256;
                unsigned long sum = 0;
                for(int i=0;i<sum_num;i++){
                    sum += traits<T>::foo(x);
                    clock.wait(10);
                }
                return sum / sum_num;
            }
    }
}
#endif	/* ET_UTILITYSTUFF */
