package jp.osoite.tomu.xmpp.util;

/**
 * XMPPアカウント情報を格納するためのクラスです．
 * @author shima
 */
public final class XMPPSetting {

    private final static String HOST = "talk.google.com";
    private final static int PORT = 5222;
    private final static String SERVICE = "gmail.com";
    private String host = HOST;
    private int port = PORT;
    private String service = SERVICE;
    private String password;
    private String myAccount;

    /**
     * コンストラクタ
     * @param account アカウント
     * @param pass パスワード
     */
    public XMPPSetting(String account, String pass) {
        this.myAccount = account;
        this.password = pass;
    }

    /**
     * コンストラクタ
     * @param account アカウント
     * @param pass パスワード
     * @param host ホスト名
     * @param port ポート番号
     * @param service サービス名
     */
    public XMPPSetting(String account, String pass, String host, int port, String service) {
        this.myAccount = account;
        this.password = pass;
        this.host = host;
        this.port = port;
        this.service = service;
    }

    /**
     * パスワードを取得します．
     * @return パスワード
     */
    public String getPassword() {
        return password;
    }

    /**
     * アカウントを取得します．
     * @return アカウント
     */
    public String getAccount() {
        return myAccount;
    }

    /**
     * ホストを取得します．
     * @return ホスト名
     */
    public String getHost() {
        return host;
    }

    /**
     * ポート番号を取得します．
     * @return ポート番号
     */
    public int getPort() {
        return port;
    }

    /**
     * サービス名を取得します．
     * @return サービス名
     */
    public String getService() {
        return service;
    }
}
