package jp.osoite.tomu.xml.sax;

import java.io.StringReader;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

public class SAXReader {

    private XMLReader parser;
    private static final String PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private DefaultHandler sh;

    public SAXReader(DefaultHandler sh) {
        this.sh = sh;
        try {
            parser = XMLReaderFactory.createXMLReader(PARSER_NAME);
        } catch (SAXException ex) {}
    }

    public void reading(String xml) {
        try {
            parser.setContentHandler(sh);
            parser.parse(new InputSource(new StringReader(xml)));
        } catch (Exception e) {
            //e.printStackTrace();
        }
    }

}
