package jp.osoite.tomu.xml.sax;

import jp.osoite.tomu.xml.jaxb.util.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;

public class MessageTypeSelectHandler extends DefaultHandler {

    private boolean isTypeTag;
    private TomuMessageType type;

    @Override
    public void startDocument() throws SAXException {
        isTypeTag = false;
        type = null;
    }

    @Override
    public void endDocument() throws SAXException {
        // no operation
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(XMLTags.MSG_TYPE)) {
            isTypeTag = true;
        }
    }

    @Override
    public void endElement(String uri, String elname, String qualifiedName) {
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (isTypeTag) {
            String word = new String(ch, start, length);
            if(word.equals(TomuMessageType.APPS_REQUEST.toString())){
                type = TomuMessageType.APPS_REQUEST;
            } else if(word.equals(TomuMessageType.APPS_RESPONSE.toString())) {
                type = TomuMessageType.APPS_RESPONSE;
            } else if(word.equals(TomuMessageType.CORE_MANAGEMENT.toString())) {
                type = TomuMessageType.CORE_MANAGEMENT;
            } else if(word.equals(TomuMessageType.CORE_REQUEST.toString())) {
                type = TomuMessageType.CORE_REQUEST;
            } else if(word.equals(TomuMessageType.CORE_RESPONSE.toString())) {
                type = TomuMessageType.CORE_RESPONSE;
            } else if(word.equals(TomuMessageType.SOURCE_REQUEST.toString())) {
                type = TomuMessageType.SOURCE_REQUEST;
            } else if(word.equals(TomuMessageType.SOURCE_UPLOAD.toString())) {
                type = TomuMessageType.SOURCE_UPLOAD;
            }
        }
    }

    public TomuMessageType getMessageType(){
        return type;
    }
    
}